# coding: utf-8

"""
    Mail-in-a-Box

    Mail-in-a-Box API HTTP specification.  # Introduction This API is documented in [**OpenAPI format**](http://spec.openapis.org/oas/v3.0.3). ([View the full HTTP specification](https://raw.githubusercontent.com/mail-in-a-box/mailinabox/api-spec/api/mailinabox.yml).)  All endpoints are relative to `https://{host}/admin` and are secured with [`Basic Access` authentication](https://en.wikipedia.org/wiki/Basic_access_authentication). If you have multi-factor authentication enabled, authentication with a `user:password` combination will fail unless a valid OTP is supplied via the `x-auth-token` header. Authentication via a `user:user_key` pair is possible without the header being present.   # noqa: E501

    The version of the OpenAPI document: 0.51.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailinabox_api.configuration import Configuration


class MailUser(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "email": "str",
        "privileges": "list[MailUserPrivilege]",
        "status": "MailUserStatus",
        "mailbox": "str",
    }

    attribute_map = {
        "email": "email",
        "privileges": "privileges",
        "status": "status",
        "mailbox": "mailbox",
    }

    def __init__(
        self,
        email=None,
        privileges=None,
        status=None,
        mailbox=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """MailUser - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._email = None
        self._privileges = None
        self._status = None
        self._mailbox = None
        self.discriminator = None

        self.email = email
        self.privileges = privileges
        self.status = status
        if mailbox is not None:
            self.mailbox = mailbox

    @property
    def email(self):
        """Gets the email of this MailUser.  # noqa: E501

        Email format.  # noqa: E501

        :return: The email of this MailUser.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this MailUser.

        Email format.  # noqa: E501

        :param email: The email of this MailUser.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and email is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `email`, must not be `None`"
            )  # noqa: E501

        self._email = email

    @property
    def privileges(self):
        """Gets the privileges of this MailUser.  # noqa: E501


        :return: The privileges of this MailUser.  # noqa: E501
        :rtype: list[MailUserPrivilege]
        """
        return self._privileges

    @privileges.setter
    def privileges(self, privileges):
        """Sets the privileges of this MailUser.


        :param privileges: The privileges of this MailUser.  # noqa: E501
        :type: list[MailUserPrivilege]
        """
        if (
            self.local_vars_configuration.client_side_validation and privileges is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `privileges`, must not be `None`"
            )  # noqa: E501

        self._privileges = privileges

    @property
    def status(self):
        """Gets the status of this MailUser.  # noqa: E501


        :return: The status of this MailUser.  # noqa: E501
        :rtype: MailUserStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this MailUser.


        :param status: The status of this MailUser.  # noqa: E501
        :type: MailUserStatus
        """
        if (
            self.local_vars_configuration.client_side_validation and status is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `status`, must not be `None`"
            )  # noqa: E501

        self._status = status

    @property
    def mailbox(self):
        """Gets the mailbox of this MailUser.  # noqa: E501


        :return: The mailbox of this MailUser.  # noqa: E501
        :rtype: str
        """
        return self._mailbox

    @mailbox.setter
    def mailbox(self, mailbox):
        """Sets the mailbox of this MailUser.


        :param mailbox: The mailbox of this MailUser.  # noqa: E501
        :type: str
        """

        self._mailbox = mailbox

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MailUser):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MailUser):
            return True

        return self.to_dict() != other.to_dict()
