# django-billdesk

<h3>Usage</h3>
An tool to ease the process to integrate billdesk payment gateway with your <b>django</b> project.
All you need to do is to create these variables in your settings.py file.

```
MID = '<merchant-id>'
SEC_ID = '<sercet-id>'

BILL_URL = 'https://uat.billdesk.com/pgidsk/PGIMerchantPayment'
CONF_BILL_URL = 'https://uat.billdesk.com/pgidsk/PGIQueryController'
CHECKSUM_KEY = '<checksum-key>'
REVERSE_URL = '<reverse url>'
```


To know excatly what these variables mean have at look at my <a href='https://gist.github.com/FerociousCentaur/8f1b7a4de9f0122e5766766554a9aeb1'>gist</a>

<h4>STEP 1</h4>
Now to use this in your project,you simply need to do


```
from django_billdesk import ResponseMessage, GetMessage
```


<h4>STEP 2</h4>
Now GetMessage gives the message to be posted in the required format along with the checksum.
All you need to do is


```
msg = GetMessage().message(uniqueID, amount, ExInfo1, ExInfo2, ExInfo3, ExInfo4)
```


<b>NOTE:</b> 
1. uniqueID mentioned above should be truely unique for all the transactions requested by you.If not, the transaction will be declined by billdesk.
2. The order of arguments being passed should not be changed.
3. Atleast 4 (billdesk says 3 but for extra security) ExtraInfo should be passed about the transaction.
For ex - emailId of person making transaction, his phone number, his name, his ID in your company or website.<br>

<b>Suggested format</b>


```
msg = GetMessage().message(uniqueID, amount, some_id, email, name, mnumber)
```


<b>Important : </b>some_id shouldn't be confused with uniqueID. uniqueID will be created by you everytime a transaction is requested and is ensured that it is truely unique and never before has any request been made with the same id, whereas some_id is the id which you allocate to a user when he or she registers on your site.
So a same person, when will make multiple transactions, will have same 'some_id' but different uniqueID<br>

<h4>STEP 3</h4>
Now make a 'POST' request to the billdesk url with the msg you obtained. 
You can obtain the template and complete code to do so from my <a href='https://gist.github.com/FerociousCentaur/8f1b7a4de9f0122e5766766554a9aeb1'>gist</a>
<h4>STEP 4</h4>
Now you will receive a response at the return url.
You will send that resposne to ResponseMessage as shown:


```
values = ResponseMessage.respMsg(<The response msg>)
```


<b>Note : </b>
1. Make sure your function which is called at response url is csrf exempted as you are receiving a POST request from a website outside of your domain.
2. You will get a dictionary in the variable 'values' as mentioned above. But before doing anything make sure the variable 'values' is not False.


```
if values not False:
    <do everything in here>
```


cuz if the value is false, it means there had been a breach as <b>Checksum verification</b> failed.

<h4>STEP 4</h4>
Now you can update your database based on the response and values in the variable 'values' <br>
<b>Structure</b> of 'values':


```
{'MID': '', 'OrderID': '', 'TaxnNo': '', 'AMNT': '', 'TStat': '', 'DnT': '', 'TMode': ''}
```


All the variables in the dictionary above will hold values as received in the response message from billdesk

1. MID = will hold the merchant ID to which payment was made
2. OrderID = will hold the unique order id for the transaction
3. TaxnNo = will hold the unique taxation number generated by the respective bank
4. AMNT = will hold the amount for which the transaction was made
5. TStat = will hold the transaction status number. <a href='https://gist.github.com/FerociousCentaur/8f1b7a4de9f0122e5766766554a9aeb1'>See the possible outcomes and their meaning</a>
6. DnT = will hold the date and time at which the transaction was made.
7. TMode = will hold the mode of transaction. For ex- UPI, Internet Banking.

<h2>Extra</h2>

<h4>STEP 1</h4>
All the transactions may not get successful instantly and sometimes give status as PENDING which generally means that BillDesk is waiting for the response from the bank. In such cases you need to verify again with billdesk about the payment through Query Api.The message sent using query API has a bit different format and can be achieved using


```
msg = GetMessage().schedule_msg(uniqueID)
```

'msg' will have the message to be sent using POST method.
<b>NOTE :</b>You can Python's `requests` module to send POST requests to the Query API but while sending POST requests for the payment request,you need to do it from template forms like this so that the user can be properly redirected to billdesk page.


```
<html>
<body>
<form action="{{url}}" method="post" name="billdesk">
    <input name="msg" type="hidden" value="{{msg}}">
</form>
</body>
<script>

  document.billdesk.submit();
</script>
</html>
```


<h4>STEP 2</h4>
To access the values returned by billdesk for the Query API, pass the response like this to,


```
values = ResponseMessage.schedule_resp(<the recieved response>)
```

Now again proceed only after making sure that values is not equal to False.If it is not,then it will hold a dictionary with the following structure.


```
{'MID': '', 'OrderID': '', 'TaxnNo': '', 'AMNT': '', 'TStat': '', 'RfndStat': ''}
```

Variables have their usual meaning as stated above.`RfndStat` contains the refund status of the transaction.<br>
<b>Important</b> Always use <a href='https://gist.github.com/FerociousCentaur/8f1b7a4de9f0122e5766766554a9aeb1'>combination</a> of auth status and refund status to update you database.