"""
Provides a utils function to setup the logger.
"""
import os
import logging


def setup_logger(logger_name=None):
    """
    Get the logger. The log level is set through the `LOG_LEVEL` environment variable.

    Args:
        logger_name (str): The name of the logger.
    Returns:
        logging.Logger: The logger.
    """
    logger = logging.getLogger(logger_name)
    handler = logging.StreamHandler()
    formatter = logging.Formatter(
        "%(levelname)s - %(name)s - %(asctime)s - %(message)s",
        datefmt="%m/%d/%Y %I:%M:%S %p",
    )
    handler.setFormatter(formatter)
    logger.addHandler(handler)
    logger.setLevel(os.environ.get("LOG_LEVEL", "INFO"))
    return logger
