<p align="center">
  <img width="120" alt="portfolio_view" src="https://raw.githubusercontent.com/ismet55555/yojenkins/main/docs/source/logo_final.png">
</p>

<h1 align="center">yojenkins</h1>


<p align="center">

<a href="https://pypi.org/project/yojenkins/">
  <img alt="PYPI Version" src="https://img.shields.io/pypi/v/yojenkins?color=blue">
</a>

<a href="https://pypi.org/project/yojenkins/">
  <img alt="Python Versions" src="https://img.shields.io/pypi/pyversions/yojenkins">
</a>

<a href="https://pypi.org/project/yojenkins/">
  <img alt="PYPI Status" src="https://img.shields.io/pypi/status/yojenkins">
</a>

<a href="https://github.com/ismet55555/yojenkins/blob/main/LICENSE">
  <img alt="Licence" src="https://img.shields.io/pypi/l/yojenkins">
</a>

<a href="https://github.com/ismet55555/yojenkins/actions/workflows/test-build-publish.yml">
  <img alt="Workflow" src="https://github.com/ismet55555/yojenkins/actions/workflows/test-build-publish.yml/badge.svg">
</a>

</p>


**`yojenkins`** is a cross-platform command line interface (CLI) tool to monitor, manage, and deal with Jenkins server. It makes it possible to interact with a Jenkins server without using the browser based Jenkins UI.

This tool is able to be integrated into a script as middleware in order to automate Jenkins related tasks or enable Jenkins configuration as code.

**`yojenkins` will liberate you and your browser from the Jenkins Web UI**

With **`yojenkins`** you can manage:

- **Authentication**: *Authentication structure similar to AWS API*
- **Server**: *Create, shutdown, view queue, and more*
- **User accounts**: *Create, delete, add/remove permission, and more*
- **Nodes/agents:** *Create, delete, shut down server, and more*
- **Credentials**: *Create, update, delete, list, and more*
- **Folders:** *Create items, delete items, disable, enable, and more*
- **Jobs:** *Create, delete, trigger, monitor, search, and more*
- **Builds:** *Monitor, abort, tail logs, follow logs, and more*
- **Stages:** *Get info, get logs, view steps, view status*
- **Steps:** *Get info*
- **Other tools and functions:** *Run groovy scripts remotely, run custom REST calls, setup a shared library, view command usage history, and more*


## :blue_book: Documentation

For all information and documentation, please visit [yojenkins.com](https://yojenkins.com)


## :movie_camera: Overview Video

This video presents an overview of `yojenkins`, while demonstrating a few basic funcitonalities and workflow.

<a target="_blank" rel="noopener noreferrer" href="https://youtu.be/w1p-eMzKuLE">
  <img width="35%" alt="overview_video" style="border:2px solid black;" src="https://img.youtube.com/vi/w1p-eMzKuLE/hqdefault.jpg">
</a>


## :ballot_box_with_check: Project Status

This project is in release phase **alpha**. Please report any issues, odd behavior, or suggestions.
This does not mean that this project is not usable. It just means that the project is still in development.
  - Read more about the [release cycle](https://en.wikipedia.org/wiki/Software_release_life_cycle).
  - See [Bug Reports](https://www.yojenkins.com/bug_report/) and [Feature Requests](https://www.yojenkins.com/feature_request/)


## :heartbeat: Help this Project!

This is a very young project and I am always looking for help in any way. If you like this project, please consider helping.

  - For financial or marketing support options see [Support This Project!](https://www.yojenkins.com/support/).
  - To contribute to this project, see [Contribute to This Project!](https://www.yojenkins.com/contribute/).
