# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 layer_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 stack_id: pulumi.Input[str],
                 agent_version: Optional[pulumi.Input[str]] = None,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 architecture: Optional[pulumi.Input[str]] = None,
                 auto_scaling_type: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceMappingArgs']]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 elastic_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 root_device_type: Optional[pulumi.Input[str]] = None,
                 ssh_key_name: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenancy: Optional[pulumi.Input[str]] = None,
                 time_based_auto_scaling: Optional[pulumi.Input['InstanceTimeBasedAutoScalingArgs']] = None,
                 virtualization_type: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "layer_ids", layer_ids)
        pulumi.set(__self__, "stack_id", stack_id)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if ami_id is not None:
            pulumi.set(__self__, "ami_id", ami_id)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if auto_scaling_type is not None:
            pulumi.set(__self__, "auto_scaling_type", auto_scaling_type)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if elastic_ips is not None:
            pulumi.set(__self__, "elastic_ips", elastic_ips)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if install_updates_on_boot is not None:
            pulumi.set(__self__, "install_updates_on_boot", install_updates_on_boot)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if root_device_type is not None:
            pulumi.set(__self__, "root_device_type", root_device_type)
        if ssh_key_name is not None:
            pulumi.set(__self__, "ssh_key_name", ssh_key_name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)
        if time_based_auto_scaling is not None:
            pulumi.set(__self__, "time_based_auto_scaling", time_based_auto_scaling)
        if virtualization_type is not None:
            pulumi.set(__self__, "virtualization_type", virtualization_type)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="layerIds")
    def layer_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "layer_ids")

    @layer_ids.setter
    def layer_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "layer_ids", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "stack_id", value)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_version", value)

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ami_id")

    @ami_id.setter
    def ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami_id", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter(name="autoScalingType")
    def auto_scaling_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_scaling_type")

    @auto_scaling_type.setter
    def auto_scaling_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_scaling_type", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceMappingArgs']]]]:
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="elasticIps")
    def elastic_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "elastic_ips")

    @elastic_ips.setter
    def elastic_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "elastic_ips", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="installUpdatesOnBoot")
    def install_updates_on_boot(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "install_updates_on_boot")

    @install_updates_on_boot.setter
    def install_updates_on_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_updates_on_boot", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter(name="rootDeviceType")
    def root_device_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "root_device_type")

    @root_device_type.setter
    def root_device_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_device_type", value)

    @property
    @pulumi.getter(name="sshKeyName")
    def ssh_key_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ssh_key_name")

    @ssh_key_name.setter
    def ssh_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_key_name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy", value)

    @property
    @pulumi.getter(name="timeBasedAutoScaling")
    def time_based_auto_scaling(self) -> Optional[pulumi.Input['InstanceTimeBasedAutoScalingArgs']]:
        return pulumi.get(self, "time_based_auto_scaling")

    @time_based_auto_scaling.setter
    def time_based_auto_scaling(self, value: Optional[pulumi.Input['InstanceTimeBasedAutoScalingArgs']]):
        pulumi.set(self, "time_based_auto_scaling", value)

    @property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "virtualization_type")

    @virtualization_type.setter
    def virtualization_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtualization_type", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "volumes", value)


warnings.warn("""Instance is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class Instance(pulumi.CustomResource):
    warnings.warn("""Instance is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 architecture: Optional[pulumi.Input[str]] = None,
                 auto_scaling_type: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceBlockDeviceMappingArgs']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 elastic_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 layer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 root_device_type: Optional[pulumi.Input[str]] = None,
                 ssh_key_name: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenancy: Optional[pulumi.Input[str]] = None,
                 time_based_auto_scaling: Optional[pulumi.Input[pulumi.InputType['InstanceTimeBasedAutoScalingArgs']]] = None,
                 virtualization_type: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::OpsWorks::Instance

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::OpsWorks::Instance

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 architecture: Optional[pulumi.Input[str]] = None,
                 auto_scaling_type: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceBlockDeviceMappingArgs']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 elastic_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 layer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 root_device_type: Optional[pulumi.Input[str]] = None,
                 ssh_key_name: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenancy: Optional[pulumi.Input[str]] = None,
                 time_based_auto_scaling: Optional[pulumi.Input[pulumi.InputType['InstanceTimeBasedAutoScalingArgs']]] = None,
                 virtualization_type: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        pulumi.log.warn("""Instance is deprecated: Instance is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["agent_version"] = agent_version
            __props__.__dict__["ami_id"] = ami_id
            __props__.__dict__["architecture"] = architecture
            __props__.__dict__["auto_scaling_type"] = auto_scaling_type
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["block_device_mappings"] = block_device_mappings
            __props__.__dict__["ebs_optimized"] = ebs_optimized
            __props__.__dict__["elastic_ips"] = elastic_ips
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["install_updates_on_boot"] = install_updates_on_boot
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            if layer_ids is None and not opts.urn:
                raise TypeError("Missing required property 'layer_ids'")
            __props__.__dict__["layer_ids"] = layer_ids
            __props__.__dict__["os"] = os
            __props__.__dict__["root_device_type"] = root_device_type
            __props__.__dict__["ssh_key_name"] = ssh_key_name
            if stack_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_id'")
            __props__.__dict__["stack_id"] = stack_id
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tenancy"] = tenancy
            __props__.__dict__["time_based_auto_scaling"] = time_based_auto_scaling
            __props__.__dict__["virtualization_type"] = virtualization_type
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["private_dns_name"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_dns_name"] = None
            __props__.__dict__["public_ip"] = None
        super(Instance, __self__).__init__(
            'aws-native:opsworks:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InstanceArgs.__new__(InstanceArgs)

        __props__.__dict__["agent_version"] = None
        __props__.__dict__["ami_id"] = None
        __props__.__dict__["architecture"] = None
        __props__.__dict__["auto_scaling_type"] = None
        __props__.__dict__["availability_zone"] = None
        __props__.__dict__["block_device_mappings"] = None
        __props__.__dict__["ebs_optimized"] = None
        __props__.__dict__["elastic_ips"] = None
        __props__.__dict__["hostname"] = None
        __props__.__dict__["install_updates_on_boot"] = None
        __props__.__dict__["instance_type"] = None
        __props__.__dict__["layer_ids"] = None
        __props__.__dict__["os"] = None
        __props__.__dict__["private_dns_name"] = None
        __props__.__dict__["private_ip"] = None
        __props__.__dict__["public_dns_name"] = None
        __props__.__dict__["public_ip"] = None
        __props__.__dict__["root_device_type"] = None
        __props__.__dict__["ssh_key_name"] = None
        __props__.__dict__["stack_id"] = None
        __props__.__dict__["subnet_id"] = None
        __props__.__dict__["tenancy"] = None
        __props__.__dict__["time_based_auto_scaling"] = None
        __props__.__dict__["virtualization_type"] = None
        __props__.__dict__["volumes"] = None
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "ami_id")

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="autoScalingType")
    def auto_scaling_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "auto_scaling_type")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceBlockDeviceMapping']]]:
        return pulumi.get(self, "block_device_mappings")

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "ebs_optimized")

    @property
    @pulumi.getter(name="elasticIps")
    def elastic_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "elastic_ips")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="installUpdatesOnBoot")
    def install_updates_on_boot(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "install_updates_on_boot")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="layerIds")
    def layer_ids(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "layer_ids")

    @property
    @pulumi.getter
    def os(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="privateDnsName")
    def private_dns_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "private_dns_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicDnsName")
    def public_dns_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "public_dns_name")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="rootDeviceType")
    def root_device_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "root_device_type")

    @property
    @pulumi.getter(name="sshKeyName")
    def ssh_key_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "ssh_key_name")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "stack_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tenancy(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "tenancy")

    @property
    @pulumi.getter(name="timeBasedAutoScaling")
    def time_based_auto_scaling(self) -> pulumi.Output[Optional['outputs.InstanceTimeBasedAutoScaling']]:
        return pulumi.get(self, "time_based_auto_scaling")

    @property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "virtualization_type")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "volumes")

