# 通用工具集
这是一个通用工具集, 适用于>=Python3.8

## 1. 准备
### 1.1 安装依赖
```
pip3 install --upgrade packaging setuptools wheel twine
```

## 2. 命令说明

### 2.1 打包
```
python3 setup.py sdist bdist_wheel
```
在当前dist目录下的两个文件是要上传到 PyPi 网站上供别人下载安装的（*.tar.gz、*.whl）

### 2.2 配置文件检查
```
python3 setup.py check
```

### 2.3 上传前检查
```
twine check dist/*
```
### 2.5 执行上传
```
twine upload dist/*
```
### 2.6清理
```
rm -rf build/ dist/ *.egg-info/
```
## 3. 其他说明
- 本地安装使用(本地安装而不使用pip安装)
```
python3 setup.py install
```
- 安装此工具包
```
pip3 install easy_use_tools -i https://pypi.org/simple/
```
- 升级此工具包
```
pip3 install --upgrade easy_use_tools -i https://pypi.org/simple/
```
## 4. 使用说明
详见当前项目的README_USE.md文件
