import os
from importlib.machinery import SourceFileLoader

from pkg_resources import parse_requirements
from setuptools import find_packages, setup


module_name = 'rethinkdbcm'

# Модуль может быть еще не установлен (или установлена другая версия), поэтому
# необходимо загружать __init__.py с помощью machinery.
module = SourceFileLoader(
    module_name, os.path.join(module_name, '__init__.py')
).load_module()


def load_requirements(fname: str) -> list:
    requirements = []
    with open(fname, 'r') as fp:
        for req in parse_requirements(fp.read()):
            #extras = '[{}]'.format(','.join(req.extras)) if req.extras else ''
            #requirements.append('{}{}{}'.format(req.name, extras, req.specifier))
            requirements.append('{}{}'.format(req.name, req.specifier))
    return requirements


setup(
    name=module_name,
    version=module.__version__,
    author=module.__author__,
    author_email=module.__email__,
    license=module.__license__,
    description=module.__doc__,
    long_description=open('README.md').read(),
    url='https://github.com/gwvsol/RethinkDB-context-manager',
    platforms='all',
    classifiers=[
        'Intended Audience :: Developers',
        'Natural Language :: Russian',
        'Operating System :: POSIX',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.8'
    ],
    python_requires='>=3.8',
    packages=find_packages(),
    #packages=find_packages(exclude=['tests']),
    install_requires=load_requirements('requirements.txt'),
    #extras_require={'dev': load_requirements('requirements.dev.txt')},
    # entry_points={
    #     'console_scripts': [
    #         # f-strings в setup.py не используются из-за соображений совместимости.
    #         # Несмотря на то, что данный пакет требует python 3.6, технически
    #         # source distribution для него может собираться с помощью более
    #         # ранних версий python, не стоит лишать пользователей этой возможности.
    #         '{0}-api = {0}.api.__main__:main'.format(module_name)
    #     ]
    #},
    include_package_data=True
)