# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: secret/compute/v1beta1/genesis.proto, secret/compute/v1beta1/msg.proto, secret/compute/v1beta1/query.proto, secret/compute/v1beta1/types.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class AccessType(betterproto.Enum):
    UNDEFINED = 0
    NOBODY = 1
    ONLY_ADDRESS = 2
    EVERYBODY = 3


@dataclass(eq=False, repr=False)
class AccessTypeParam(betterproto.Message):
    value: "AccessType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class CodeInfo(betterproto.Message):
    """CodeInfo is data for the uploaded contract WASM code"""

    code_hash: bytes = betterproto.bytes_field(1)
    creator: bytes = betterproto.bytes_field(2)
    source: str = betterproto.string_field(3)
    builder: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class ContractCustomInfo(betterproto.Message):
    enclave_key: bytes = betterproto.bytes_field(1)
    label: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ContractInfo(betterproto.Message):
    """ContractInfo stores a WASM contract instance"""

    code_id: int = betterproto.uint64_field(1)
    creator: bytes = betterproto.bytes_field(2)
    # bytes admin = 3 [(gogoproto.casttype) = "github.com/cosmos/cosmos-
    # sdk/types.AccAddress"];
    label: str = betterproto.string_field(4)
    # never show this in query results, just use for sorting (Note: when using
    # json tag "-" amino refused to serialize it...)
    created: "AbsoluteTxPosition" = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class AbsoluteTxPosition(betterproto.Message):
    """AbsoluteTxPosition can be used to sort contracts"""

    # BlockHeight is the block the contract was created at
    block_height: int = betterproto.int64_field(1)
    # TxIndex is a monotonic counter within the block (actual transaction index,
    # or gas consumed)
    tx_index: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class Model(betterproto.Message):
    """Model is a struct that holds a KV pair"""

    # hex-encode key to read it better (this is often ascii)
    key: bytes = betterproto.bytes_field(1)
    # base64-encode raw value
    value: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class QueryContractInfoRequest(betterproto.Message):
    """
    QueryContractInfoRequest is the request type for the Query/ContractInfo RPC
    method
    """

    # address is the address of the contract to query
    address: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryContractInfoResponse(betterproto.Message):
    """
    QueryContractInfoResponse is the response type for the Query/ContractInfo
    RPC method
    """

    # address is the address of the contract
    address: bytes = betterproto.bytes_field(1)
    contract_info: "ContractInfo" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryContractHistoryRequest(betterproto.Message):
    # address is the address of the contract to query
    address: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryContractsByCodeRequest(betterproto.Message):
    code_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class ContractInfoWithAddress(betterproto.Message):
    """
    ContractInfoWithAddress adds the address (key) to the ContractInfo
    representation
    """

    address: bytes = betterproto.bytes_field(1)
    contract_info: "ContractInfo" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class QueryContractsByCodeResponse(betterproto.Message):
    contract_infos: List["ContractInfoWithAddress"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QuerySmartContractStateRequest(betterproto.Message):
    # address is the address of the contract
    address: bytes = betterproto.bytes_field(1)
    query_data: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class QueryContractAddressByLabelRequest(betterproto.Message):
    label: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class QueryContractKeyRequest(betterproto.Message):
    # address is the address of the contract
    address: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryContractHashRequest(betterproto.Message):
    # address is the address of the contract
    address: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QuerySmartContractStateResponse(betterproto.Message):
    data: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryCodeRequest(betterproto.Message):
    code_id: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class CodeInfoResponse(betterproto.Message):
    code_id: int = betterproto.uint64_field(1)
    creator: bytes = betterproto.bytes_field(2)
    data_hash: bytes = betterproto.bytes_field(3)
    source: str = betterproto.string_field(4)
    builder: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class QueryCodeResponse(betterproto.Message):
    code_info: "CodeInfoResponse" = betterproto.message_field(1)
    data: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class QueryCodesResponse(betterproto.Message):
    code_infos: List["CodeInfoResponse"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryContractAddressByLabelResponse(betterproto.Message):
    # address is the address of the contract
    address: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryContractKeyResponse(betterproto.Message):
    # address is the address of the contract
    key: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class QueryContractHashResponse(betterproto.Message):
    code_hash: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class DecryptedAnswer(betterproto.Message):
    """DecryptedAnswer is a struct that represents a decrypted tx-query"""

    type: str = betterproto.string_field(1)
    input: str = betterproto.string_field(2)
    output_data: str = betterproto.string_field(3)
    output_data_as_string: str = betterproto.string_field(4)
    output_logs: List[
        "___cosmos_base_abci_v1_beta1__.StringEvent"
    ] = betterproto.message_field(5)
    output_error: bytes = betterproto.bytes_field(6)
    plaintext_error: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState - genesis state of x/wasm"""

    # Params params = 1 [(gogoproto.nullable) = false];
    codes: List["Code"] = betterproto.message_field(2)
    contracts: List["Contract"] = betterproto.message_field(3)
    sequences: List["Sequence"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class Code(betterproto.Message):
    """Code struct encompasses CodeInfo and CodeBytes"""

    code_id: int = betterproto.uint64_field(1)
    code_info: "CodeInfo" = betterproto.message_field(2)
    code_bytes: bytes = betterproto.bytes_field(3)


@dataclass(eq=False, repr=False)
class Contract(betterproto.Message):
    """
    Contract struct encompasses ContractAddress, ContractInfo, and
    ContractState
    """

    contract_address: bytes = betterproto.bytes_field(1)
    contract_info: "ContractInfo" = betterproto.message_field(2)
    contract_state: List["Model"] = betterproto.message_field(3)
    contract_custom_info: "ContractCustomInfo" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class Sequence(betterproto.Message):
    """Sequence id and value of a counter"""

    id_key: bytes = betterproto.bytes_field(1)
    value: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class MsgStoreCode(betterproto.Message):
    sender: bytes = betterproto.bytes_field(1)
    # WASMByteCode can be raw or gzip compressed
    wasm_byte_code: bytes = betterproto.bytes_field(2)
    # Source is a valid absolute HTTPS URI to the contract's source code,
    # optional
    source: str = betterproto.string_field(3)
    # Builder is a valid docker image name with tag, optional
    builder: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class MsgInstantiateContract(betterproto.Message):
    sender: bytes = betterproto.bytes_field(1)
    # Admin is an optional address that can execute migrations  bytes admin = 2
    # [(gogoproto.casttype) = "github.com/cosmos/cosmos-sdk/types.AccAddress"];
    callback_code_hash: str = betterproto.string_field(2)
    code_id: int = betterproto.uint64_field(3)
    label: str = betterproto.string_field(4)
    init_msg: bytes = betterproto.bytes_field(5)
    init_funds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(6)
    callback_sig: bytes = betterproto.bytes_field(7)


@dataclass(eq=False, repr=False)
class MsgExecuteContract(betterproto.Message):
    sender: bytes = betterproto.bytes_field(1)
    contract: bytes = betterproto.bytes_field(2)
    msg: bytes = betterproto.bytes_field(3)
    callback_code_hash: str = betterproto.string_field(4)
    sent_funds: List["___cosmos_base_v1_beta1__.Coin"] = betterproto.message_field(5)
    callback_sig: bytes = betterproto.bytes_field(6)


class QueryStub(betterproto.ServiceStub):
    async def contract_info(
        self, *, address: bytes = b""
    ) -> "QueryContractInfoResponse":

        request = QueryContractInfoRequest()
        request.address = address

        return await self._unary_unary(
            "/secret.compute.v1beta1.Query/ContractInfo",
            request,
            QueryContractInfoResponse,
        )

    async def contracts_by_code(
        self, *, code_id: int = 0
    ) -> "QueryContractsByCodeResponse":

        request = QueryContractsByCodeRequest()
        request.code_id = code_id

        return await self._unary_unary(
            "/secret.compute.v1beta1.Query/ContractsByCode",
            request,
            QueryContractsByCodeResponse,
        )

    async def smart_contract_state(
        self, *, address: bytes = b"", query_data: bytes = b""
    ) -> "QuerySmartContractStateResponse":

        request = QuerySmartContractStateRequest()
        request.address = address
        request.query_data = query_data

        return await self._unary_unary(
            "/secret.compute.v1beta1.Query/SmartContractState",
            request,
            QuerySmartContractStateResponse,
        )

    async def code(self, *, code_id: int = 0) -> "QueryCodeResponse":

        request = QueryCodeRequest()
        request.code_id = code_id

        return await self._unary_unary(
            "/secret.compute.v1beta1.Query/Code", request, QueryCodeResponse
        )

    async def codes(self) -> "QueryCodesResponse":

        request = betterproto_lib_google_protobuf.Empty()

        return await self._unary_unary(
            "/secret.compute.v1beta1.Query/Codes", request, QueryCodesResponse
        )


class QueryBase(ServiceBase):
    async def contract_info(self, address: bytes) -> "QueryContractInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def contracts_by_code(self, code_id: int) -> "QueryContractsByCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def smart_contract_state(
        self, address: bytes, query_data: bytes
    ) -> "QuerySmartContractStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def code(self, code_id: int) -> "QueryCodeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def codes(self) -> "QueryCodesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_contract_info(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "address": request.address,
        }

        response = await self.contract_info(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_contracts_by_code(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "code_id": request.code_id,
        }

        response = await self.contracts_by_code(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_smart_contract_state(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "address": request.address,
            "query_data": request.query_data,
        }

        response = await self.smart_contract_state(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_code(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "code_id": request.code_id,
        }

        response = await self.code(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_codes(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.codes(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/secret.compute.v1beta1.Query/ContractInfo": grpclib.const.Handler(
                self.__rpc_contract_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryContractInfoRequest,
                QueryContractInfoResponse,
            ),
            "/secret.compute.v1beta1.Query/ContractsByCode": grpclib.const.Handler(
                self.__rpc_contracts_by_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryContractsByCodeRequest,
                QueryContractsByCodeResponse,
            ),
            "/secret.compute.v1beta1.Query/SmartContractState": grpclib.const.Handler(
                self.__rpc_smart_contract_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QuerySmartContractStateRequest,
                QuerySmartContractStateResponse,
            ),
            "/secret.compute.v1beta1.Query/Code": grpclib.const.Handler(
                self.__rpc_code,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCodeRequest,
                QueryCodeResponse,
            ),
            "/secret.compute.v1beta1.Query/Codes": grpclib.const.Handler(
                self.__rpc_codes,
                grpclib.const.Cardinality.UNARY_UNARY,
                betterproto_lib_google_protobuf.Empty,
                QueryCodesResponse,
            ),
        }


from ....cosmos.base import v1beta1 as ___cosmos_base_v1_beta1__
from ....cosmos.base.abci import v1beta1 as ___cosmos_base_abci_v1_beta1__
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
