"""
    Tapyrus API

    # イントロダクション  これは chaintope 社が開発するブロックチェーン Tapyrus を使ったブロックチェーンに関係する機能を簡単に利用するための REST API です。 現在以下のユースケースをサポートしています。これは今後も拡張されていくことを予定しています。 * Payment: TPC(Tapyrus Coin) の送金 * Timestamp: 任意のデータをタイムスタンプとしてブロックチェーンに記録 * Token: 新しいトークンの発行、送金、焼却。NFTも利用可能  Tapyrus ブロックチェーンについては以下の情報を参照してください。  * [Chaintope のブロックチェーンプロトコル](https://www.chaintope.com/chaintope-blockchain-protocol/) * [chaintope/tapyrus-core - github](https://github.com/chaintope/tapyrus-core)  ## Tapyrus API の利用法  Tapyrus API は REST API として提供されています。利用を開始するためには、Tapyrus API の `エンドポイント` に対して、 `認証` 済みの トークンを使いアクセスする必要があります。また、認証されたユーザはそれぞれが自身のウォレットを Tapyrus API 内部に持つことになります。 ウォレットではそのユーザの TPC やトークンといったアセットを管理するための鍵が管理され、アセットの移動などで利用されます。  ### Tapyrus API のエンドポイント  エンドポイントは以下のフォーマットで作成され、 chaintope より提供されます。  `ap-01.tapyrus.chaintope.com`  例えば [testnet](https://testnet-explorer.tapyrus.dev.chaintope.com/blocks) では以下のようになります。  `testnet-api.tapyrus.chaintope.com`  testnet は誰でも利用可能な動作の確認用のネットワークであり、予告なくリセットされる可能性があります。 利用に必要な TPC は [faucet](https://testnet-faucet.tapyrus.dev.chaintope.com) から取得できます。  * [faucet](https://testnet-faucet.tapyrus.dev.chaintope.com)  ### OpenID Connect を使った認証  Tapyrus API では [OpenID Connect](https://openid.net/connect/) を使った認証をサポートします。この認証を利用するためには、 以下のステップを踏みます。  1. 利用する OpenID Provider(OP) を選択する    公開された OP から選択する方法と、自身で OP を構築する方法があります。独自のユーザデータベースがあり、そのユーザに Tapyrus API   を利用させる場合は後者の自身で OP を構築する方法を選択することになります。  2. OAuth 2.0 Client Credential を入手する    多くの公開された OP では、アプリケーションを登録して Client Credential を入手する必要があります。手順は利用する OP に従ってください。  3. Access Token と ID Token を入手する    OpenID Connect に沿った認証を行い、 token エンドポイントから ID Token を入手します。  4. Tapyrus API ユーザを作成する    入手した Access Token と ID Token を Tapyrus API の [createUser API](https://doc.api.tapyrus.chaintope.com/#operation/createUser) へ送り、 Tapyrus API のユーザを作成します。  コード例を後述の Getting Started ドキュメントで解説していますので、そちらを参照してください。  ## Tapyrus API ユーザとウォレットについて  認証により得たアクセストークンを使い、Tapyrus API ユーザを１つ作成する必要があります。 Tapyrus API の内部では、このユーザ１つにつき１つのウォレットが作成されます。 ウォレットではアセットの受け取りや、送付に必要な公開鍵と秘密鍵のペアが管理されており、同時にそれらのカギに紐づくアセットも管理されます。 そのため、認証を行ったユーザごとに独立したアセットの管理が可能になります。  # Getting Started  Getting Started ドキュメントでは実際のコード例を交えながらより具体的な Tapyrus API の利用法を解説しています。    * [Getting Started - [Javascript] Tapyrus API を利用するウェブアプリケーションの開発を学ぶ](https://github.com/chaintope/tapyrus-api-client-examples/tree/main/javascript/GettingStarted-ja.md)   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from tapyrus-api-client.api_client import ApiClient, Endpoint as _Endpoint
from tapyrus-api-client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from tapyrus-api-client.model.get_tokens_response import GetTokensResponse
from tapyrus-api-client.model.issue_token_request import IssueTokenRequest
from tapyrus-api-client.model.reissue_token_request import ReissueTokenRequest
from tapyrus-api-client.model.token_response import TokenResponse
from tapyrus-api-client.model.transfer_token_request import TransferTokenRequest


class TokenApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __burn_token(
            self,
            token_id,
            **kwargs
        ):
            """トークンの焼却  # noqa: E501

            任意の数のトークンを焼却します。  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.burn_token(token_id, async_req=True)
            >>> result = thread.get()

            Args:
                token_id (str): トークンの識別子。

            Keyword Args:
                amount (int): `amount`を受け取り、指定した量のトークンを焼却します。 `amount`が未入力の場合全てのトークンを焼却します。 . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['token_id'] = \
                token_id
            return self.call_with_http_info(**kwargs)

        self.burn_token = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/tokens/{token_id}/burn',
                'operation_id': 'burn_token',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'token_id',
                    'amount',
                ],
                'required': [
                    'token_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token_id':
                        (str,),
                    'amount':
                        (int,),
                },
                'attribute_map': {
                    'token_id': 'token_id',
                    'amount': 'amount',
                },
                'location_map': {
                    'token_id': 'path',
                    'amount': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__burn_token
        )

        def __get_tokens(
            self,
            **kwargs
        ):
            """トークンの総量取得  # noqa: E501

            所有するトークンの総量を取得し、トークン識別子(`token_id`)ごとに総量(`amount`)を一覧で表示します。  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tokens(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                confirmation_only (bool): オプションで`confirmation_only`を設定でき、`true`の場合ブロックチェーン上で承認済みのトークンのみを取得し、`false`の場合未承認のトークンも含めて取得します。デフォルトは`true`です。. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [GetTokensResponse]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_tokens = _Endpoint(
            settings={
                'response_type': ([GetTokensResponse],),
                'auth': [],
                'endpoint_path': '/tokens',
                'operation_id': 'get_tokens',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'confirmation_only',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'confirmation_only':
                        (bool,),
                },
                'attribute_map': {
                    'confirmation_only': 'confirmation_only',
                },
                'location_map': {
                    'confirmation_only': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tokens
        )

        def __issue_token(
            self,
            **kwargs
        ):
            """トークンの新規発行  # noqa: E501

            任意の数のトークンを新規発行します。  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.issue_token(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                issue_token_request (IssueTokenRequest): `amount`を受け取り指定した数のトークンを新規発行します。 任意で`token_type`を設定し、トークンの種類を指定できます。 `token_type`が未指定な場合、再発行可能なトークンが発行されます。 トークンの種類は以下の通りです。 - 1: 再発行可能なトークン - 2: 再発行不可能なトークン - 3: NFT  また、`token_type`が未指定または`1`の場合、任意でトークン識別子`id`を指定することで、指定したトークン識別子のトークンを再発行します。 . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TokenResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.issue_token = _Endpoint(
            settings={
                'response_type': (TokenResponse,),
                'auth': [],
                'endpoint_path': '/tokens/issue',
                'operation_id': 'issue_token',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'issue_token_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'issue_token_request':
                        (IssueTokenRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'issue_token_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__issue_token
        )

        def __reissue_token(
            self,
            token_id,
            **kwargs
        ):
            """トークンの再発行  # noqa: E501

            指定した識別子を持つ再発行可能なトークンを任意の量再発行します。  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reissue_token(token_id, async_req=True)
            >>> result = thread.get()

            Args:
                token_id (str): トークンの識別子。

            Keyword Args:
                reissue_token_request (ReissueTokenRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TokenResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['token_id'] = \
                token_id
            return self.call_with_http_info(**kwargs)

        self.reissue_token = _Endpoint(
            settings={
                'response_type': (TokenResponse,),
                'auth': [],
                'endpoint_path': '/tokens/{token_id}/reissue',
                'operation_id': 'reissue_token',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'token_id',
                    'reissue_token_request',
                ],
                'required': [
                    'token_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token_id':
                        (str,),
                    'reissue_token_request':
                        (ReissueTokenRequest,),
                },
                'attribute_map': {
                    'token_id': 'token_id',
                },
                'location_map': {
                    'token_id': 'path',
                    'reissue_token_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__reissue_token
        )

        def __transfer_token(
            self,
            token_id,
            transfer_token_request,
            **kwargs
        ):
            """トークンの送付  # noqa: E501

            任意の数のトークンを指定したアドレスに対して送付します。  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.transfer_token(token_id, transfer_token_request, async_req=True)
            >>> result = thread.get()

            Args:
                token_id (str): トークンの識別子。
                transfer_token_request (TransferTokenRequest): `address`でトークンを送付する相手のアドレスを指定し、`amount`で送付するトークンの量を指定します。

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TokenResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['token_id'] = \
                token_id
            kwargs['transfer_token_request'] = \
                transfer_token_request
            return self.call_with_http_info(**kwargs)

        self.transfer_token = _Endpoint(
            settings={
                'response_type': (TokenResponse,),
                'auth': [],
                'endpoint_path': '/tokens/{token_id}/transfer',
                'operation_id': 'transfer_token',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'token_id',
                    'transfer_token_request',
                ],
                'required': [
                    'token_id',
                    'transfer_token_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'token_id':
                        (str,),
                    'transfer_token_request':
                        (TransferTokenRequest,),
                },
                'attribute_map': {
                    'token_id': 'token_id',
                },
                'location_map': {
                    'token_id': 'path',
                    'transfer_token_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__transfer_token
        )
