# tapyrus-api-client
# イントロダクション

これは chaintope 社が開発するブロックチェーン Tapyrus を使ったブロックチェーンに関係する機能を簡単に利用するための REST API です。
現在以下のユースケースをサポートしています。これは今後も拡張されていくことを予定しています。
* Payment: TPC(Tapyrus Coin) の送金
* Timestamp: 任意のデータをタイムスタンプとしてブロックチェーンに記録
* Token: 新しいトークンの発行、送金、焼却。NFTも利用可能

Tapyrus ブロックチェーンについては以下の情報を参照してください。

* [Chaintope のブロックチェーンプロトコル](https://www.chaintope.com/chaintope-blockchain-protocol/)
* [chaintope/tapyrus-core - github](https://github.com/chaintope/tapyrus-core)

## Tapyrus API の利用法

Tapyrus API は REST API として提供されています。利用を開始するためには、Tapyrus API の `エンドポイント` に対して、 `認証` 済みの
トークンを使いアクセスする必要があります。また、認証されたユーザはそれぞれが自身のウォレットを Tapyrus API 内部に持つことになります。
ウォレットではそのユーザの TPC やトークンといったアセットを管理するための鍵が管理され、アセットの移動などで利用されます。

### Tapyrus API のエンドポイント

エンドポイントは以下のフォーマットで作成され、 chaintope より提供されます。

`ap-01.tapyrus.chaintope.com`

例えば [testnet](https://testnet-explorer.tapyrus.dev.chaintope.com/blocks) では以下のようになります。

`testnet-api.tapyrus.chaintope.com`

testnet は誰でも利用可能な動作の確認用のネットワークであり、予告なくリセットされる可能性があります。
利用に必要な TPC は [faucet](https://testnet-faucet.tapyrus.dev.chaintope.com) から取得できます。

* [faucet](https://testnet-faucet.tapyrus.dev.chaintope.com)

### OpenID Connect を使った認証

Tapyrus API では [OpenID Connect](https://openid.net/connect/) を使った認証をサポートします。この認証を利用するためには、
以下のステップを踏みます。

1. 利用する OpenID Provider(OP) を選択する

  公開された OP から選択する方法と、自身で OP を構築する方法があります。独自のユーザデータベースがあり、そのユーザに Tapyrus API
  を利用させる場合は後者の自身で OP を構築する方法を選択することになります。

2. OAuth 2.0 Client Credential を入手する

  多くの公開された OP では、アプリケーションを登録して Client Credential を入手する必要があります。手順は利用する OP に従ってください。

3. Access Token と ID Token を入手する

  OpenID Connect に沿った認証を行い、 token エンドポイントから ID Token を入手します。

4. Tapyrus API ユーザを作成する

  入手した Access Token と ID Token を Tapyrus API の [createUser API](https://doc.api.tapyrus.chaintope.com/#operation/createUser) へ送り、 Tapyrus API のユーザを作成します。

コード例を後述の Getting Started ドキュメントで解説していますので、そちらを参照してください。

## Tapyrus API ユーザとウォレットについて

認証により得たアクセストークンを使い、Tapyrus API ユーザを１つ作成する必要があります。
Tapyrus API の内部では、このユーザ１つにつき１つのウォレットが作成されます。
ウォレットではアセットの受け取りや、送付に必要な公開鍵と秘密鍵のペアが管理されており、同時にそれらのカギに紐づくアセットも管理されます。
そのため、認証を行ったユーザごとに独立したアセットの管理が可能になります。

# Getting Started

Getting Started ドキュメントでは実際のコード例を交えながらより具体的な Tapyrus API の利用法を解説しています。

  * [Getting Started - [Javascript] Tapyrus API を利用するウェブアプリケーションの開発を学ぶ](https://github.com/chaintope/tapyrus-api-client-examples/tree/main/javascript/GettingStarted-ja.md)


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import tapyrus-api-client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import tapyrus-api-client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import tapyrus-api-client
from pprint import pprint
from tapyrus-api-client.api import address_api
from tapyrus-api-client.model.get_addresses_response import GetAddressesResponse
# Defining the host is optional and defaults to https://ap-01.tapyrus.chaintope.com/api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = tapyrus-api-client.Configuration(
    host = "https://ap-01.tapyrus.chaintope.com/api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.


# Enter a context with an instance of the API client
with tapyrus-api-client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = address_api.AddressApi(api_client)
    
    try:
        # アドレスを生成して返します。
        api_response = api_instance.create_address()
        pprint(api_response)
    except tapyrus-api-client.ApiException as e:
        print("Exception when calling AddressApi->create_address: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://ap-01.tapyrus.chaintope.com/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AddressApi* | [**create_address**](docs/AddressApi.md#create_address) | **POST** /addresses | アドレスを生成して返します。
*AddressApi* | [**get_addresses**](docs/AddressApi.md#get_addresses) | **GET** /addresses | これまで生成したアドレスを一覧にして返します。
*PaymentApi* | [**transfer**](docs/PaymentApi.md#transfer) | **POST** /payment | 資金の送金
*TimestampApi* | [**add_timestamp**](docs/TimestampApi.md#add_timestamp) | **POST** /timestamp | Timestampを記録
*TimestampApi* | [**get_timestamps**](docs/TimestampApi.md#get_timestamps) | **GET** /timestamps | Timestamp一覧表示
*TokenApi* | [**burn_token**](docs/TokenApi.md#burn_token) | **DELETE** /tokens/{token_id}/burn | トークンの焼却
*TokenApi* | [**get_tokens**](docs/TokenApi.md#get_tokens) | **GET** /tokens | トークンの総量取得
*TokenApi* | [**issue_token**](docs/TokenApi.md#issue_token) | **POST** /tokens/issue | トークンの新規発行
*TokenApi* | [**reissue_token**](docs/TokenApi.md#reissue_token) | **POST** /tokens/{token_id}/reissue | トークンの再発行
*TokenApi* | [**transfer_token**](docs/TokenApi.md#transfer_token) | **PUT** /tokens/{token_id}/transfer | トークンの送付
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /users | ユーザを作成します。
*UserApi* | [**get_user_info**](docs/UserApi.md#get_user_info) | **GET** /userinfo | ユーザの情報を返します。


## Documentation For Models

 - [AddTimestampRequest](docs/AddTimestampRequest.md)
 - [CreateUserRequest](docs/CreateUserRequest.md)
 - [GetAddressesResponse](docs/GetAddressesResponse.md)
 - [GetTimestampsResponse](docs/GetTimestampsResponse.md)
 - [GetTokensResponse](docs/GetTokensResponse.md)
 - [IssueTokenRequest](docs/IssueTokenRequest.md)
 - [PaymentRequest](docs/PaymentRequest.md)
 - [PaymentResponse](docs/PaymentResponse.md)
 - [ReissueTokenRequest](docs/ReissueTokenRequest.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [TransferTokenRequest](docs/TransferTokenRequest.md)
 - [UserinfoResponse](docs/UserinfoResponse.md)
 - [UserinfoResponseBalances](docs/UserinfoResponseBalances.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in tapyrus-api-client.apis and tapyrus-api-client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from tapyrus-api-client.api.default_api import DefaultApi`
- `from tapyrus-api-client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import tapyrus-api-client
from tapyrus-api-client.apis import *
from tapyrus-api-client.models import *
```

