# Contributing to Manage FastAPI

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## We Develop with Github

We use github to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [Github Flow](https://guides.github.com/introduction/flow/index.html), So All Code Changes Happen Through Pull Requests

Pull requests are the best way to propose changes to the codebase (we use [Github Flow](https://guides.github.com/introduction/flow/index.html)). We actively welcome your pull requests:

1. Fork the repo and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Issue that pull request!

## Report bugs using Github's [issues](https://github.com/sxhxliang/fastapi-cli/issues)

We use GitHub issues to track public bugs. Report a bug by [opening a new issue](); it's that easy!

## Write bug reports with detail, background, and sample code

[This is a good example](http://stackoverflow.com/q/12488905/180626) of a bug report.

**Great Bug Reports** tend to have:

- A quick summary and/or background.
- Steps to reproduce.
  - Be specific!
  - Give sample code if you can.
- Express what you expected would happen.
- Express what actually happens.
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

People *love* thorough bug reports. I'm not even kidding.

## License

By contributing, you agree that your contributions will be licensed under its MIT License.

## References

This document was adapted from the open-source contribution document created by [Brian A. Danielak](https://gist.github.com/briandk) based on the [Facebook's Draft](https://github.com/facebook/draft-js/blob/a9316a723f9e918afde44dea68b5f9f39b7d9b00/CONTRIBUTING.md) contributing guidelines.

manage-fastapi [ycd](https://github.com/ycd/manage-fastapi)

peewee [peewee](https://github.com/coleifer/peewee)

fastapi-realworld-example-app-mysql [xiaozl](https://github.com/xiaozl/fastapi-realworld-example-app-mysql)

