"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegManifestSynthesizer = void 0;
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
const manifest_writer_1 = require("./manifest-writer");
const emptyManifest = {
    version: '',
    testCases: {},
};
class IntegManifestSynthesizer {
    constructor(testCases) {
        this.testCases = testCases;
    }
    synthesize(session) {
        const manifest = this.testCases
            .map(tc => tc.manifest)
            .reduce(mergeManifests, emptyManifest);
        const snapshotDir = session.assembly.outdir;
        manifest_writer_1.IntegManifestWriter.write(manifest, snapshotDir);
    }
}
exports.IntegManifestSynthesizer = IntegManifestSynthesizer;
function mergeManifests(m1, m2) {
    return {
        version: cloud_assembly_schema_1.Manifest.version(),
        testCases: { ...m1.testCases, ...m2.testCases },
    };
}
//# sourceMappingURL=data:application/json;base64,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