# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['prismedia']

package_data = \
{'': ['*'],
 'prismedia': ['config/*',
               'samples/cli_nfo.txt',
               'samples/cli_nfo.txt',
               'samples/cli_nfo.txt',
               'samples/cli_nfo.txt',
               'samples/cli_nfo.txt',
               'samples/full_nfo_examples.txt',
               'samples/full_nfo_examples.txt',
               'samples/full_nfo_examples.txt',
               'samples/full_nfo_examples.txt',
               'samples/full_nfo_examples.txt',
               'samples/nfo.txt',
               'samples/nfo.txt',
               'samples/nfo.txt',
               'samples/nfo.txt',
               'samples/nfo.txt',
               'samples/samples.txt',
               'samples/samples.txt',
               'samples/samples.txt',
               'samples/samples.txt',
               'samples/samples.txt',
               'samples/yourvideo.txt',
               'samples/yourvideo.txt',
               'samples/yourvideo.txt',
               'samples/yourvideo.txt',
               'samples/yourvideo.txt']}

install_requires = \
['Unidecode>=1.0.23,<2.0.0',
 'configparser>=3.7.1,<4.0.0',
 'docopt>=0.6.2,<0.7.0',
 'future>=0.17.1,<0.18.0',
 'google-api-python-client>=1.7.6',
 'google-auth-httplib2>=0.0.3',
 'google-auth-oauthlib>=0.2.0',
 'google-auth>=1.6.1',
 'httplib2>=0.12.1,<0.13.0',
 'oauthlib>=2.1.0,<3.0.0',
 'python-magic>=0.4.15,<0.5.0',
 'requests-oauthlib>=0.8.0,<0.9.0',
 'requests-toolbelt>=0.9.1,<0.10.0',
 'requests>=2.18.4,<3.0.0',
 'schema>=0.7.1',
 'tzlocal>=1.5.1,<2.0.0',
 'uritemplate>=3.0.0,<4.0.0',
 'urllib3>=1.22,<2.0']

extras_require = \
{':platform_system == "Windows"': ['python-magic-bin>=0.4.14,<0.5.0']}

entry_points = \
{'console_scripts': ['prismedia = prismedia.upload:main']}

setup_kwargs = {
    'name': 'prismedia',
    'version': '0.10.3',
    'description': 'scripting your way to upload videos on peertube and youtube',
    'long_description': '# Prismedia\n\nScripting your way to upload videos to peertube and youtube. Works with Python 3.5+.\n\n[TOC]: #\n\n## Table of Contents\n- [Installation](#installation-and-upgrade)\n  - [From pip](#from-pip)\n  - [From source](#from-source)\n- [Configuration](#configuration)\n  - [Peertube](#peertube)\n  - [Youtube](#youtube)\n- [Usage](#usage)\n- [Enhanced use of NFO](#enhanced-use-of-nfo)\n- [Strict check options](#strict-check-options)\n- [Features](#features)\n- [Compatibility](#compatibility)\n- [Inspirations](#inspirations)\n- [Contributors](#contributors)\n\n## Installation and upgrade\n\n### From pip\n\nSimply install with \n\n```bash\npip install prismedia\n```\n\nUpgrade with \n\n```bash\npip install --upgrade prismedia\n```\n\n### From source\n\nGet the source: \n\n```bash\ngit clone https://git.lecygnenoir.info/LecygneNoir/prismedia.git prismedia\n```\n\nYou may use pip to install requirements: `pip install -r requirements.txt` if you want to use the script directly.  \n(*note:* requirements are generated via `poetry export -f requirements.txt`)\n\nOtherwise, you can use [poetry](https://python-poetry.org), which create a virtualenv for the project directly  \n(Or use the existing virtualenv if one is activated)\n\n```\npoetry install\n```\n\n\n## Configuration\n\nGenerate sample files with `python -m prismedia.genconfig`.  \nThen rename and edit `peertube_secret` and `youtube_secret.json` with your credentials. (see below)\n\n### Peertube\nSet your credentials, peertube server URL.  \nYou can get client_id and client_secret by logging in your peertube website and reaching the URL:  \nhttps://domain.example/api/v1/oauth-clients/local  \nYou can set ``OAUTHLIB_INSECURE_TRANSPORT`` to 1 if you do not use https (not recommended)\n\n### Youtube\nYoutube uses combination of oauth and API access to identify.\n\n**Credentials**\nThe first time you connect, prismedia will open your browser to ask you to authenticate to\nYoutube and allow the app to use your Youtube channel.  \n**It is here you choose which channel you will upload to**.  \nOnce authenticated, the token is stored inside the file ``.youtube_credentials.json``.  \nPrismedia will try to use this file at each launch, and re-ask for authentication if it does not exist.\n\n**Oauth**:  \nThe default youtube_secret.json should allow you to upload some videos.  \nIf you plan a larger usage, please consider creating your own youtube_secret file:\n\n - Go to the [Google console](https://console.developers.google.com/).\n - Create project.\n - Side menu: APIs & auth -> APIs\n - Top menu: Enabled API(s): Enable all Youtube APIs.\n - Side menu: APIs & auth -> Credentials.\n - Create a Client ID: Add credentials -> OAuth 2.0 Client ID -> Other -> Name: prismedia1 -> Create -> OK\n - Download JSON: Under the section "OAuth 2.0 client IDs". Save the file to your local system.\n - Save this JSON as your youtube_secret.json file.\n\n## Usage\nSupport only mp4 for cross compatibility between Youtube and Peertube.  \n**Note that all options may be specified in a NFO file!** (see [Enhanced NFO](#enhanced-use-of-nfo))\n\nUpload a video:\n\n```\nprismedia --file="yourvideo.mp4"\n```\n\nSpecify description and tags:\n\n```\nprismedia --file="yourvideo.mp4" -d "My supa description" -t "tag1,tag2,foo"\n```\n\nProvide a thumbnail:\n\n```\nprismedia --file="yourvideo.mp4" -d "Video with thumbnail" --thumbnail="/path/to/your/thumbnail.jpg"\n```\n\n\nUse a NFO file to specify your video options:  \n(See [Enhanced NFO](#enhanced-use-of-nfo) for more precise example)\n```\nprismedia --file="yourvideo.mp4" --nfo /path/to/your/nfo.txt\n```\n\n\nUse --help to get all available options:\n\n```\nOptions:\n  -f, --file=STRING Path to the video file to upload in mp4. This is the only mandatory option.\n  --name=NAME  Name of the video to upload. (default to video filename)\n  -d, --description=STRING  Description of the video. (default: default description)\n  -t, --tags=STRING  Tags for the video. comma separated.\n                     WARN: tags with punctuation (!, \', ", ?, ...)\n                           are not supported by Mastodon to be published from Peertube\n  -c, --category=STRING  Category for the videos, see below. (default: Films)\n  --cca  License should be CreativeCommon Attribution (affects Youtube upload only)\n  -p, --privacy=STRING  Choose between public, unlisted or private. (default: private)\n  --disable-comments  Disable comments (Peertube only as YT API does not support) (default: comments are enabled)\n  --nsfw  Set the video as No Safe For Work (Peertube only as YT API does not support) (default: video is safe)\n  --nfo=STRING  Configure a specific nfo file to set options for the video.\n                By default Prismedia search a .txt based on the video name and will\n                decode the file as UTF-8 (so make sure your nfo file is UTF-8 encoded)\n                See nfo_example.txt for more details\n  --platform=STRING  List of platform(s) to upload to, comma separated.\n                     Supported platforms are youtube and peertube (default is both)\n  --language=STRING  Specify the default language for video. See below for supported language. (default is English)\n  --publishAt=DATE  Publish the video at the given DATE using local server timezone.\n                    DATE should be on the form YYYY-MM-DDThh:mm:ss eg: 2018-03-12T19:00:00\n                    DATE should be in the future\n  --peertubeAt=DATE\n  --youtubeAt=DATE  Override publishAt for the corresponding platform. Allow to create preview on specific platform\n  --thumbnail=STRING    Path to a file to use as a thumbnail for the video.\n                        Supported types are jpg and jpeg.\n                        By default, prismedia search for an image based on video name followed by .jpg or .jpeg\n  --channel=STRING Set the channel to use for the video (Peertube only)\n                    If the channel is not found, spawn an error except if --channelCreate is set.\n  --channelCreate  Create the channel if not exists. (Peertube only, default do not create)\n                   Only relevant if --channel is set.\n  --playlist=STRING Set the playlist to use for the video.\n                    If the playlist is not found, spawn an error except if --playlistCreate is set.\n  --playlistCreate  Create the playlist if not exists. (default do not create)\n                    Only relevant if --playlist is set.\n  -h --help  Show this help.\n  --version  Show version.\n\nLogging options\n  -q --quiet        Suppress any log except Critical (alias for --log=critical).\n  --log=STRING      Log level, between debug, info, warning, error, critical. Ignored if --quiet is set (default to info)\n  -u --url-only     Display generated URL after upload directly on stdout, implies --quiet\n  --batch           Display generated URL after upload with platform information for easier parsing. Implies --quiet\n                    Be careful --batch and --url-only are mutually exclusives.\n  --debug           (Deprecated) Alias for --log=debug. Ignored if --log is set\n\nStrict options:\n  Strict options allow you to force some option to be present when uploading a video. It\'s useful to be sure you do not\n  forget something when uploading a video, for example if you use multiples NFO. You may force the presence of description,\n  tags, thumbnail, ...\n  All strict option are optionals and are provided only to avoid errors when uploading :-)\n  All strict options can be specified in NFO directly, the only strict option mandatory on cli is --withNFO\n  All strict options are off by default\n\n  --withNFO         Prevent the upload without a NFO, either specified via cli or found in the directory\n  --withThumbnail       Prevent the upload without a thumbnail\n  --withName        Prevent the upload if no name are found\n  --withDescription     Prevent the upload without description\n  --withTags        Prevent the upload without tags\n  --withPlaylist    Prevent the upload if no playlist\n  --withPublishAt    Prevent the upload if no schedule\n  --withPlatform    Prevent the upload if at least one platform is not specified\n  --withCategory    Prevent the upload if no category\n  --withLanguage    Prevent upload if no language\n  --withChannel     Prevent upload if no channel\n\nCategories:\n  Category is the type of video you upload. Default is films.\n  Here are available categories from Peertube and Youtube:\n    music, films, vehicles,\n    sports, travels, gaming, people,\n    comedy, entertainment, news,\n    how to, education, activism, science & technology,\n    science, technology, animals\n\nLanguages:\n  Language of the video (audio track), choose one. Default is English\n  Here are available languages from Peertube and Youtube:\n    Arabic, English, French, German, Hindi, Italian,\n    Japanese, Korean, Mandarin, Portuguese, Punjabi, Russian, Spanish\n\n```\n\n## Enhanced use of NFO\nSince Prismedia v0.9.0, the NFO system has been improved to allow hierarchical loading.\nFirst of all, **if you already used nfo**, either with `--nfo` or by using `videoname.txt`, nothing changes :-)\n\nBut you are now able to use a more flexible NFO system, by using priorities. This allow you to set some defaults to avoid recreating a full nfo for each video\n\nBasically, Prismedia will now load options in this order, using the last value found in case of conflict:  \n`nfo.txt < directory_name.txt < video_name.txt < command line NFO < command line argument`\n\nYou\'ll find a complete set of samples in the [prismedia/samples](prismedia/samples) directory so let\'s take it as an example:\n```\n$ tree Recipes/\nRecipes/\n├── cli_nfo.txt\n├── nfo.txt\n├── samples.txt\n├── yourvideo1.mp4\n├── yourvideo1.txt\n├── yourvideo1.jpg\n├── yourvideo2.mp4\n└── yourvideo2.txt\n```\n\nBy using \n```\nprismedia --file=/path/to/Recipes/yourvideo1.mp4 --nfo=/path/to/Recipes/cli_nfo.txt --cca\n```\n\nPrismedia will:\n- look for options in `nfo.txt`\n- look for options in `samples.txt` (from directory name) and erase any previous conflicting options\n- look for options in `yourvideo1.txt` (from video name) and erase any previous conflicting options\n- look for options in `cli_nfo.txt` (from the `--nfo` in command line) and erase any previous conflicting options\n- erase any previous option regarding CCA as it\'s specified in cli with `--cca`\n- take `yourvideo1.jpg` as thumbnail if no other files has been specified in previous NFO\n\nIn other word, Prismedia will use option given in cli, then look for option in cli_nfo.txt, then complete with video_name.txt, then directory_name.txt, and finally complete with nfo.txt\n\nIt allows to specify more easily default options for an entire set of video, directory, playlist and so on.\n\n## Strict check options\nSince prismedia v0.10.0, a bunch of special options have been added to force the presence of parameters before uploading.\nStrict options allow you to force some option to be present when uploading a video. It\'s useful to be sure you do not\nforget something when uploading a video, for example if you use multiples NFO. You may force the presence of description,\ntags, thumbnail, ...\nAll strict option are optionals and are provided only to avoid errors when uploading :-)\nAll strict options can be specified in NFO directly, the only strict option mandatory on cli is --withNFO\nAll strict options are off by default.\n\nAvailable strict options:\n  - --withNFO         Prevent the upload without a NFO, either specified via cli or found in the directory\n  - --withThumbnail       Prevent the upload without a thumbnail\n  - --withName        Prevent the upload if no name are found\n  - --withDescription     Prevent the upload without description\n  - --withTags        Prevent the upload without tags\n  - --withPlaylist    Prevent the upload if no playlist\n  - --withPublishAt    Prevent the upload if no schedule\n  - --withPlatform    Prevent the upload if at least one platform is not specified\n  - --withCategory    Prevent the upload if no category\n  - --withLanguage    Prevent upload if no language\n  - --withChannel     Prevent upload if no channel \n\n## Features\n\n- [x] Youtube upload\n- [x] Peertube upload\n- Support of videos parameters (description, tags, category, licence, ...)\n  - [x] description\n  - [x] tags (no more than 30 characters per tag as Peertube does not support it)\n  - [x] categories\n  - [x] license: cca or not (Youtube only as Peertube uses Attribution by design)\n  - [x] privacy (between public, unlisted or private)\n  - [x] enabling/disabling comment (Peertube only as Youtube API does not support it)\n  - [x] nsfw (Peertube only as Youtube API does not support it)\n  - [x] set default language\n  - [x] thumbnail\n  - [x] multiple lines description (see [issue 4](https://git.lecygnenoir.info/LecygneNoir/prismedia/issues/4))\n  - [x] add videos to playlist\n  - [x] create playlist\n  - [x] schedule your video with publishAt\n  - [x] combine channel and playlist (Peertube only as channel is Peertube feature). See [issue 40](https://git.lecygnenoir.info/LecygneNoir/prismedia/issues/40) for detailed usage.\n- [x] Use a config file (NFO) file to retrieve videos arguments\n- [x] Allow choosing peertube or youtube upload (to retry a failed upload for example)\n- [x] Usable on Desktop (Linux and/or Windows and/or MacOS)\n- [x] Different schedules on platforms to prepare preview\n- [x] Possibility to force the presence of upload options\n- [ ] Copy and forget, eg possibility to copy video in a directory, and prismedia uploads itself: [Work in progress](https://git.lecygnenoir.info/Zykino/prismedia-autoupload) thanks to @Zykino 🎉 (Discussions in [issue 27](https://git.lecygnenoir.info/LecygneNoir/prismedia/issues/27))  \n- [ ] A usable graphical interface\n\n## Compatibility\n\n - If you still use python2, use the version 0.7.1 (no more updated)\n - If you use peertube before 1.0.0-beta4, use the version inside tag 1.0.0-beta3\n\n## Inspirations\nInspired by [peeror](https://git.rigelk.eu/rigelk/peeror) and [youtube-upload](https://github.com/tokland/youtube-upload)\n\n## Contributors\nThanks to: @Zykino, @meewan, @rigelk 😘',
    'author': 'LecygneNoir',
    'author_email': 'git@lecygnenoir.info',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://git.lecygnenoir.info/LecygneNoir/prismedia',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.5',
}


setup(**setup_kwargs)
