# PyCrystallography

Python 3 package being written to illustrate crystallography.\
\
The features of the package include:
- [Atomic Structures](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/atomic_structure.md)\
(Miller Indices, Lattices, primitive unit cells, Triangle Subdivision, Penrose Tiling)
- [3D Crystal Models](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/geometry.md)\
(Cuboids,Pyramids,Bipyramids,Prisms,Biprismid,Tetrakis)
- [Stereographic Projections](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/stereographic_projections.md)\
(Face normal detection of a 3D model, projected normals converted to stereographic projections)
- [Operations](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/operations.md)\
(Inversion, Reflection, Rotation)
- [Stereographic Projections](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/stereographic_projections.md)\
(n-fold roataion detection of stereographic projections)
- [Xray-Diffraction](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/xray_diffraction.md)

## Installation
```bash
pip3 install PyCrystallography
```

or

```bash
git clone https://github.com/Shellywell123/PyCrystallography/
```


## Some Examples
### [Penrose Tiling](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/atomic_structure.md)

<p float="left">
  <img src="PyCrystallography/Images/penrose_tiling_sun.gif" width="400" />
  <img src="PyCrystallography/Images/penrose_tiling_star.gif" width="400" />
</p>


### [Atomic Structures](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/atomic_structure.md)

<p float="left">
  <img src="PyCrystallography/Images/diamond_unit_cell.gif" width="400" />
  <img src="PyCrystallography/Images/diamond_lattice.gif" width="400" />
</p>


### [Operations](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/operations.md)

<p float="left">
  <img src="PyCrystallography/Images/inversion.gif" width="400" />
  <img src="PyCrystallography/Images/reflection.gif" width="400" />
</p>


### [Miller Indices](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/atomic_structure.md)

<p float="left">
  <img src="PyCrystallography/Images/cube_reflection.gif" width="400" />
  <img src="PyCrystallography/Images/cube_reflection_diag.gif" width="400" />
</p>

### [Geometry](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/geometry.md)

<p float="left">
  <img src="PyCrystallography/Images/cube.gif" width="400" />
  <img src="PyCrystallography/Images/bipyramid10.gif" width="400" />
</p>

### [Face normal detection and Stereographic Projections](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/stereographic_projections.md)

<p float="left">
  <img src="PyCrystallography/Images/face_normals_tetrakis.gif" width="400" />
  <img src="PyCrystallography/Images/stereographic_projection_tetrakis.png" width="400" />
</p>

### [Moire Patterns](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/moire_patterns.md)

<p float="middle">
  <img src="PyCrystallography/Images/moire_pattern_linear_roatation.gif" width="400" />
  <img src="PyCrystallography/Images/moire_pattern_radial_seperation.gif" width="400" />
</p>

### [Xray-Diffraction](https://github.com/Shellywell123/PyCrystallography/blob/main/docs/xray_diffraction.md)
<p float="middle">
  <img src="PyCrystallography/Images/Xray-Diffraction.png" width="400" />
  <img src="PyCrystallography/Images/Xray-Diffraction2.png" width="400" />
</p>

