"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnResponsePlay = exports.ResponderType = exports.SubscriberType = exports.CfnResponsePlayPropsConferenceType = exports.CfnResponsePlayPropsRunnability = exports.toJson_Responder = exports.toJson_Subscriber = exports.toJson_CfnResponsePlayProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnResponsePlayProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnResponsePlayProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'FromEmail': obj.fromEmail,
        'Name': obj.name,
        'Description': obj.description,
        'Team': obj.team,
        'Subscribers': obj.subscribers?.map(y => toJson_Subscriber(y)),
        'SubscribersMessage': obj.subscribersMessage,
        'Responders': obj.responders?.map(y => toJson_Responder(y)),
        'RespondersMessage': obj.respondersMessage,
        'Runnability': obj.runnability,
        'ConferenceNumber': obj.conferenceNumber,
        'ConferenceUrl': obj.conferenceUrl,
        'ConferenceType': obj.conferenceType,
        'Id': obj.id,
        'Summary': obj.summary,
        'HtmlUrl': obj.htmlUrl,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnResponsePlayProps = toJson_CfnResponsePlayProps;
/**
 * Converts an object of type 'Subscriber' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Subscriber(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Type': obj.type,
        'Id': obj.id,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Subscriber = toJson_Subscriber;
/**
 * Converts an object of type 'Responder' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Responder(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Type': obj.type,
        'Id': obj.id,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Responder = toJson_Responder;
/* eslint-enable max-len, quote-props */
/**
 * String representing how this response play is allowed to be run. Valid options are:
 *
 * services: This response play cannot be manually run by any users. It will run automatically for new incidents triggered on any services that are configured with this response play.
 * teams: This response play can be run manually on an incident only by members of its configured team. This option can only be selected when the team property for this response play is not empty.
 * responders: This response play can be run manually on an incident by any responders in this account.
 *
 * @schema CfnResponsePlayPropsRunnability
 */
var CfnResponsePlayPropsRunnability;
(function (CfnResponsePlayPropsRunnability) {
    /** services */
    CfnResponsePlayPropsRunnability["SERVICES"] = "services";
    /** teams */
    CfnResponsePlayPropsRunnability["TEAMS"] = "teams";
    /** responders */
    CfnResponsePlayPropsRunnability["RESPONDERS"] = "responders";
})(CfnResponsePlayPropsRunnability = exports.CfnResponsePlayPropsRunnability || (exports.CfnResponsePlayPropsRunnability = {}));
/**
 * This field has three possible values and indicates how the response play was created.
 *
 * none : The response play had no conference_number or conference_url set at time of creation.
 * manual : The response play had one or both of conference_number and conference_url set at time of creation.
 * zoom : Customers with the Zoom-Integration Entitelment can use this value to dynamicly configure conference number and url for zoom
 *
 * @schema CfnResponsePlayPropsConferenceType
 */
var CfnResponsePlayPropsConferenceType;
(function (CfnResponsePlayPropsConferenceType) {
    /** none */
    CfnResponsePlayPropsConferenceType["NONE"] = "none";
    /** manual */
    CfnResponsePlayPropsConferenceType["MANUAL"] = "manual";
    /** zoom */
    CfnResponsePlayPropsConferenceType["ZOOM"] = "zoom";
})(CfnResponsePlayPropsConferenceType = exports.CfnResponsePlayPropsConferenceType || (exports.CfnResponsePlayPropsConferenceType = {}));
/**
 * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
 *
 * @schema SubscriberType
 */
var SubscriberType;
(function (SubscriberType) {
    /** user_reference */
    SubscriberType["USER_REFERENCE"] = "user_reference";
    /** team_reference */
    SubscriberType["TEAM_REFERENCE"] = "team_reference";
})(SubscriberType = exports.SubscriberType || (exports.SubscriberType = {}));
/**
 * A string that determines the schema of the object. This must be the standard name for the entity, suffixed by _reference if the object is a reference.
 *
 * @schema ResponderType
 */
var ResponderType;
(function (ResponderType) {
    /** user_reference */
    ResponderType["USER_REFERENCE"] = "user_reference";
    /** escalation_policy_reference */
    ResponderType["ESCALATION_POLICY_REFERENCE"] = "escalation_policy_reference";
})(ResponderType = exports.ResponderType || (exports.ResponderType = {}));
/**
 * A CloudFormation `PagerDuty::ResponsePlays::ResponsePlay`
 *
 * @cloudformationResource PagerDuty::ResponsePlays::ResponsePlay
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-pagerduty-resource-providers.git
 */
class CfnResponsePlay extends cdk.CfnResource {
    /**
     * Create a new `PagerDuty::ResponsePlays::ResponsePlay`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnResponsePlay.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnResponsePlayProps(props) });
        this.props = props;
        this.attrType = cdk.Token.asString(this.getAtt('Type'));
    }
}
exports.CfnResponsePlay = CfnResponsePlay;
_a = JSII_RTTI_SYMBOL_1;
CfnResponsePlay[_a] = { fqn: "@cdk-cloudformation/pagerduty-responseplays-responseplay.CfnResponsePlay", version: "1.1.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnResponsePlay.CFN_RESOURCE_TYPE_NAME = "PagerDuty::ResponsePlays::ResponsePlay";
//# sourceMappingURL=data:application/json;base64,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