"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Trigger = exports.TriggerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc_generated_1 = require("./fc.generated");
Object.defineProperty(exports, "TriggerProperty", { enumerable: true, get: function () { return fc_generated_1.RosTrigger; } });
/**
 * A ROS resource type:  `ALIYUN::FC::Trigger`
 */
class Trigger extends ros.Resource {
    /**
     * Create a new `ALIYUN::FC::Trigger`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTrigger = new fc_generated_1.RosTrigger(this, id, {
            functionName: props.functionName,
            triggerType: props.triggerType,
            triggerName: props.triggerName,
            sourceArn: props.sourceArn,
            serviceName: props.serviceName,
            triggerConfig: props.triggerConfig,
            invocationRole: props.invocationRole,
            qualifier: props.qualifier,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTrigger;
        this.attrFunctionName = rosTrigger.attrFunctionName;
        this.attrServiceName = rosTrigger.attrServiceName;
        this.attrTriggerId = rosTrigger.attrTriggerId;
        this.attrTriggerName = rosTrigger.attrTriggerName;
    }
}
exports.Trigger = Trigger;
//# sourceMappingURL=data:application/json;base64,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