"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProvisionConfig = exports.ProvisionConfigProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc_generated_1 = require("./fc.generated");
Object.defineProperty(exports, "ProvisionConfigProperty", { enumerable: true, get: function () { return fc_generated_1.RosProvisionConfig; } });
/**
 * A ROS resource type:  `ALIYUN::FC::ProvisionConfig`
 */
class ProvisionConfig extends ros.Resource {
    /**
     * Create a new `ALIYUN::FC::ProvisionConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosProvisionConfig = new fc_generated_1.RosProvisionConfig(this, id, {
            functionName: props.functionName,
            target: props.target,
            serviceName: props.serviceName,
            qualifier: props.qualifier,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosProvisionConfig;
        this.attrFunctionName = rosProvisionConfig.attrFunctionName;
        this.attrQualifier = rosProvisionConfig.attrQualifier;
        this.attrResource = rosProvisionConfig.attrResource;
        this.attrServiceName = rosProvisionConfig.attrServiceName;
        this.attrTarget = rosProvisionConfig.attrTarget;
    }
}
exports.ProvisionConfig = ProvisionConfig;
//# sourceMappingURL=data:application/json;base64,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