"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionInvoker = exports.FunctionInvokerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc_generated_1 = require("./fc.generated");
Object.defineProperty(exports, "FunctionInvokerProperty", { enumerable: true, get: function () { return fc_generated_1.RosFunctionInvoker; } });
/**
 * A ROS resource type:  `ALIYUN::FC::FunctionInvoker`
 */
class FunctionInvoker extends ros.Resource {
    /**
     * Create a new `ALIYUN::FC::FunctionInvoker`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosFunctionInvoker = new fc_generated_1.RosFunctionInvoker(this, id, {
            functionName: props.functionName,
            executeVersion: props.executeVersion,
            serviceRegionId: props.serviceRegionId,
            serviceName: props.serviceName,
            async: props.async ? props.async : false,
            event: props.event,
            qualifier: props.qualifier,
            checkError: props.checkError,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFunctionInvoker;
        this.attrResult = rosFunctionInvoker.attrResult;
        this.attrResultType = rosFunctionInvoker.attrResultType;
    }
}
exports.FunctionInvoker = FunctionInvoker;
//# sourceMappingURL=data:application/json;base64,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