"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomDomain = exports.CustomDomainProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc_generated_1 = require("./fc.generated");
Object.defineProperty(exports, "CustomDomainProperty", { enumerable: true, get: function () { return fc_generated_1.RosCustomDomain; } });
/**
 * A ROS resource type:  `ALIYUN::FC::CustomDomain`
 */
class CustomDomain extends ros.Resource {
    /**
     * Create a new `ALIYUN::FC::CustomDomain`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCustomDomain = new fc_generated_1.RosCustomDomain(this, id, {
            apiVersion: props.apiVersion,
            certConfig: props.certConfig,
            domainName: props.domainName,
            routeConfig: props.routeConfig,
            protocol: props.protocol,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCustomDomain;
        this.attrDomain = rosCustomDomain.attrDomain;
        this.attrDomainName = rosCustomDomain.attrDomainName;
    }
}
exports.CustomDomain = CustomDomain;
//# sourceMappingURL=data:application/json;base64,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