"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Alias = exports.AliasProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fc_generated_1 = require("./fc.generated");
Object.defineProperty(exports, "AliasProperty", { enumerable: true, get: function () { return fc_generated_1.RosAlias; } });
/**
 * A ROS resource type:  `ALIYUN::FC::Alias`
 */
class Alias extends ros.Resource {
    /**
     * Create a new `ALIYUN::FC::Alias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAlias = new fc_generated_1.RosAlias(this, id, {
            versionId: props.versionId,
            description: props.description,
            serviceName: props.serviceName,
            additionalVersion: props.additionalVersion,
            aliasName: props.aliasName,
            additionalWeight: props.additionalWeight,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAlias;
        this.attrAliasName = rosAlias.attrAliasName;
        this.attrServiceName = rosAlias.attrServiceName;
        this.attrVersionId = rosAlias.attrVersionId;
    }
}
exports.Alias = Alias;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWxpYXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhbGlhcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsaURBQTBDO0FBRXJCLDhGQUZaLHVCQUFRLE9BRWlCO0FBc0NsQzs7R0FFRztBQUNILE1BQWEsS0FBTSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBc0JuQzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQWlCLEVBQUUsbUNBQTJDLElBQUk7UUFDNUcsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLFFBQVEsR0FBRyxJQUFJLHVCQUFRLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUNyQyxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO1NBQzNDLEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxhQUFhLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQztRQUM1QyxJQUFJLENBQUMsZUFBZSxHQUFHLFFBQVEsQ0FBQyxlQUFlLENBQUM7UUFDaEQsSUFBSSxDQUFDLGFBQWEsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDO0lBQ2hELENBQUM7Q0FDSjtBQTdDRCxzQkE2Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XHJcbmltcG9ydCB7IFJvc0FsaWFzIH0gZnJvbSAnLi9mYy5nZW5lcmF0ZWQnO1xyXG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cclxuZXhwb3J0IHsgUm9zQWxpYXMgYXMgQWxpYXNQcm9wZXJ0eSB9O1xyXG5cclxuLyoqXHJcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6RkM6OkFsaWFzYFxyXG4gKi9cclxuZXhwb3J0IGludGVyZmFjZSBBbGlhc1Byb3BzIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhbGlhc05hbWU6IEFsaWFzIG5hbWVcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgYWxpYXNOYW1lOiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgc2VydmljZU5hbWU6IFNlcnZpY2UgbmFtZVxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBzZXJ2aWNlTmFtZTogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGFkZGl0aW9uYWxWZXJzaW9uOiBBZGRpdGlvbmFsIHZlcnNpb25cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgYWRkaXRpb25hbFZlcnNpb24/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgYWRkaXRpb25hbFdlaWdodDogVHJhZmZpYyB3ZWlnaHQgb2YgYWRkaXRpb25hbCB2ZXJzaW9uLiBGcm9tIDAgdG8gMTAwLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBhZGRpdGlvbmFsV2VpZ2h0PzogbnVtYmVyO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGRlc2NyaXB0aW9uOiBWZXJzaW9uIGRlc2NyaXB0aW9uXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHZlcnNpb25JZDogVmVyc2lvbiBJRFxyXG4gICAgICovXHJcbiAgICByZWFkb25seSB2ZXJzaW9uSWQ/OiBzdHJpbmc7XHJcbn1cclxuXHJcbi8qKlxyXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6RkM6OkFsaWFzYFxyXG4gKi9cclxuZXhwb3J0IGNsYXNzIEFsaWFzIGV4dGVuZHMgcm9zLlJlc291cmNlIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcclxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxyXG4gICAgICovXHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAQXR0cmlidXRlIEFsaWFzTmFtZTogVGhlIGFsaWFzIG5hbWVcclxuICAgICAqL1xyXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJBbGlhc05hbWU6IGFueTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBBdHRyaWJ1dGUgU2VydmljZU5hbWU6IFRoZSBzZXJ2aWNlIG5hbWVcclxuICAgICAqL1xyXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJTZXJ2aWNlTmFtZTogYW55O1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQEF0dHJpYnV0ZSBWZXJzaW9uSWQ6IFRoZSB2ZXJzaW9uIElEXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyByZWFkb25seSBhdHRyVmVyc2lvbklkOiBhbnk7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6RkM6OkFsaWFzYC5cclxuICAgICAqXHJcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcclxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcclxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcclxuICAgICAqL1xyXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBBbGlhc1Byb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xyXG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XHJcblxyXG4gICAgICAgIGNvbnN0IHJvc0FsaWFzID0gbmV3IFJvc0FsaWFzKHRoaXMsIGlkLCAge1xyXG4gICAgICAgICAgICB2ZXJzaW9uSWQ6IHByb3BzLnZlcnNpb25JZCxcclxuICAgICAgICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxyXG4gICAgICAgICAgICBzZXJ2aWNlTmFtZTogcHJvcHMuc2VydmljZU5hbWUsXHJcbiAgICAgICAgICAgIGFkZGl0aW9uYWxWZXJzaW9uOiBwcm9wcy5hZGRpdGlvbmFsVmVyc2lvbixcclxuICAgICAgICAgICAgYWxpYXNOYW1lOiBwcm9wcy5hbGlhc05hbWUsXHJcbiAgICAgICAgICAgIGFkZGl0aW9uYWxXZWlnaHQ6IHByb3BzLmFkZGl0aW9uYWxXZWlnaHQsXHJcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XHJcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc0FsaWFzO1xyXG4gICAgICAgIHRoaXMuYXR0ckFsaWFzTmFtZSA9IHJvc0FsaWFzLmF0dHJBbGlhc05hbWU7XHJcbiAgICAgICAgdGhpcy5hdHRyU2VydmljZU5hbWUgPSByb3NBbGlhcy5hdHRyU2VydmljZU5hbWU7XHJcbiAgICAgICAgdGhpcy5hdHRyVmVyc2lvbklkID0gcm9zQWxpYXMuYXR0clZlcnNpb25JZDtcclxuICAgIH1cclxufVxyXG4iXX0=