[![](https://img.shields.io/pypi/v/foliantcontrib.ramldoc.svg)](https://pypi.org/project/foliantcontrib.ramldoc/)

# RAML API Docs Generator for Foliant

This preprocessor generates Markdown documentation from [RAML](https://raml.org/) spec files. It uses [raml2html](https://github.com/raml2html/raml2html) converter with [raml2html-full-markdown-theme](https://github.com/Vanderhoof/raml2html-full-markdown-theme).

raml2html uses [Nunjucks](https://mozilla.github.io/nunjucks/) templating system.

## Installation

First install `raml2html` and the markdown theme:

```bash
$ npm install -g raml2html raml2html-full-markdown-theme
```

Then install the preprocessor:

```bash
$ pip install foliantcontrib.ramldoc
```

## Config

To enable the preprocessor, add `ramldoc` to `preprocessors` section in the project config:

```yaml
preprocessors:
    - ramldoc
```

The preprocessor has a number of options:

```yaml
preprocessors:
    - ramldoc:
        spec_url: http://localhost/my_api.raml
        spec_path: !path my_api.raml
        template_dir: !path custom_templates
        raml2html_path: raml2html
```

`spec_url`
:    URL to RAML spec file. If it is a list — preprocessor picks the first working URL.

`spec_path`
:    Local path to RAML spec file.

> If both URL and path are specified — preprocessor first tries to fetch spec from URL, and then (if that fails) looks for the file on local path.

`template_dir`
:   Path to directory with [Nunjucks](https://mozilla.github.io/nunjucks/) templates. If not specified — default template is used. The main template in the directory must have a name `root.nunjucks`.

`raml2html_path`
:   Path to raml2html binary. Default: `raml2html`

## Usage

Add a `<ramldoc></ramldoc>` tag at the position in the document where the generated documentation should be inserted:

```
# Introduction

This document contains the automatically generated documentation of our API.

<ramldoc></ramldoc>
```

Each time the preprocessor encounters the tag `<ramldoc></ramldoc>` it inserts the whole generated documentation text instead of it. The path or url to RAML spec file are taken from foliant.yml.

You can also specify some parameters (or all of them) in the tag options:

```
# Introduction

Introduction text for API documentation.

<ramldoc spec_url="http://localhost/my_api.raml"
         template_dir="assets/templates">
</ramldoc>
```

Tag parameters have the highest priority.

This way you can have documentation from several different RAML spec files in one Foliant project (even in one md-file if you like it so).

## Customizing output

The output markdown is generated by [raml2html](https://github.com/raml2html/raml2html) converter, which uses [Nunjucks](https://mozilla.github.io/nunjucks/) templating engine (with syntax similar to [Jinja2](https://jinja.palletsprojects.com/). If you want to create your own template or modify the default one, specify the `template_dir` parameter.

The main template file in template dir must be named `root.nunjucks`.

You may use the [default template](https://github.com/Vanderhoof/raml2html-full-markdown-theme/tree/master/templates) as your starting point.
