#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 4.0.0-a53ec6ee1b on 2019-05-13.
#  2019, SMART Health IT.

import os
import pytest
import io
import unittest
import json

from .fixtures import force_bytes
from .. import valueset
from ..fhirdate import FHIRDate


@pytest.mark.usefixtures("base_settings")
class ValueSetTests(unittest.TestCase):
    def instantiate_from(self, filename):
        datadir = os.environ.get('FHIR_UNITTEST_DATADIR') or ''
        with io.open(os.path.join(datadir, filename), 'r', encoding='utf-8') as handle:
            js = json.load(handle)
            self.assertEqual("ValueSet", js["resourceType"])
        return valueset.ValueSet(js)
    
    def testValueSet1(self):
        inst = self.instantiate_from("valueset-example-hierarchical.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet1(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet1(inst2)
    
    def implValueSet1(self, inst):
        self.assertEqual(force_bytes(inst.compose.include[0].concept[0].code), force_bytes("invalid"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[1].code), force_bytes("structure"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[2].code), force_bytes("required"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[3].code), force_bytes("value"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[4].code), force_bytes("processing"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[5].code), force_bytes("duplicate"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[6].code), force_bytes("not-found"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[7].code), force_bytes("conflict"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[8].code), force_bytes("lock"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[9].code), force_bytes("exception"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[0].url), force_bytes("http://hl7.org/fhir/StructureDefinition/valueset-expand-rules"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[0].valueCode), force_bytes("groups-only"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[1].extension[0].url), force_bytes("display"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[1].extension[0].valueString), force_bytes("(Most common)"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[1].extension[1].url), force_bytes("member"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[1].extension[1].valueCode), force_bytes("login"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[1].extension[2].url), force_bytes("member"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[1].extension[2].valueCode), force_bytes("conflict"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[1].url), force_bytes("http://hl7.org/fhir/StructureDefinition/valueset-expand-group"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[2].extension[0].url), force_bytes("code"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[2].extension[0].valueString), force_bytes("processing"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[2].extension[1].url), force_bytes("member"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[2].extension[1].valueCode), force_bytes("duplicate"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[2].extension[2].url), force_bytes("member"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[2].extension[2].valueCode), force_bytes("not-found"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[2].url), force_bytes("http://hl7.org/fhir/StructureDefinition/valueset-expand-group"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[3].extension[0].url), force_bytes("code"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[3].extension[0].valueString), force_bytes("invalid"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[3].extension[1].url), force_bytes("member"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[3].extension[1].valueCode), force_bytes("structure"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[3].extension[2].url), force_bytes("member"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[3].extension[2].valueCode), force_bytes("required"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[3].extension[3].url), force_bytes("value"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[3].extension[3].valueCode), force_bytes("required"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[3].url), force_bytes("http://hl7.org/fhir/StructureDefinition/valueset-expand-group"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[4].extension[0].url), force_bytes("code"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[4].extension[0].valueString), force_bytes("transient"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[4].extension[1].url), force_bytes("member"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[4].extension[1].valueCode), force_bytes("lock"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[4].extension[2].url), force_bytes("member"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[4].extension[2].valueCode), force_bytes("exception"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[4].extension[3].url), force_bytes("value"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[4].extension[3].valueCode), force_bytes("throttled"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[4].url), force_bytes("http://hl7.org/fhir/StructureDefinition/valueset-expand-group"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[5].extension[0].url), force_bytes("code"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[5].extension[0].valueString), force_bytes("security"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[5].extension[1].url), force_bytes("member"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[5].extension[1].valueCode), force_bytes("login"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[5].extension[2].url), force_bytes("member"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[5].extension[2].valueCode), force_bytes("unknown"))
        self.assertEqual(force_bytes(inst.compose.include[0].extension[5].url), force_bytes("http://hl7.org/fhir/StructureDefinition/valueset-expand-group"))
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("#hacked"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(force_bytes(inst.contained[0].id), force_bytes("hacked"))
        self.assertEqual(inst.date.date, FHIRDate("2018-07-20").date)
        self.assertEqual(inst.date.as_json(), "2018-07-20")
        self.assertEqual(force_bytes(inst.description), force_bytes("Demonstration of extensions that build a hierarchical contains"))
        self.assertTrue(inst.expansion.contains[0].abstract)
        self.assertEqual(force_bytes(inst.expansion.contains[0].contains[0].code), force_bytes("login"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].contains[0].display), force_bytes("Login Required"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].contains[0].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].contains[1].code), force_bytes("conflict"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].contains[1].display), force_bytes("Edit Version Conflict"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].contains[1].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].display), force_bytes("(Most common)"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].code), force_bytes("processing"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].code), force_bytes("duplicate"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].display), force_bytes("Duplicate"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].code), force_bytes("not-found"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].display), force_bytes("Not Found"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].display), force_bytes("Processing Failure"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertTrue(inst.expansion.contains[2].abstract)
        self.assertEqual(force_bytes(inst.expansion.contains[2].code), force_bytes("invalid"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[0].code), force_bytes("structure"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[0].display), force_bytes("Structural Issue"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[0].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[1].code), force_bytes("required"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[1].display), force_bytes("Required element missing"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[1].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[2].code), force_bytes("value"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[2].display), force_bytes("Element value invalid"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[2].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].display), force_bytes("Invalid Content"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertTrue(inst.expansion.contains[3].abstract)
        self.assertEqual(force_bytes(inst.expansion.contains[3].code), force_bytes("transient"))
        self.assertEqual(force_bytes(inst.expansion.contains[3].contains[0].code), force_bytes("lock-error"))
        self.assertEqual(force_bytes(inst.expansion.contains[3].contains[0].display), force_bytes("Lock Error"))
        self.assertEqual(force_bytes(inst.expansion.contains[3].contains[0].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[3].contains[1].code), force_bytes("exception"))
        self.assertEqual(force_bytes(inst.expansion.contains[3].contains[1].display), force_bytes("Exception"))
        self.assertEqual(force_bytes(inst.expansion.contains[3].contains[1].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[3].contains[2].code), force_bytes("throttled"))
        self.assertEqual(force_bytes(inst.expansion.contains[3].contains[2].display), force_bytes("Throttled"))
        self.assertEqual(force_bytes(inst.expansion.contains[3].contains[2].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[3].display), force_bytes("Transient Issue"))
        self.assertEqual(force_bytes(inst.expansion.contains[3].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertTrue(inst.expansion.contains[4].abstract)
        self.assertEqual(force_bytes(inst.expansion.contains[4].code), force_bytes("security"))
        self.assertEqual(force_bytes(inst.expansion.contains[4].contains[0].code), force_bytes("login"))
        self.assertEqual(force_bytes(inst.expansion.contains[4].contains[0].display), force_bytes("Login Required"))
        self.assertEqual(force_bytes(inst.expansion.contains[4].contains[0].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[4].contains[1].code), force_bytes("unknown"))
        self.assertEqual(force_bytes(inst.expansion.contains[4].contains[1].display), force_bytes("Unknown User"))
        self.assertEqual(force_bytes(inst.expansion.contains[4].contains[1].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.contains[4].display), force_bytes("Security Problem"))
        self.assertEqual(force_bytes(inst.expansion.contains[4].system), force_bytes("http://hl7.org/fhir/hacked"))
        self.assertEqual(force_bytes(inst.expansion.identifier), force_bytes("urn:uuid:42316ff8-2714-4680-9980-f37a6d1a71bc"))
        self.assertEqual(force_bytes(inst.expansion.parameter[0].name), force_bytes("excludeNotForUI"))
        self.assertEqual(force_bytes(inst.expansion.parameter[0].valueUri), force_bytes("false"))
        self.assertEqual(inst.expansion.timestamp.date, FHIRDate("2018-07-20T23:14:07+10:00").date)
        self.assertEqual(inst.expansion.timestamp.as_json(), "2018-07-20T23:14:07+10:00")
        self.assertTrue(inst.experimental)
        self.assertEqual(force_bytes(inst.id), force_bytes("example-hierarchical"))
        self.assertEqual(force_bytes(inst.meta.profile[0]), force_bytes("http://hl7.org/fhir/StructureDefinition/shareablevalueset"))
        self.assertEqual(force_bytes(inst.name), force_bytes("Example Hierarchical ValueSet"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("FHIR Project team"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/example-hierarchical"))
        self.assertEqual(force_bytes(inst.version), force_bytes("4.0.0"))
    
    def testValueSet2(self):
        inst = self.instantiate_from("valueset-examplescenario-actor-type.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet2(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet2(inst2)
    
    def implValueSet2(self, inst):
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://hl7.org/fhir/examplescenario-actor-type"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[1].system), force_bytes("email"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[1].value), force_bytes("fhir@lists.hl7.org"))
        self.assertEqual(inst.date.date, FHIRDate("2018-12-27T22:37:54+11:00").date)
        self.assertEqual(inst.date.as_json(), "2018-12-27T22:37:54+11:00")
        self.assertEqual(force_bytes(inst.description), force_bytes("The type of actor - system or human."))
        self.assertFalse(inst.experimental)
        self.assertEqual(force_bytes(inst.extension[0].url), force_bytes("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"))
        self.assertEqual(force_bytes(inst.extension[0].valueCode), force_bytes("fhir"))
        self.assertEqual(force_bytes(inst.extension[1].url), force_bytes("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"))
        self.assertEqual(force_bytes(inst.extension[1].valueCode), force_bytes("trial-use"))
        self.assertEqual(force_bytes(inst.extension[2].url), force_bytes("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"))
        self.assertEqual(inst.extension[2].valueInteger, 0)
        self.assertEqual(force_bytes(inst.id), force_bytes("examplescenario-actor-type"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:ietf:rfc:3986"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("urn:oid:2.16.840.1.113883.4.642.3.858"))
        self.assertTrue(inst.immutable)
        self.assertEqual(inst.meta.lastUpdated.date, FHIRDate("2018-12-27T22:37:54.724+11:00").date)
        self.assertEqual(inst.meta.lastUpdated.as_json(), "2018-12-27T22:37:54.724+11:00")
        self.assertEqual(force_bytes(inst.meta.profile[0]), force_bytes("http://hl7.org/fhir/StructureDefinition/shareablevalueset"))
        self.assertEqual(force_bytes(inst.name), force_bytes("ExampleScenarioActorType"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("HL7 (FHIR Project)"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.title), force_bytes("ExampleScenarioActorType"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/examplescenario-actor-type"))
        self.assertEqual(force_bytes(inst.version), force_bytes("4.0.0"))
    
    def testValueSet3(self):
        inst = self.instantiate_from("valueset-example-expansion.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet3(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet3(inst2)
    
    def implValueSet3(self, inst):
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].op), force_bytes("="))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].property), force_bytes("parent"))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].value), force_bytes("LP43571-6"))
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(force_bytes(inst.copyright), force_bytes("This content from LOINC® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use."))
        self.assertEqual(inst.date.date, FHIRDate("2015-06-22").date)
        self.assertEqual(inst.date.as_json(), "2015-06-22")
        self.assertEqual(force_bytes(inst.description), force_bytes("This is an example value set that includes all the LOINC codes for serum/plasma cholesterol from v2.36."))
        self.assertEqual(force_bytes(inst.expansion.contains[0].code), force_bytes("14647-2"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].display), force_bytes("Cholesterol [Moles/volume] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].version), force_bytes("2.50"))
        self.assertTrue(inst.expansion.contains[1].abstract)
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].code), force_bytes("2093-3"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].display), force_bytes("Cholesterol [Mass/volume] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].code), force_bytes("48620-9"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].display), force_bytes("Cholesterol [Mass/volume] in Serum or Plasma ultracentrifugate"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[2].code), force_bytes("9342-7"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[2].display), force_bytes("Cholesterol [Percentile]"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[2].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[2].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].display), force_bytes("Cholesterol codes"))
        self.assertTrue(inst.expansion.contains[2].abstract)
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[0].code), force_bytes("2096-6"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[0].display), force_bytes("Cholesterol/Triglyceride [Mass Ratio] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[0].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[1].code), force_bytes("35200-5"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[1].display), force_bytes("Cholesterol/Triglyceride [Mass Ratio] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[1].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[1].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[2].code), force_bytes("48089-7"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[2].display), force_bytes("Cholesterol/Apolipoprotein B [Molar ratio] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[2].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[2].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[3].code), force_bytes("55838-7"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[3].display), force_bytes("Cholesterol/Phospholipid [Molar ratio] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[3].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[3].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].display), force_bytes("Cholesterol Ratios"))
        self.assertEqual(force_bytes(inst.expansion.extension[0].url), force_bytes("http://hl7.org/fhir/StructureDefinition/valueset-expansionSource"))
        self.assertEqual(force_bytes(inst.expansion.extension[0].valueUri), force_bytes("http://hl7.org/fhir/ValueSet/example-extensional"))
        self.assertEqual(force_bytes(inst.expansion.identifier), force_bytes("urn:uuid:42316ff8-2714-4680-9980-f37a6d1a71bc"))
        self.assertEqual(inst.expansion.offset, 0)
        self.assertEqual(force_bytes(inst.expansion.parameter[0].name), force_bytes("version"))
        self.assertEqual(force_bytes(inst.expansion.parameter[0].valueString), force_bytes("2.50"))
        self.assertEqual(inst.expansion.timestamp.date, FHIRDate("2015-06-22T13:56:07Z").date)
        self.assertEqual(inst.expansion.timestamp.as_json(), "2015-06-22T13:56:07Z")
        self.assertEqual(inst.expansion.total, 8)
        self.assertTrue(inst.experimental)
        self.assertEqual(force_bytes(inst.id), force_bytes("example-expansion"))
        self.assertEqual(force_bytes(inst.meta.profile[0]), force_bytes("http://hl7.org/fhir/StructureDefinition/shareablevalueset"))
        self.assertEqual(force_bytes(inst.name), force_bytes("LOINC Codes for Cholesterol in Serum/Plasma"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("FHIR Project team"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/example-expansion"))
        self.assertEqual(force_bytes(inst.version), force_bytes("20150622"))
    
    def testValueSet4(self):
        inst = self.instantiate_from("valueset-example-yesnodontknow.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet4(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet4(inst2)
    
    def implValueSet4(self, inst):
        self.assertEqual(force_bytes(inst.compose.include[0].valueSet[0]), force_bytes("http://terminology.hl7.org/ValueSet/v2-0136"))
        self.assertEqual(force_bytes(inst.compose.include[1].concept[0].code), force_bytes("asked-unknown"))
        self.assertEqual(force_bytes(inst.compose.include[1].concept[0].display), force_bytes("Don't know"))
        self.assertEqual(force_bytes(inst.compose.include[1].system), force_bytes("http://terminology.hl7.org/CodeSystem/data-absent-reason"))
        self.assertEqual(force_bytes(inst.description), force_bytes("For Capturing simple yes-no-don't know answers"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].code), force_bytes("Y"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].display), force_bytes("Yes"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/v2-0136"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].code), force_bytes("N"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].system), force_bytes("http://terminology.hl7.org/CodeSystem/v2-0136"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].code), force_bytes("asked-unknown"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].display), force_bytes("Don't know"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].system), force_bytes("http://terminology.hl7.org/CodeSystem/data-absent-reason"))
        self.assertEqual(force_bytes(inst.expansion.identifier), force_bytes("urn:uuid:bf99fe50-2c2b-41ad-bd63-bee6919810b4"))
        self.assertEqual(inst.expansion.timestamp.date, FHIRDate("2015-07-14T10:00:00Z").date)
        self.assertEqual(inst.expansion.timestamp.as_json(), "2015-07-14T10:00:00Z")
        self.assertEqual(force_bytes(inst.id), force_bytes("yesnodontknow"))
        self.assertEqual(force_bytes(inst.name), force_bytes("Yes/No/Don't Know"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/yesnodontknow"))
        self.assertEqual(force_bytes(inst.version), force_bytes("4.0.0"))
    
    def testValueSet5(self):
        inst = self.instantiate_from("valueset-example-filter.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet5(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet5(inst2)
    
    def implValueSet5(self, inst):
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].op), force_bytes("="))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].property), force_bytes("acme-plasma"))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].value), force_bytes("true"))
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://hl7.org/fhir/CodeSystem/example"))
        self.assertEqual(force_bytes(inst.contact[0].name), force_bytes("FHIR project team"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(inst.date.date, FHIRDate("2018-11-01").date)
        self.assertEqual(inst.date.as_json(), "2018-11-01")
        self.assertEqual(force_bytes(inst.description), force_bytes("ACME Codes for Cholesterol: Plasma only - demonstrating the use of a filter defined in a CodeSystem"))
        self.assertTrue(inst.experimental)
        self.assertEqual(force_bytes(inst.id), force_bytes("example-filter"))
        self.assertEqual(force_bytes(inst.name), force_bytes("ACMECholCodesPlasma"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("HL7 International"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.title), force_bytes("ACME Codes for Cholesterol: Plasma only"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/example-filter"))
        self.assertEqual(force_bytes(inst.version), force_bytes("4.0.0"))
    
    def testValueSet6(self):
        inst = self.instantiate_from("valueset-example-intensional.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet6(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet6(inst2)
    
    def implValueSet6(self, inst):
        self.assertEqual(force_bytes(inst.compose.exclude[0].concept[0].code), force_bytes("5932-9"))
        self.assertEqual(force_bytes(inst.compose.exclude[0].concept[0].display), force_bytes("Cholesterol [Presence] in Blood by Test strip"))
        self.assertEqual(force_bytes(inst.compose.exclude[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].op), force_bytes("="))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].property), force_bytes("parent"))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].value), force_bytes("LP43571-6"))
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.contact[0].name), force_bytes("FHIR project team"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(force_bytes(inst.copyright), force_bytes("This content from LOINCÂ® is copyright Â© 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use"))
        self.assertEqual(inst.date.date, FHIRDate("2015-06-22").date)
        self.assertEqual(inst.date.as_json(), "2015-06-22")
        self.assertEqual(force_bytes(inst.description), force_bytes("This is an example value set that includes all the LOINC codes for serum/plasma cholesterol from v2.36."))
        self.assertTrue(inst.experimental)
        self.assertEqual(force_bytes(inst.id), force_bytes("example-intensional"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("http://acme.com/identifiers/valuesets"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("loinc-cholesterol-ext"))
        self.assertEqual(force_bytes(inst.meta.profile[0]), force_bytes("http://hl7.org/fhir/StructureDefinition/shareablevalueset"))
        self.assertEqual(force_bytes(inst.name), force_bytes("LOINC Codes for Cholesterol in Serum/Plasma"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("HL7 International"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/example-intensional"))
        self.assertEqual(force_bytes(inst.version), force_bytes("20150622"))
    
    def testValueSet7(self):
        inst = self.instantiate_from("valueset-list-example-codes.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet7(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet7(inst2)
    
    def implValueSet7(self, inst):
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/list-example-use-codes"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(inst.date.date, FHIRDate("2018-12-27T22:37:54+11:00").date)
        self.assertEqual(inst.date.as_json(), "2018-12-27T22:37:54+11:00")
        self.assertEqual(force_bytes(inst.description), force_bytes("Example use codes for the List resource - typical kinds of use."))
        self.assertFalse(inst.experimental)
        self.assertEqual(force_bytes(inst.extension[0].url), force_bytes("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"))
        self.assertEqual(force_bytes(inst.extension[0].valueCode), force_bytes("fhir"))
        self.assertEqual(force_bytes(inst.extension[1].url), force_bytes("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"))
        self.assertEqual(force_bytes(inst.extension[1].valueCode), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.extension[2].url), force_bytes("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"))
        self.assertEqual(inst.extension[2].valueInteger, 1)
        self.assertEqual(force_bytes(inst.id), force_bytes("list-example-codes"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:ietf:rfc:3986"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("urn:oid:2.16.840.1.113883.4.642.3.316"))
        self.assertTrue(inst.immutable)
        self.assertEqual(inst.meta.lastUpdated.date, FHIRDate("2018-12-27T22:37:54.724+11:00").date)
        self.assertEqual(inst.meta.lastUpdated.as_json(), "2018-12-27T22:37:54.724+11:00")
        self.assertEqual(force_bytes(inst.meta.profile[0]), force_bytes("http://hl7.org/fhir/StructureDefinition/shareablevalueset"))
        self.assertEqual(force_bytes(inst.name), force_bytes("ExampleUseCodesForList"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("FHIR Project"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.title), force_bytes("Example Use Codes for List"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/list-example-codes"))
        self.assertEqual(force_bytes(inst.version), force_bytes("4.0.0"))
    
    def testValueSet8(self):
        inst = self.instantiate_from("valueset-example.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet8(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet8(inst2)
    
    def implValueSet8(self, inst):
        self.assertTrue(inst.compose.inactive)
        self.assertEqual(force_bytes(inst.compose.include[0].concept[0].code), force_bytes("14647-2"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[0].display), force_bytes("Cholesterol [Moles/Volume]"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[1].code), force_bytes("2093-3"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[1].display), force_bytes("Cholesterol [Mass/Volume]"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[2].code), force_bytes("35200-5"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[2].display), force_bytes("Cholesterol [Mass Or Moles/Volume]"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[3].code), force_bytes("9342-7"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[3].display), force_bytes("Cholesterol [Percentile]"))
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.compose.include[0].version), force_bytes("2.36"))
        self.assertEqual(inst.compose.lockedDate.date, FHIRDate("2012-06-13").date)
        self.assertEqual(inst.compose.lockedDate.as_json(), "2012-06-13")
        self.assertEqual(force_bytes(inst.contact[0].name), force_bytes("FHIR project team"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(force_bytes(inst.copyright), force_bytes("This content from LOINC ® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use."))
        self.assertEqual(inst.date.date, FHIRDate("2015-06-22").date)
        self.assertEqual(inst.date.as_json(), "2015-06-22")
        self.assertEqual(force_bytes(inst.description), force_bytes("This is an example value set that includes all the LOINC codes for serum/plasma cholesterol from v2.36."))
        self.assertTrue(inst.experimental)
        self.assertEqual(force_bytes(inst.id), force_bytes("example-extensional"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("http://acme.com/identifiers/valuesets"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("loinc-cholesterol-int"))
        self.assertEqual(force_bytes(inst.jurisdiction[0].coding[0].code), force_bytes("US"))
        self.assertEqual(force_bytes(inst.jurisdiction[0].coding[0].system), force_bytes("urn:iso:std:iso:3166"))
        self.assertEqual(force_bytes(inst.meta.profile[0]), force_bytes("http://hl7.org/fhir/StructureDefinition/shareablevalueset"))
        self.assertEqual(force_bytes(inst.name), force_bytes("LOINC Codes for Cholesterol in Serum/Plasma"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("HL7 International"))
        self.assertEqual(force_bytes(inst.purpose), force_bytes("This value set was published by ACME Inc in order to make clear which codes are used for Cholesterol by AcmeClinicals (Adult Ambulatory care support in USA)"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/example-extensional"))
        self.assertEqual(force_bytes(inst.useContext[0].code.code), force_bytes("age"))
        self.assertEqual(force_bytes(inst.useContext[0].code.system), force_bytes("http://terminology.hl7.org/CodeSystem/usage-context-type"))
        self.assertEqual(force_bytes(inst.useContext[0].valueQuantity.code), force_bytes("a"))
        self.assertEqual(force_bytes(inst.useContext[0].valueQuantity.comparator), force_bytes(">"))
        self.assertEqual(force_bytes(inst.useContext[0].valueQuantity.system), force_bytes("http://unitsofmeasure.org"))
        self.assertEqual(force_bytes(inst.useContext[0].valueQuantity.unit), force_bytes("yrs"))
        self.assertEqual(inst.useContext[0].valueQuantity.value, 18)
        self.assertEqual(force_bytes(inst.version), force_bytes("20150622"))
    
    def testValueSet9(self):
        inst = self.instantiate_from("valueset-example-inactive.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet9(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet9(inst2)
    
    def implValueSet9(self, inst):
        self.assertTrue(inst.compose.inactive)
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].op), force_bytes("descendent-of"))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].property), force_bytes("concept"))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].value), force_bytes("_ActMoodPredicate"))
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActMood"))
        self.assertEqual(force_bytes(inst.description), force_bytes("HL7 v3 ActMood Predicate codes, including inactive codes"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].code), force_bytes("CRT"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].display), force_bytes("criterion"))
        self.assertTrue(inst.expansion.contains[0].inactive)
        self.assertEqual(force_bytes(inst.expansion.contains[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActMood"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].code), force_bytes("EXPEC"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].code), force_bytes("GOL"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].display), force_bytes("goal"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActMood"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].code), force_bytes("RSK"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].display), force_bytes("risk"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActMood"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].display), force_bytes("expectation"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActMood"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].code), force_bytes("OPT"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].display), force_bytes("option"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActMood"))
        self.assertEqual(force_bytes(inst.expansion.identifier), force_bytes("urn:uuid:46c00b3f-003a-4f31-9d4b-ea2de58b2a99"))
        self.assertEqual(inst.expansion.timestamp.date, FHIRDate("2017-02-26T10:00:00Z").date)
        self.assertEqual(inst.expansion.timestamp.as_json(), "2017-02-26T10:00:00Z")
        self.assertEqual(force_bytes(inst.id), force_bytes("inactive"))
        self.assertEqual(force_bytes(inst.name), force_bytes("Example-inactive"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.title), force_bytes("Example with inactive codes"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/inactive"))
        self.assertEqual(force_bytes(inst.version), force_bytes("4.0.0"))

