#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 4.0.0-a53ec6ee1b on 2019-05-13.
#  2019, SMART Health IT.

import os
import pytest
import io
import unittest
import json

from .fixtures import force_bytes
from .. import questionnaireresponse
from ..fhirdate import FHIRDate


@pytest.mark.usefixtures("base_settings")
class QuestionnaireResponseTests(unittest.TestCase):
    def instantiate_from(self, filename):
        datadir = os.environ.get('FHIR_UNITTEST_DATADIR') or ''
        with io.open(os.path.join(datadir, filename), 'r', encoding='utf-8') as handle:
            js = json.load(handle)
            self.assertEqual("QuestionnaireResponse", js["resourceType"])
        return questionnaireresponse.QuestionnaireResponse(js)
    
    def testQuestionnaireResponse1(self):
        inst = self.instantiate_from("questionnaireresponse-example.json")
        self.assertIsNotNone(inst, "Must have instantiated a QuestionnaireResponse instance")
        self.implQuestionnaireResponse1(inst)
        
        js = inst.as_json()
        self.assertEqual("QuestionnaireResponse", js["resourceType"])
        inst2 = questionnaireresponse.QuestionnaireResponse(js)
        self.implQuestionnaireResponse1(inst2)
    
    def implQuestionnaireResponse1(self, inst):
        self.assertEqual(inst.authored.date, FHIRDate("2013-02-19T14:15:00-05:00").date)
        self.assertEqual(inst.authored.as_json(), "2013-02-19T14:15:00-05:00")
        self.assertEqual(force_bytes(inst.contained[0].id), force_bytes("patsub"))
        self.assertEqual(force_bytes(inst.contained[1].id), force_bytes("order"))
        self.assertEqual(force_bytes(inst.contained[2].id), force_bytes("questauth"))
        self.assertEqual(force_bytes(inst.id), force_bytes("3141"))
        self.assertEqual(force_bytes(inst.identifier.system), force_bytes("http://example.org/fhir/NamingSystem/questionnaire-ids"))
        self.assertEqual(force_bytes(inst.identifier.value), force_bytes("Q12349876"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].item[0].item[0].answer[0].valueCoding.code), force_bytes("1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://cancer.questionnaire.org/system/code/yesno"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].item[0].item[0].linkId), force_bytes("1.1.1.1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].item[0].item[1].answer[0].valueCoding.code), force_bytes("1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].item[0].item[1].answer[0].valueCoding.system), force_bytes("http://cancer.questionnaire.org/system/code/yesno"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].item[0].item[1].linkId), force_bytes("1.1.1.2"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].item[0].item[2].answer[0].valueCoding.code), force_bytes("0"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].item[0].item[2].answer[0].valueCoding.system), force_bytes("http://cancer.questionnaire.org/system/code/yesno"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].item[0].item[2].linkId), force_bytes("1.1.1.3"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].item[0].linkId), force_bytes("1.1.1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].valueCoding.code), force_bytes("1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].valueCoding.display), force_bytes("Yes"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].valueCoding.system), force_bytes("http://cancer.questionnaire.org/system/code/yesno"))
        self.assertEqual(force_bytes(inst.item[0].item[0].linkId), force_bytes("1.1"))
        self.assertEqual(force_bytes(inst.item[0].linkId), force_bytes("1"))
        self.assertEqual(force_bytes(inst.meta.tag[0].code), force_bytes("HTEST"))
        self.assertEqual(force_bytes(inst.meta.tag[0].display), force_bytes("test health data"))
        self.assertEqual(force_bytes(inst.meta.tag[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActReason"))
        self.assertEqual(force_bytes(inst.status), force_bytes("completed"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testQuestionnaireResponse2(self):
        inst = self.instantiate_from("questionnaireresponse-example-f201-lifelines.json")
        self.assertIsNotNone(inst, "Must have instantiated a QuestionnaireResponse instance")
        self.implQuestionnaireResponse2(inst)
        
        js = inst.as_json()
        self.assertEqual("QuestionnaireResponse", js["resourceType"])
        inst2 = questionnaireresponse.QuestionnaireResponse(js)
        self.implQuestionnaireResponse2(inst2)
    
    def implQuestionnaireResponse2(self, inst):
        self.assertEqual(inst.authored.date, FHIRDate("2013-06-18T00:00:00+01:00").date)
        self.assertEqual(inst.authored.as_json(), "2013-06-18T00:00:00+01:00")
        self.assertEqual(force_bytes(inst.id), force_bytes("f201"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answer[0].valueString), force_bytes("I am allergic to house dust"))
        self.assertEqual(force_bytes(inst.item[0].item[0].linkId), force_bytes("1.1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].text), force_bytes("Do you have allergies?"))
        self.assertEqual(force_bytes(inst.item[0].linkId), force_bytes("1"))
        self.assertEqual(force_bytes(inst.item[1].item[0].answer[0].valueString), force_bytes("Male"))
        self.assertEqual(force_bytes(inst.item[1].item[0].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[1].item[0].text), force_bytes("What is your gender?"))
        self.assertEqual(inst.item[1].item[1].answer[0].valueDate.date, FHIRDate("1960-03-13").date)
        self.assertEqual(inst.item[1].item[1].answer[0].valueDate.as_json(), "1960-03-13")
        self.assertEqual(force_bytes(inst.item[1].item[1].linkId), force_bytes("2.2"))
        self.assertEqual(force_bytes(inst.item[1].item[1].text), force_bytes("What is your date of birth?"))
        self.assertEqual(force_bytes(inst.item[1].item[2].answer[0].valueString), force_bytes("The Netherlands"))
        self.assertEqual(force_bytes(inst.item[1].item[2].linkId), force_bytes("2.3"))
        self.assertEqual(force_bytes(inst.item[1].item[2].text), force_bytes("What is your country of birth?"))
        self.assertEqual(force_bytes(inst.item[1].item[3].answer[0].valueString), force_bytes("married"))
        self.assertEqual(force_bytes(inst.item[1].item[3].linkId), force_bytes("2.4"))
        self.assertEqual(force_bytes(inst.item[1].item[3].text), force_bytes("What is your marital status?"))
        self.assertEqual(force_bytes(inst.item[1].linkId), force_bytes("2"))
        self.assertEqual(force_bytes(inst.item[1].text), force_bytes("General questions"))
        self.assertEqual(force_bytes(inst.item[2].item[0].answer[0].valueString), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[0].linkId), force_bytes("3.1"))
        self.assertEqual(force_bytes(inst.item[2].item[0].text), force_bytes("Do you smoke?"))
        self.assertEqual(force_bytes(inst.item[2].item[1].answer[0].valueString), force_bytes("No, but I used to drink"))
        self.assertEqual(force_bytes(inst.item[2].item[1].linkId), force_bytes("3.2"))
        self.assertEqual(force_bytes(inst.item[2].item[1].text), force_bytes("Do you drink alchohol?"))
        self.assertEqual(force_bytes(inst.item[2].linkId), force_bytes("3"))
        self.assertEqual(force_bytes(inst.item[2].text), force_bytes("Intoxications"))
        self.assertEqual(force_bytes(inst.meta.tag[0].code), force_bytes("HTEST"))
        self.assertEqual(force_bytes(inst.meta.tag[0].display), force_bytes("test health data"))
        self.assertEqual(force_bytes(inst.meta.tag[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActReason"))
        self.assertEqual(force_bytes(inst.status), force_bytes("completed"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testQuestionnaireResponse3(self):
        inst = self.instantiate_from("questionnaireresponse-example-ussg-fht-answers.json")
        self.assertIsNotNone(inst, "Must have instantiated a QuestionnaireResponse instance")
        self.implQuestionnaireResponse3(inst)
        
        js = inst.as_json()
        self.assertEqual("QuestionnaireResponse", js["resourceType"])
        inst2 = questionnaireresponse.QuestionnaireResponse(js)
        self.implQuestionnaireResponse3(inst2)
    
    def implQuestionnaireResponse3(self, inst):
        self.assertEqual(inst.authored.date, FHIRDate("2008-01-17").date)
        self.assertEqual(inst.authored.as_json(), "2008-01-17")
        self.assertEqual(force_bytes(inst.id), force_bytes("ussg-fht-answers"))
        self.assertEqual(inst.item[0].item[0].answer[0].valueDate.date, FHIRDate("2008-01-17").date)
        self.assertEqual(inst.item[0].item[0].answer[0].valueDate.as_json(), "2008-01-17")
        self.assertEqual(force_bytes(inst.item[0].item[0].linkId), force_bytes("0.1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].text), force_bytes("Date Done"))
        self.assertEqual(force_bytes(inst.item[0].linkId), force_bytes("0"))
        self.assertEqual(force_bytes(inst.item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54126-8"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[0].answer[0].valueString), force_bytes("Annie Proband"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54125-0"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[0].linkId), force_bytes("1.1.1"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[0].text), force_bytes("Name"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[1].answer[0].valueCoding.code), force_bytes("LA3-6"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[1].answer[0].valueCoding.display), force_bytes("Female"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[1].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54131-8"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[1].linkId), force_bytes("1.1.2"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[1].text), force_bytes("Gender"))
        self.assertEqual(inst.item[1].item[0].item[2].answer[0].valueDate.date, FHIRDate("1966-04-04").date)
        self.assertEqual(inst.item[1].item[0].item[2].answer[0].valueDate.as_json(), "1966-04-04")
        self.assertEqual(force_bytes(inst.item[1].item[0].item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/21112-8"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[2].linkId), force_bytes("1.1.3"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[2].text), force_bytes("Date of Birth"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[3].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[3].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[3].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[3].definition), force_bytes("http://loinc.org/fhir/DataElement/54132-6"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[3].linkId), force_bytes("1.1.4"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[3].text), force_bytes("Were you born a twin?"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[4].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[4].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[4].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[4].definition), force_bytes("http://loinc.org/fhir/DataElement/54128-4"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[4].linkId), force_bytes("1.1.5"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[4].text), force_bytes("Were you adopted?"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[5].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[5].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[5].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[5].definition), force_bytes("http://loinc.org/fhir/DataElement/54135-9"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[5].linkId), force_bytes("1.1.6"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[5].text), force_bytes("Are your parents related to each other in any way other than marriage?"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[6].answer[0].item[0].item[0].answer[0].valueCoding.code), force_bytes("[in_i]"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[6].answer[0].item[0].item[0].answer[0].valueCoding.display), force_bytes("inches"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[6].answer[0].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://unitsofmeasure.org"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[6].answer[0].item[0].item[0].linkId), force_bytes("1.1.7.1.1"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[6].answer[0].item[0].item[0].text), force_bytes("Units"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[6].answer[0].item[0].linkId), force_bytes("1.1.7.1"))
        self.assertEqual(inst.item[1].item[0].item[6].answer[0].valueDecimal, 63)
        self.assertEqual(force_bytes(inst.item[1].item[0].item[6].definition), force_bytes("http://loinc.org/fhir/DataElement/8302-2"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[6].linkId), force_bytes("1.1.7"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[6].text), force_bytes("Height"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[7].answer[0].item[0].item[0].answer[0].valueCoding.code), force_bytes("[lb_av]"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[7].answer[0].item[0].item[0].answer[0].valueCoding.display), force_bytes("pounds"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[7].answer[0].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://unitsofmeasure.org"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[7].answer[0].item[0].item[0].linkId), force_bytes("1.1.8.1.1"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[7].answer[0].item[0].item[0].text), force_bytes("Units"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[7].answer[0].item[0].linkId), force_bytes("1.1.8.1"))
        self.assertEqual(inst.item[1].item[0].item[7].answer[0].valueDecimal, 127)
        self.assertEqual(force_bytes(inst.item[1].item[0].item[7].definition), force_bytes("http://loinc.org/fhir/DataElement/29463-7"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[7].linkId), force_bytes("1.1.8"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[7].text), force_bytes("Weight"))
        self.assertEqual(inst.item[1].item[0].item[8].answer[0].valueDecimal, 22.5)
        self.assertEqual(force_bytes(inst.item[1].item[0].item[8].definition), force_bytes("http://loinc.org/fhir/DataElement/39156-5"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[8].linkId), force_bytes("1.1.9"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[8].text), force_bytes("Body mass index (BMI) [Ratio]"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[9].answer[0].valueCoding.code), force_bytes("LA4457-3"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[9].answer[0].valueCoding.display), force_bytes("White"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[9].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[9].definition), force_bytes("http://loinc.org/fhir/DataElement/54134-2"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[9].linkId), force_bytes("1.1.10"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[9].text), force_bytes("Race"))
        self.assertEqual(force_bytes(inst.item[1].item[0].linkId), force_bytes("1.1"))
        self.assertEqual(force_bytes(inst.item[1].linkId), force_bytes("1"))
        self.assertEqual(force_bytes(inst.item[1].text), force_bytes("Your health information"))
        self.assertEqual(force_bytes(inst.item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/54114-4"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10405-1"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[0].answer[0].valueCoding.display), force_bytes("Daughter"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54136-7"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[0].linkId), force_bytes("2.1.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[0].text), force_bytes("Relationship to you"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[1].answer[0].valueString), force_bytes("Susan"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54138-3"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[1].linkId), force_bytes("2.1.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[1].text), force_bytes("Name"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[2].answer[0].valueCoding.code), force_bytes("LA3-6"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[2].answer[0].valueCoding.display), force_bytes("Female"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[2].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/54123-5"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[2].linkId), force_bytes("2.1.1.3"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[2].text), force_bytes("Gender"))
        self.assertEqual(inst.item[2].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 17)
        self.assertEqual(force_bytes(inst.item[2].item[0].item[3].answer[0].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54141-7"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[3].answer[0].item[0].item[0].linkId), force_bytes("2.1.1.4.2.2"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[3].answer[0].item[0].item[0].text), force_bytes("Age"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[3].answer[0].item[0].linkId), force_bytes("2.1.1.4.2"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[3].answer[0].valueCoding.code), force_bytes("LA33-6"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[3].answer[0].valueCoding.display), force_bytes("Yes"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[3].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[3].definition), force_bytes("http://loinc.org/fhir/DataElement/54139-1"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[3].linkId), force_bytes("2.1.1.4"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[3].text), force_bytes("Living?"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[4].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[4].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[4].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[4].definition), force_bytes("http://loinc.org/fhir/DataElement/54121-9"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[4].linkId), force_bytes("2.1.1.5"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[4].text), force_bytes("Was this person born a twin?"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[5].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[5].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[5].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[5].definition), force_bytes("http://loinc.org/fhir/DataElement/54122-7"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[5].linkId), force_bytes("2.1.1.6"))
        self.assertEqual(force_bytes(inst.item[2].item[0].item[5].text), force_bytes("Was this person adopted?"))
        self.assertEqual(force_bytes(inst.item[2].item[0].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10415-0"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[0].answer[0].valueCoding.display), force_bytes("Brother"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54136-7"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[0].linkId), force_bytes("2.1.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[0].text), force_bytes("Relationship to you"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[1].answer[0].valueString), force_bytes("Brian"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54138-3"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[1].linkId), force_bytes("2.1.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[1].text), force_bytes("Name"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[2].answer[0].valueCoding.code), force_bytes("LA2-8"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[2].answer[0].valueCoding.display), force_bytes("Male"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[2].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/54123-5"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[2].linkId), force_bytes("2.1.1.3"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[2].text), force_bytes("Gender"))
        self.assertEqual(inst.item[2].item[1].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 32)
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[3].answer[0].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54141-7"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[3].answer[0].item[0].item[0].linkId), force_bytes("2.1.1.4.2.2"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[3].answer[0].item[0].item[0].text), force_bytes("Age"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[3].answer[0].item[0].linkId), force_bytes("2.1.1.4.2"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[3].answer[0].valueCoding.code), force_bytes("LA33-6"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[3].answer[0].valueCoding.display), force_bytes("Yes"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[3].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[3].definition), force_bytes("http://loinc.org/fhir/DataElement/54139-1"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[3].linkId), force_bytes("2.1.1.4"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[3].text), force_bytes("Living?"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[4].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[4].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[4].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[4].definition), force_bytes("http://loinc.org/fhir/DataElement/54121-9"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[4].linkId), force_bytes("2.1.1.5"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[4].text), force_bytes("Was this person born a twin?"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[5].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[5].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[5].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[5].definition), force_bytes("http://loinc.org/fhir/DataElement/54122-7"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[5].linkId), force_bytes("2.1.1.6"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].item[5].text), force_bytes("Was this person adopted?"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[0].linkId), force_bytes("2.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].item[0].answer[0].valueCoding.code), force_bytes("LA10550-4"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].item[0].answer[0].valueCoding.display), force_bytes("-- Other Cancer"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].item[0].linkId), force_bytes("2.1.2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].item[0].text), force_bytes("Disease or Condition"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].item[1].answer[0].valueCoding.code), force_bytes("LA10397-0"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].item[1].answer[0].valueCoding.display), force_bytes("30-39"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].item[1].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].item[1].linkId), force_bytes("2.1.2.2"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].item[1].text), force_bytes("Age at Diagnosis"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].linkId), force_bytes("2.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[1].item[1].text), force_bytes("This family member's history of disease"))
        self.assertEqual(force_bytes(inst.item[2].item[1].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10418-4"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[0].answer[0].valueCoding.display), force_bytes("Sister"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54136-7"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[0].linkId), force_bytes("2.1.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[0].text), force_bytes("Relationship to you"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[1].answer[0].valueString), force_bytes("Janet"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54138-3"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[1].linkId), force_bytes("2.1.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[1].text), force_bytes("Name"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[2].answer[0].valueCoding.code), force_bytes("LA3-6"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[2].answer[0].valueCoding.display), force_bytes("Female"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[2].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/54123-5"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[2].linkId), force_bytes("2.1.1.3"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[2].text), force_bytes("Gender"))
        self.assertEqual(inst.item[2].item[2].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 36)
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[3].answer[0].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54141-7"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[3].answer[0].item[0].item[0].linkId), force_bytes("2.1.1.4.2.2"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[3].answer[0].item[0].item[0].text), force_bytes("Age"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[3].answer[0].item[0].linkId), force_bytes("2.1.1.4.2"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[3].answer[0].valueCoding.code), force_bytes("LA33-6"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[3].answer[0].valueCoding.display), force_bytes("Yes"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[3].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[3].definition), force_bytes("http://loinc.org/fhir/DataElement/54139-1"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[3].linkId), force_bytes("2.1.1.4"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[3].text), force_bytes("Living?"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[4].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[4].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[4].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[4].definition), force_bytes("http://loinc.org/fhir/DataElement/54121-9"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[4].linkId), force_bytes("2.1.1.5"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[4].text), force_bytes("Was this person born a twin?"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[5].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[5].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[5].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[5].definition), force_bytes("http://loinc.org/fhir/DataElement/54122-7"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[5].linkId), force_bytes("2.1.1.6"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].item[5].text), force_bytes("Was this person adopted?"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[0].linkId), force_bytes("2.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].item[0].answer[0].valueCoding.code), force_bytes("LA10536-3"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].item[0].answer[0].valueCoding.display), force_bytes("-- Breast Cancer"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].item[0].linkId), force_bytes("2.1.2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].item[0].text), force_bytes("Disease or Condition"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].item[1].answer[0].valueCoding.code), force_bytes("LA10397-0"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].item[1].answer[0].valueCoding.display), force_bytes("30-39"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].item[1].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].item[1].linkId), force_bytes("2.1.2.2"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].item[1].text), force_bytes("Age at Diagnosis"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].linkId), force_bytes("2.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[2].item[1].text), force_bytes("This family member's history of disease"))
        self.assertEqual(force_bytes(inst.item[2].item[2].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10419-2"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[0].answer[0].valueCoding.display), force_bytes("Nephew"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54136-7"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[0].linkId), force_bytes("2.1.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[0].text), force_bytes("Relationship to you"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[1].answer[0].valueString), force_bytes("Ian"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54138-3"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[1].linkId), force_bytes("2.1.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[1].text), force_bytes("Name"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[2].answer[0].valueCoding.code), force_bytes("LA2-8"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[2].answer[0].valueCoding.display), force_bytes("Male"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[2].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/54123-5"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[2].linkId), force_bytes("2.1.1.3"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[2].text), force_bytes("Gender"))
        self.assertEqual(inst.item[2].item[3].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 16)
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[3].answer[0].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54141-7"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[3].answer[0].item[0].item[0].linkId), force_bytes("2.1.1.4.2.2"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[3].answer[0].item[0].item[0].text), force_bytes("Age"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[3].answer[0].item[0].linkId), force_bytes("2.1.1.4.2"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[3].answer[0].valueCoding.code), force_bytes("LA33-6"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[3].answer[0].valueCoding.display), force_bytes("Yes"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[3].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[3].definition), force_bytes("http://loinc.org/fhir/DataElement/54139-1"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[3].linkId), force_bytes("2.1.1.4"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[3].text), force_bytes("Living?"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[4].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[4].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[4].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[4].definition), force_bytes("http://loinc.org/fhir/DataElement/54121-9"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[4].linkId), force_bytes("2.1.1.5"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[4].text), force_bytes("Was this person born a twin?"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[5].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[5].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[5].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[5].definition), force_bytes("http://loinc.org/fhir/DataElement/54122-7"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[5].linkId), force_bytes("2.1.1.6"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].item[5].text), force_bytes("Was this person adopted?"))
        self.assertEqual(force_bytes(inst.item[2].item[3].item[0].linkId), force_bytes("2.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[3].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10420-0"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[0].answer[0].valueCoding.display), force_bytes("Niece"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54136-7"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[0].linkId), force_bytes("2.1.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[0].text), force_bytes("Relationship to you"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[1].answer[0].valueString), force_bytes("Helen"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54138-3"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[1].linkId), force_bytes("2.1.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[1].text), force_bytes("Name"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[2].answer[0].valueCoding.code), force_bytes("LA3-6"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[2].answer[0].valueCoding.display), force_bytes("Female"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[2].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/54123-5"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[2].linkId), force_bytes("2.1.1.3"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[2].text), force_bytes("Gender"))
        self.assertEqual(inst.item[2].item[4].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 15)
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[3].answer[0].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54141-7"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[3].answer[0].item[0].item[0].linkId), force_bytes("2.1.1.4.2.2"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[3].answer[0].item[0].item[0].text), force_bytes("Age"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[3].answer[0].item[0].linkId), force_bytes("2.1.1.4.2"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[3].answer[0].valueCoding.code), force_bytes("LA33-6"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[3].answer[0].valueCoding.display), force_bytes("Yes"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[3].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[3].definition), force_bytes("http://loinc.org/fhir/DataElement/54139-1"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[3].linkId), force_bytes("2.1.1.4"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[3].text), force_bytes("Living?"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[4].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[4].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[4].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[4].definition), force_bytes("http://loinc.org/fhir/DataElement/54121-9"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[4].linkId), force_bytes("2.1.1.5"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[4].text), force_bytes("Was this person born a twin?"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[5].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[5].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[5].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[5].definition), force_bytes("http://loinc.org/fhir/DataElement/54122-7"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[5].linkId), force_bytes("2.1.1.6"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].item[5].text), force_bytes("Was this person adopted?"))
        self.assertEqual(force_bytes(inst.item[2].item[4].item[0].linkId), force_bytes("2.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[4].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10416-8"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[0].answer[0].valueCoding.display), force_bytes("Father"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54136-7"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[0].linkId), force_bytes("2.1.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[0].text), force_bytes("Relationship to you"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[1].answer[0].valueString), force_bytes("Donald"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54138-3"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[1].linkId), force_bytes("2.1.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[1].text), force_bytes("Name"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[2].answer[0].valueCoding.code), force_bytes("LA2-8"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[2].answer[0].valueCoding.display), force_bytes("Male"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[2].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/54123-5"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[2].linkId), force_bytes("2.1.1.3"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[2].text), force_bytes("Gender"))
        self.assertEqual(inst.item[2].item[5].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 52)
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[3].answer[0].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54141-7"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[3].answer[0].item[0].item[0].linkId), force_bytes("2.1.1.4.2.2"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[3].answer[0].item[0].item[0].text), force_bytes("Age"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[3].answer[0].item[0].linkId), force_bytes("2.1.1.4.2"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[3].answer[0].valueCoding.code), force_bytes("LA33-6"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[3].answer[0].valueCoding.display), force_bytes("Yes"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[3].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[3].definition), force_bytes("http://loinc.org/fhir/DataElement/54139-1"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[3].linkId), force_bytes("2.1.1.4"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[3].text), force_bytes("Living?"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[4].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[4].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[4].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[4].definition), force_bytes("http://loinc.org/fhir/DataElement/54121-9"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[4].linkId), force_bytes("2.1.1.5"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[4].text), force_bytes("Was this person born a twin?"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[5].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[5].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[5].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[5].definition), force_bytes("http://loinc.org/fhir/DataElement/54122-7"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[5].linkId), force_bytes("2.1.1.6"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].item[5].text), force_bytes("Was this person adopted?"))
        self.assertEqual(force_bytes(inst.item[2].item[5].item[0].linkId), force_bytes("2.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[5].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10425-9"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[0].answer[0].valueCoding.display), force_bytes("Paternal Uncle"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54136-7"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[0].linkId), force_bytes("2.1.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[0].text), force_bytes("Relationship to you"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[1].answer[0].valueString), force_bytes("Eric"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54138-3"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[1].linkId), force_bytes("2.1.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[1].text), force_bytes("Name"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[2].answer[0].valueCoding.code), force_bytes("LA2-8"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[2].answer[0].valueCoding.display), force_bytes("Male"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[2].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/54123-5"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[2].linkId), force_bytes("2.1.1.3"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[2].text), force_bytes("Gender"))
        self.assertEqual(inst.item[2].item[6].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 56)
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[3].answer[0].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54141-7"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[3].answer[0].item[0].item[0].linkId), force_bytes("2.1.1.4.2.2"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[3].answer[0].item[0].item[0].text), force_bytes("Age"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[3].answer[0].item[0].linkId), force_bytes("2.1.1.4.2"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[3].answer[0].valueCoding.code), force_bytes("LA33-6"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[3].answer[0].valueCoding.display), force_bytes("Yes"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[3].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[3].definition), force_bytes("http://loinc.org/fhir/DataElement/54139-1"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[3].linkId), force_bytes("2.1.1.4"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[3].text), force_bytes("Living?"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[4].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[4].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[4].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[4].definition), force_bytes("http://loinc.org/fhir/DataElement/54121-9"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[4].linkId), force_bytes("2.1.1.5"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[4].text), force_bytes("Was this person born a twin?"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[5].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[5].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[5].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[5].definition), force_bytes("http://loinc.org/fhir/DataElement/54122-7"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[5].linkId), force_bytes("2.1.1.6"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].item[5].text), force_bytes("Was this person adopted?"))
        self.assertEqual(force_bytes(inst.item[2].item[6].item[0].linkId), force_bytes("2.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[6].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10421-8"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[0].answer[0].valueCoding.display), force_bytes("Paternal Aunt"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54136-7"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[0].linkId), force_bytes("2.1.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[0].text), force_bytes("Relationship to you"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[1].answer[0].valueString), force_bytes("Fiona"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54138-3"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[1].linkId), force_bytes("2.1.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[1].text), force_bytes("Name"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[2].answer[0].valueCoding.code), force_bytes("LA3-6"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[2].answer[0].valueCoding.display), force_bytes("Female"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[2].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/54123-5"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[2].linkId), force_bytes("2.1.1.3"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[2].text), force_bytes("Gender"))
        self.assertEqual(inst.item[2].item[7].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 57)
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[3].answer[0].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54141-7"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[3].answer[0].item[0].item[0].linkId), force_bytes("2.1.1.4.2.2"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[3].answer[0].item[0].item[0].text), force_bytes("Age"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[3].answer[0].item[0].linkId), force_bytes("2.1.1.4.2"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[3].answer[0].valueCoding.code), force_bytes("LA33-6"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[3].answer[0].valueCoding.display), force_bytes("Yes"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[3].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[3].definition), force_bytes("http://loinc.org/fhir/DataElement/54139-1"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[3].linkId), force_bytes("2.1.1.4"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[3].text), force_bytes("Living?"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[4].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[4].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[4].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[4].definition), force_bytes("http://loinc.org/fhir/DataElement/54121-9"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[4].linkId), force_bytes("2.1.1.5"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[4].text), force_bytes("Was this person born a twin?"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[5].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[5].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[5].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[5].definition), force_bytes("http://loinc.org/fhir/DataElement/54122-7"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[5].linkId), force_bytes("2.1.1.6"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].item[5].text), force_bytes("Was this person adopted?"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[0].linkId), force_bytes("2.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[1].item[0].answer[0].valueCoding.code), force_bytes("LA10543-9"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[1].item[0].answer[0].valueCoding.display), force_bytes("-- Skin Cancer"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[1].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[1].item[0].linkId), force_bytes("2.1.2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[1].item[0].text), force_bytes("Disease or Condition"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[1].linkId), force_bytes("2.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[7].item[1].text), force_bytes("This family member's history of disease"))
        self.assertEqual(force_bytes(inst.item[2].item[7].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10423-4"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[0].answer[0].valueCoding.display), force_bytes("Paternal Grandfather"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54136-7"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[0].linkId), force_bytes("2.1.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[0].text), force_bytes("Relationship to you"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[1].answer[0].valueString), force_bytes("Bob"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54138-3"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[1].linkId), force_bytes("2.1.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[1].text), force_bytes("Name"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[2].answer[0].valueCoding.code), force_bytes("LA2-8"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[2].answer[0].valueCoding.display), force_bytes("Male"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[2].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/54123-5"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[2].linkId), force_bytes("2.1.1.3"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[2].text), force_bytes("Gender"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10537-1"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.display), force_bytes("-- Colon Cancer"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54112-8"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].linkId), force_bytes("2.1.1.4.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].text), force_bytes("Cause of Death"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.code), force_bytes("LA10400-2"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.display), force_bytes("OVER 60"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54113-6"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].linkId), force_bytes("2.1.1.4.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].text), force_bytes("Age at Death"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].item[0].linkId), force_bytes("2.1.1.4.1"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].definition), force_bytes("http://loinc.org/fhir/DataElement/54139-1"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].linkId), force_bytes("2.1.1.4"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[3].text), force_bytes("Living?"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[4].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[4].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[4].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[4].definition), force_bytes("http://loinc.org/fhir/DataElement/54121-9"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[4].linkId), force_bytes("2.1.1.5"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[4].text), force_bytes("Was this person born a twin?"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[5].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[5].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[5].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[5].definition), force_bytes("http://loinc.org/fhir/DataElement/54122-7"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[5].linkId), force_bytes("2.1.1.6"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].item[5].text), force_bytes("Was this person adopted?"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[0].linkId), force_bytes("2.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].item[0].answer[0].valueCoding.code), force_bytes("LA10537-1"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].item[0].answer[0].valueCoding.display), force_bytes("-- Colon Cancer"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].item[0].linkId), force_bytes("2.1.2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].item[0].text), force_bytes("Disease or Condition"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].item[1].answer[0].valueCoding.code), force_bytes("LA10400-2"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].item[1].answer[0].valueCoding.display), force_bytes("OVER 60"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].item[1].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].item[1].linkId), force_bytes("2.1.2.2"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].item[1].text), force_bytes("Age at Diagnosis"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].linkId), force_bytes("2.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[8].item[1].text), force_bytes("This family member's history of disease"))
        self.assertEqual(force_bytes(inst.item[2].item[8].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10424-2"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[0].answer[0].valueCoding.display), force_bytes("Paternal Grandmother"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54136-7"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[0].linkId), force_bytes("2.1.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[0].text), force_bytes("Relationship to you"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[1].answer[0].valueString), force_bytes("Claire"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54138-3"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[1].linkId), force_bytes("2.1.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[1].text), force_bytes("Name"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[2].answer[0].valueCoding.code), force_bytes("LA3-6"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[2].answer[0].valueCoding.display), force_bytes("Female"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[2].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[2].definition), force_bytes("http://loinc.org/fhir/DataElement/54123-5"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[2].linkId), force_bytes("2.1.1.3"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[2].text), force_bytes("Gender"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].item[0].answer[0].valueString), force_bytes("Lou Gehrigs"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].item[0].linkId), force_bytes("2.1.1.4.1.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].item[0].text), force_bytes("Please specify"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.code), force_bytes("LA10589-2"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.display), force_bytes("-- Other/Unexpected"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].definition), force_bytes("http://loinc.org/fhir/DataElement/54112-8"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].linkId), force_bytes("2.1.1.4.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].text), force_bytes("Cause of Death"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.code), force_bytes("LA10400-2"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.display), force_bytes("OVER 60"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].definition), force_bytes("http://loinc.org/fhir/DataElement/54113-6"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].linkId), force_bytes("2.1.1.4.1.2"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].text), force_bytes("Age at Death"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].item[0].linkId), force_bytes("2.1.1.4.1"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].definition), force_bytes("http://loinc.org/fhir/DataElement/54139-1"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].linkId), force_bytes("2.1.1.4"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[3].text), force_bytes("Living?"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[4].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[4].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[4].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[4].definition), force_bytes("http://loinc.org/fhir/DataElement/54121-9"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[4].linkId), force_bytes("2.1.1.5"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[4].text), force_bytes("Was this person born a twin?"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[5].answer[0].valueCoding.code), force_bytes("LA32-8"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[5].answer[0].valueCoding.display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[5].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[5].definition), force_bytes("http://loinc.org/fhir/DataElement/54122-7"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[5].linkId), force_bytes("2.1.1.6"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].item[5].text), force_bytes("Was this person adopted?"))
        self.assertEqual(force_bytes(inst.item[2].item[9].item[0].linkId), force_bytes("2.1.1"))
        self.assertEqual(force_bytes(inst.item[2].item[9].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[2].linkId), force_bytes("2"))
        self.assertEqual(force_bytes(inst.item[2].text), force_bytes("Family member health information"))
        self.assertEqual(force_bytes(inst.meta.tag[0].code), force_bytes("HTEST"))
        self.assertEqual(force_bytes(inst.meta.tag[0].display), force_bytes("test health data"))
        self.assertEqual(force_bytes(inst.meta.tag[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActReason"))
        self.assertEqual(force_bytes(inst.questionnaire), force_bytes("Questionnaire/ussg-fht"))
        self.assertEqual(force_bytes(inst.status), force_bytes("in-progress"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testQuestionnaireResponse4(self):
        inst = self.instantiate_from("questionnaireresponse-example-gcs.json")
        self.assertIsNotNone(inst, "Must have instantiated a QuestionnaireResponse instance")
        self.implQuestionnaireResponse4(inst)
        
        js = inst.as_json()
        self.assertEqual("QuestionnaireResponse", js["resourceType"])
        inst2 = questionnaireresponse.QuestionnaireResponse(js)
        self.implQuestionnaireResponse4(inst2)
    
    def implQuestionnaireResponse4(self, inst):
        self.assertEqual(inst.authored.date, FHIRDate("2014-12-11T04:44:16Z").date)
        self.assertEqual(inst.authored.as_json(), "2014-12-11T04:44:16Z")
        self.assertEqual(force_bytes(inst.id), force_bytes("gcs"))
        self.assertEqual(force_bytes(inst.item[0].answer[0].valueCoding.code), force_bytes("LA6560-2"))
        self.assertEqual(force_bytes(inst.item[0].answer[0].valueCoding.display), force_bytes("Confused"))
        self.assertEqual(force_bytes(inst.item[0].answer[0].valueCoding.extension[0].url), force_bytes("http://hl7.org/fhir/StructureDefinition/ordinalValue"))
        self.assertEqual(inst.item[0].answer[0].valueCoding.extension[0].valueDecimal, 4)
        self.assertEqual(force_bytes(inst.item[0].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[0].linkId), force_bytes("1.1"))
        self.assertEqual(force_bytes(inst.item[1].answer[0].valueCoding.code), force_bytes("LA6566-9"))
        self.assertEqual(force_bytes(inst.item[1].answer[0].valueCoding.display), force_bytes("Localizing pain"))
        self.assertEqual(force_bytes(inst.item[1].answer[0].valueCoding.extension[0].url), force_bytes("http://hl7.org/fhir/StructureDefinition/ordinalValue"))
        self.assertEqual(inst.item[1].answer[0].valueCoding.extension[0].valueDecimal, 5)
        self.assertEqual(force_bytes(inst.item[1].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[1].linkId), force_bytes("1.2"))
        self.assertEqual(force_bytes(inst.item[2].answer[0].valueCoding.code), force_bytes("LA6556-0"))
        self.assertEqual(force_bytes(inst.item[2].answer[0].valueCoding.display), force_bytes("Eyes open spontaneously"))
        self.assertEqual(force_bytes(inst.item[2].answer[0].valueCoding.extension[0].url), force_bytes("http://hl7.org/fhir/StructureDefinition/ordinalValue"))
        self.assertEqual(inst.item[2].answer[0].valueCoding.extension[0].valueDecimal, 4)
        self.assertEqual(force_bytes(inst.item[2].answer[0].valueCoding.system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].linkId), force_bytes("1.3"))
        self.assertEqual(force_bytes(inst.meta.tag[0].code), force_bytes("HTEST"))
        self.assertEqual(force_bytes(inst.meta.tag[0].display), force_bytes("test health data"))
        self.assertEqual(force_bytes(inst.meta.tag[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActReason"))
        self.assertEqual(force_bytes(inst.questionnaire), force_bytes("Questionnaire/gcs"))
        self.assertEqual(force_bytes(inst.status), force_bytes("completed"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testQuestionnaireResponse5(self):
        inst = self.instantiate_from("questionnaireresponse-example-bluebook.json")
        self.assertIsNotNone(inst, "Must have instantiated a QuestionnaireResponse instance")
        self.implQuestionnaireResponse5(inst)
        
        js = inst.as_json()
        self.assertEqual("QuestionnaireResponse", js["resourceType"])
        inst2 = questionnaireresponse.QuestionnaireResponse(js)
        self.implQuestionnaireResponse5(inst2)
    
    def implQuestionnaireResponse5(self, inst):
        self.assertEqual(inst.authored.date, FHIRDate("2013-02-19T14:15:00+10:00").date)
        self.assertEqual(inst.authored.as_json(), "2013-02-19T14:15:00+10:00")
        self.assertEqual(force_bytes(inst.id), force_bytes("bb"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].answer[0].valueString), force_bytes("Cathy Jones"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].linkId), force_bytes("nameOfChild"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].text), force_bytes("Name of child"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[1].answer[0].valueCoding.code), force_bytes("f"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[1].linkId), force_bytes("sex"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[1].text), force_bytes("Sex"))
        self.assertEqual(force_bytes(inst.item[0].item[0].linkId), force_bytes("group"))
        self.assertEqual(inst.item[0].item[1].item[0].answer[0].valueDecimal, 3.25)
        self.assertEqual(force_bytes(inst.item[0].item[1].item[0].linkId), force_bytes("birthWeight"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[0].text), force_bytes("Birth weight (kg)"))
        self.assertEqual(inst.item[0].item[1].item[1].answer[0].valueDecimal, 44.3)
        self.assertEqual(force_bytes(inst.item[0].item[1].item[1].linkId), force_bytes("birthLength"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[1].text), force_bytes("Birth length (cm)"))
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[0].answer[0].valueDate.date, FHIRDate("1972-11-30").date)
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[0].answer[0].valueDate.as_json(), "1972-11-30")
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].answer[0].item[0].item[0].linkId), force_bytes("vitaminKDose1"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].answer[0].item[0].item[0].text), force_bytes("1st dose"))
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[1].answer[0].valueDate.date, FHIRDate("1972-12-11").date)
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[1].answer[0].valueDate.as_json(), "1972-12-11")
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].answer[0].item[0].item[1].linkId), force_bytes("vitaminKDose2"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].answer[0].item[0].item[1].text), force_bytes("2nd dose"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].answer[0].item[0].linkId), force_bytes("vitaminKgivenDoses"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].answer[0].valueCoding.code), force_bytes("INJECTION"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].linkId), force_bytes("vitaminKgiven"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].text), force_bytes("Vitamin K given"))
        self.assertEqual(inst.item[0].item[1].item[3].answer[0].item[0].answer[0].valueDate.date, FHIRDate("1972-12-04").date)
        self.assertEqual(inst.item[0].item[1].item[3].answer[0].item[0].answer[0].valueDate.as_json(), "1972-12-04")
        self.assertEqual(force_bytes(inst.item[0].item[1].item[3].answer[0].item[0].linkId), force_bytes("hepBgivenDate"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[3].answer[0].item[0].text), force_bytes("Date given"))
        self.assertTrue(inst.item[0].item[1].item[3].answer[0].valueBoolean)
        self.assertEqual(force_bytes(inst.item[0].item[1].item[3].linkId), force_bytes("hepBgiven"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[3].text), force_bytes("Hep B given y / n"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[4].answer[0].valueString), force_bytes("Already able to speak Chinese"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[4].linkId), force_bytes("abnormalitiesAtBirth"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[4].text), force_bytes("Abnormalities noted at birth"))
        self.assertEqual(force_bytes(inst.item[0].item[1].linkId), force_bytes("neonatalInformation"))
        self.assertEqual(force_bytes(inst.item[0].item[1].text), force_bytes("Neonatal Information"))
        self.assertEqual(force_bytes(inst.item[0].linkId), force_bytes("birthDetails"))
        self.assertEqual(force_bytes(inst.item[0].text), force_bytes("Birth details - To be completed by health professional"))
        self.assertEqual(force_bytes(inst.meta.tag[0].code), force_bytes("HTEST"))
        self.assertEqual(force_bytes(inst.meta.tag[0].display), force_bytes("test health data"))
        self.assertEqual(force_bytes(inst.meta.tag[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActReason"))
        self.assertEqual(force_bytes(inst.status), force_bytes("completed"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))

