#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 4.0.0-a53ec6ee1b on 2019-05-13.
#  2019, SMART Health IT.

import os
import pytest
import io
import unittest
import json

from .fixtures import force_bytes
from .. import questionnaire
from ..fhirdate import FHIRDate


@pytest.mark.usefixtures("base_settings")
class QuestionnaireTests(unittest.TestCase):
    def instantiate_from(self, filename):
        datadir = os.environ.get('FHIR_UNITTEST_DATADIR') or ''
        with io.open(os.path.join(datadir, filename), 'r', encoding='utf-8') as handle:
            js = json.load(handle)
            self.assertEqual("Questionnaire", js["resourceType"])
        return questionnaire.Questionnaire(js)
    
    def testQuestionnaire1(self):
        inst = self.instantiate_from("questionnaire-example-gcs.json")
        self.assertIsNotNone(inst, "Must have instantiated a Questionnaire instance")
        self.implQuestionnaire1(inst)
        
        js = inst.as_json()
        self.assertEqual("Questionnaire", js["resourceType"])
        inst2 = questionnaire.Questionnaire(js)
        self.implQuestionnaire1(inst2)
    
    def implQuestionnaire1(self, inst):
        self.assertEqual(force_bytes(inst.code[0].code), force_bytes("9269-2"))
        self.assertEqual(force_bytes(inst.code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.contained[0].id), force_bytes("motor"))
        self.assertEqual(force_bytes(inst.contained[1].id), force_bytes("verbal"))
        self.assertEqual(force_bytes(inst.contained[2].id), force_bytes("eye"))
        self.assertEqual(inst.date.date, FHIRDate("2015-08-03").date)
        self.assertEqual(inst.date.as_json(), "2015-08-03")
        self.assertEqual(force_bytes(inst.id), force_bytes("gcs"))
        self.assertEqual(force_bytes(inst.item[0].answerValueSet), force_bytes("#verbal"))
        self.assertEqual(force_bytes(inst.item[0].code[0].code), force_bytes("9270-0"))
        self.assertEqual(force_bytes(inst.item[0].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[0].linkId), force_bytes("1.1"))
        self.assertEqual(force_bytes(inst.item[0].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[1].answerValueSet), force_bytes("#motor"))
        self.assertEqual(force_bytes(inst.item[1].code[0].code), force_bytes("9268-4"))
        self.assertEqual(force_bytes(inst.item[1].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[1].linkId), force_bytes("1.2"))
        self.assertEqual(force_bytes(inst.item[1].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[2].answerValueSet), force_bytes("#eye"))
        self.assertEqual(force_bytes(inst.item[2].code[0].code), force_bytes("9267-6"))
        self.assertEqual(force_bytes(inst.item[2].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].linkId), force_bytes("1.3"))
        self.assertEqual(force_bytes(inst.item[2].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("FHIR Project team"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.subjectType[0]), force_bytes("Patient"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.title), force_bytes("Glasgow Coma Score"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/Questionnaire/gcs"))
    
    def testQuestionnaire2(self):
        inst = self.instantiate_from("questionnaire-cqf-example.json")
        self.assertIsNotNone(inst, "Must have instantiated a Questionnaire instance")
        self.implQuestionnaire2(inst)
        
        js = inst.as_json()
        self.assertEqual("Questionnaire", js["resourceType"])
        inst2 = questionnaire.Questionnaire(js)
        self.implQuestionnaire2(inst2)
    
    def implQuestionnaire2(self, inst):
        self.assertEqual(force_bytes(inst.code[0].code), force_bytes("44249-1"))
        self.assertEqual(force_bytes(inst.code[0].display), force_bytes("PHQ-9 quick depression assessment panel:-:Pt:^Patient:-:Report.PHQ-9"))
        self.assertEqual(force_bytes(inst.code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.extension[0].url), force_bytes("http://hl7.org/fhir/StructureDefinition/cqf-library"))
        self.assertEqual(force_bytes(inst.extension[0].valueCanonical), force_bytes("Library/phq-9-logic"))
        self.assertEqual(force_bytes(inst.id), force_bytes("phq-9-questionnaire"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("phq-9"))
        self.assertEqual(force_bytes(inst.item[0].answerValueSet), force_bytes("http://loinc.org/vs/LL358-3"))
        self.assertEqual(force_bytes(inst.item[0].code[0].code), force_bytes("44250-9"))
        self.assertEqual(force_bytes(inst.item[0].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[0].linkId), force_bytes("LittleInterest"))
        self.assertTrue(inst.item[0].required)
        self.assertEqual(force_bytes(inst.item[0].text), force_bytes("Little interest or pleasure in doing things"))
        self.assertEqual(force_bytes(inst.item[0].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[1].answerValueSet), force_bytes("http://loinc.org/vs/LL358-3"))
        self.assertEqual(force_bytes(inst.item[1].code[0].code), force_bytes("44255-8"))
        self.assertEqual(force_bytes(inst.item[1].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[1].linkId), force_bytes("FeelingDown"))
        self.assertTrue(inst.item[1].required)
        self.assertEqual(force_bytes(inst.item[1].text), force_bytes("Feeling down, depressed, or hopeless"))
        self.assertEqual(force_bytes(inst.item[1].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[2].answerValueSet), force_bytes("http://loinc.org/vs/LL358-3"))
        self.assertEqual(force_bytes(inst.item[2].code[0].code), force_bytes("44259-0"))
        self.assertEqual(force_bytes(inst.item[2].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[2].linkId), force_bytes("TroubleSleeping"))
        self.assertTrue(inst.item[2].required)
        self.assertEqual(force_bytes(inst.item[2].text), force_bytes("Trouble falling or staying asleep"))
        self.assertEqual(force_bytes(inst.item[2].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[3].answerValueSet), force_bytes("http://loinc.org/vs/LL358-3"))
        self.assertEqual(force_bytes(inst.item[3].code[0].code), force_bytes("44254-1"))
        self.assertEqual(force_bytes(inst.item[3].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[3].linkId), force_bytes("FeelingTired"))
        self.assertTrue(inst.item[3].required)
        self.assertEqual(force_bytes(inst.item[3].text), force_bytes("Feeling tired or having little energy"))
        self.assertEqual(force_bytes(inst.item[3].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[4].answerValueSet), force_bytes("http://loinc.org/vs/LL358-3"))
        self.assertEqual(force_bytes(inst.item[4].code[0].code), force_bytes("44251-7"))
        self.assertEqual(force_bytes(inst.item[4].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[4].linkId), force_bytes("BadAppetite"))
        self.assertTrue(inst.item[4].required)
        self.assertEqual(force_bytes(inst.item[4].text), force_bytes("Poor appetite or overeating"))
        self.assertEqual(force_bytes(inst.item[4].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[5].answerValueSet), force_bytes("http://loinc.org/vs/LL358-3"))
        self.assertEqual(force_bytes(inst.item[5].code[0].code), force_bytes("44258-2"))
        self.assertEqual(force_bytes(inst.item[5].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[5].linkId), force_bytes("FeelingBadAboutSelf"))
        self.assertTrue(inst.item[5].required)
        self.assertEqual(force_bytes(inst.item[5].text), force_bytes("Feeling bad about yourself - or that you are a failure or have let yourself or your family down"))
        self.assertEqual(force_bytes(inst.item[5].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[6].answerValueSet), force_bytes("http://loinc.org/vs/LL358-3"))
        self.assertEqual(force_bytes(inst.item[6].code[0].code), force_bytes("44252-5"))
        self.assertEqual(force_bytes(inst.item[6].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[6].linkId), force_bytes("TroubleConcentrating"))
        self.assertTrue(inst.item[6].required)
        self.assertEqual(force_bytes(inst.item[6].text), force_bytes("Trouble concentrating on things, such as reading the newspaper or watching television"))
        self.assertEqual(force_bytes(inst.item[6].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[7].answerValueSet), force_bytes("http://loinc.org/vs/LL358-3"))
        self.assertEqual(force_bytes(inst.item[7].code[0].code), force_bytes("44253-3"))
        self.assertEqual(force_bytes(inst.item[7].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[7].linkId), force_bytes("MovingSpeaking"))
        self.assertTrue(inst.item[7].required)
        self.assertEqual(force_bytes(inst.item[7].text), force_bytes("Moving or speaking so slowly that other people could have noticed. Or the opposite - being so fidgety or restless that you have been moving around a lot more than usual"))
        self.assertEqual(force_bytes(inst.item[7].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[8].code[0].code), force_bytes("44261-6"))
        self.assertEqual(force_bytes(inst.item[8].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[8].extension[0].url), force_bytes("http://hl7.org/fhir/StructureDefinition/cqf-expression"))
        self.assertEqual(force_bytes(inst.item[8].extension[0].valueExpression.expression), force_bytes("CalculateTotalScore"))
        self.assertEqual(force_bytes(inst.item[8].extension[0].valueExpression.language), force_bytes("text/cql"))
        self.assertEqual(force_bytes(inst.item[8].linkId), force_bytes("TotalScore"))
        self.assertTrue(inst.item[8].required)
        self.assertEqual(force_bytes(inst.item[8].text), force_bytes("Total score"))
        self.assertEqual(force_bytes(inst.item[8].type), force_bytes("integer"))
        self.assertEqual(force_bytes(inst.item[9].answerValueSet), force_bytes("http://loinc.org/vs/LL358-3"))
        self.assertEqual(force_bytes(inst.item[9].code[0].code), force_bytes("44256-6"))
        self.assertEqual(force_bytes(inst.item[9].code[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.item[9].linkId), force_bytes("Difficulty"))
        self.assertTrue(inst.item[9].required)
        self.assertEqual(force_bytes(inst.item[9].text), force_bytes("If you checked off any problems, how difficult have these problems made it for you to do your work, take care of things at home, or get along with other people"))
        self.assertEqual(force_bytes(inst.item[9].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.meta.profile[0]), force_bytes("http://hl7.org/fhir/StructureDefinition/cqf-questionnaire"))
        self.assertEqual(force_bytes(inst.meta.tag[0].code), force_bytes("HTEST"))
        self.assertEqual(force_bytes(inst.meta.tag[0].display), force_bytes("test health data"))
        self.assertEqual(force_bytes(inst.meta.tag[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActReason"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.subjectType[0]), force_bytes("Patient"))
        self.assertEqual(force_bytes(inst.text.div), force_bytes("<div xmlns=\"http://www.w3.org/1999/xhtml\">PHQ-9 Questionnaire with dynamic logic</div>"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.title), force_bytes("Patient Health Questionnaire (PHQ-9)"))
        self.assertEqual(force_bytes(inst.version), force_bytes("1.0.0"))
    
    def testQuestionnaire3(self):
        inst = self.instantiate_from("questionnaire-example-f201-lifelines.json")
        self.assertIsNotNone(inst, "Must have instantiated a Questionnaire instance")
        self.implQuestionnaire3(inst)
        
        js = inst.as_json()
        self.assertEqual("Questionnaire", js["resourceType"])
        inst2 = questionnaire.Questionnaire(js)
        self.implQuestionnaire3(inst2)
    
    def implQuestionnaire3(self, inst):
        self.assertEqual(force_bytes(inst.code[0].code), force_bytes("VL 1-1, 18-65_1.2.2"))
        self.assertEqual(force_bytes(inst.code[0].display), force_bytes("Lifelines Questionnaire 1 part 1"))
        self.assertEqual(force_bytes(inst.code[0].system), force_bytes("http://example.org/system/code/lifelines/nl"))
        self.assertEqual(inst.date.date, FHIRDate("2010").date)
        self.assertEqual(inst.date.as_json(), "2010")
        self.assertEqual(force_bytes(inst.id), force_bytes("f201"))
        self.assertEqual(force_bytes(inst.item[0].linkId), force_bytes("1"))
        self.assertEqual(force_bytes(inst.item[0].text), force_bytes("Do you have allergies?"))
        self.assertEqual(force_bytes(inst.item[0].type), force_bytes("boolean"))
        self.assertEqual(force_bytes(inst.item[1].item[0].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[1].item[0].text), force_bytes("What is your gender?"))
        self.assertEqual(force_bytes(inst.item[1].item[0].type), force_bytes("string"))
        self.assertEqual(force_bytes(inst.item[1].item[1].linkId), force_bytes("2.2"))
        self.assertEqual(force_bytes(inst.item[1].item[1].text), force_bytes("What is your date of birth?"))
        self.assertEqual(force_bytes(inst.item[1].item[1].type), force_bytes("date"))
        self.assertEqual(force_bytes(inst.item[1].item[2].linkId), force_bytes("2.3"))
        self.assertEqual(force_bytes(inst.item[1].item[2].text), force_bytes("What is your country of birth?"))
        self.assertEqual(force_bytes(inst.item[1].item[2].type), force_bytes("string"))
        self.assertEqual(force_bytes(inst.item[1].item[3].linkId), force_bytes("2.4"))
        self.assertEqual(force_bytes(inst.item[1].item[3].text), force_bytes("What is your marital status?"))
        self.assertEqual(force_bytes(inst.item[1].item[3].type), force_bytes("string"))
        self.assertEqual(force_bytes(inst.item[1].linkId), force_bytes("2"))
        self.assertEqual(force_bytes(inst.item[1].text), force_bytes("General questions"))
        self.assertEqual(force_bytes(inst.item[1].type), force_bytes("group"))
        self.assertEqual(force_bytes(inst.item[2].item[0].linkId), force_bytes("3.1"))
        self.assertEqual(force_bytes(inst.item[2].item[0].text), force_bytes("Do you smoke?"))
        self.assertEqual(force_bytes(inst.item[2].item[0].type), force_bytes("boolean"))
        self.assertEqual(force_bytes(inst.item[2].item[1].linkId), force_bytes("3.2"))
        self.assertEqual(force_bytes(inst.item[2].item[1].text), force_bytes("Do you drink alchohol?"))
        self.assertEqual(force_bytes(inst.item[2].item[1].type), force_bytes("boolean"))
        self.assertEqual(force_bytes(inst.item[2].linkId), force_bytes("3"))
        self.assertEqual(force_bytes(inst.item[2].text), force_bytes("Intoxications"))
        self.assertEqual(force_bytes(inst.item[2].type), force_bytes("group"))
        self.assertEqual(force_bytes(inst.status), force_bytes("active"))
        self.assertEqual(force_bytes(inst.subjectType[0]), force_bytes("Patient"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/Questionnaire/f201"))
    
    def testQuestionnaire4(self):
        inst = self.instantiate_from("questionnaire-example.json")
        self.assertIsNotNone(inst, "Must have instantiated a Questionnaire instance")
        self.implQuestionnaire4(inst)
        
        js = inst.as_json()
        self.assertEqual("Questionnaire", js["resourceType"])
        inst2 = questionnaire.Questionnaire(js)
        self.implQuestionnaire4(inst2)
    
    def implQuestionnaire4(self, inst):
        self.assertEqual(inst.date.date, FHIRDate("2012-01").date)
        self.assertEqual(inst.date.as_json(), "2012-01")
        self.assertEqual(force_bytes(inst.id), force_bytes("3141"))
        self.assertEqual(force_bytes(inst.item[0].code[0].code), force_bytes("COMORBIDITY"))
        self.assertEqual(force_bytes(inst.item[0].code[0].system), force_bytes("http://example.org/system/code/sections"))
        self.assertEqual(force_bytes(inst.item[0].item[0].answerValueSet), force_bytes("http://hl7.org/fhir/ValueSet/yesnodontknow"))
        self.assertEqual(force_bytes(inst.item[0].item[0].code[0].code), force_bytes("COMORB"))
        self.assertEqual(force_bytes(inst.item[0].item[0].code[0].system), force_bytes("http://example.org/system/code/questions"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].code[0].code), force_bytes("CARDIAL"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].code[0].system), force_bytes("http://example.org/system/code/sections"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].enableWhen[0].answerCoding.code), force_bytes("Y"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].enableWhen[0].answerCoding.system), force_bytes("http://terminology.hl7.org/CodeSystem/v2-0136"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].enableWhen[0].operator), force_bytes("="))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].enableWhen[0].question), force_bytes("1.1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].answerValueSet), force_bytes("http://hl7.org/fhir/ValueSet/yesnodontknow"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].code[0].code), force_bytes("COMORBCAR"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].code[0].system), force_bytes("http://example.org/system/code/questions"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[0].answerValueSet), force_bytes("http://hl7.org/fhir/ValueSet/yesnodontknow"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[0].code[0].code), force_bytes("COMCAR00"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[0].code[0].display), force_bytes("Angina Pectoris"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[0].code[0].system), force_bytes("http://example.org/system/code/questions"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[0].code[1].code), force_bytes("194828000"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[0].code[1].display), force_bytes("Angina (disorder)"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[0].code[1].system), force_bytes("http://snomed.info/sct"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[0].linkId), force_bytes("1.1.1.1.1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[0].prefix), force_bytes("1.1.1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[0].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[1].answerValueSet), force_bytes("http://hl7.org/fhir/ValueSet/yesnodontknow"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[1].code[0].code), force_bytes("22298006"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[1].code[0].display), force_bytes("Myocardial infarction (disorder)"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[1].code[0].system), force_bytes("http://snomed.info/sct"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[1].linkId), force_bytes("1.1.1.1.2"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[1].prefix), force_bytes("1.1.2"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].item[1].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].linkId), force_bytes("1.1.1.1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].prefix), force_bytes("1.1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[0].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[1].answerValueSet), force_bytes("http://hl7.org/fhir/ValueSet/yesnodontknow"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[1].code[0].code), force_bytes("COMORBVAS"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[1].code[0].system), force_bytes("http://example.org/system/code/questions"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[1].linkId), force_bytes("1.1.1.2"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[1].prefix), force_bytes("1.2"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].item[1].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].linkId), force_bytes("1.1.1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].type), force_bytes("group"))
        self.assertEqual(force_bytes(inst.item[0].item[0].linkId), force_bytes("1.1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].prefix), force_bytes("1"))
        self.assertEqual(force_bytes(inst.item[0].item[0].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[0].linkId), force_bytes("1"))
        self.assertEqual(force_bytes(inst.item[0].type), force_bytes("group"))
        self.assertEqual(force_bytes(inst.item[1].code[0].code), force_bytes("HISTOPATHOLOGY"))
        self.assertEqual(force_bytes(inst.item[1].code[0].system), force_bytes("http://example.org/system/code/sections"))
        self.assertEqual(force_bytes(inst.item[1].item[0].code[0].code), force_bytes("ABDOMINAL"))
        self.assertEqual(force_bytes(inst.item[1].item[0].code[0].system), force_bytes("http://example.org/system/code/sections"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[0].code[0].code), force_bytes("STADPT"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[0].code[0].display), force_bytes("pT category"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[0].code[0].system), force_bytes("http://example.org/system/code/questions"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[0].linkId), force_bytes("2.1.2"))
        self.assertEqual(force_bytes(inst.item[1].item[0].item[0].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[1].item[0].linkId), force_bytes("2.1"))
        self.assertEqual(force_bytes(inst.item[1].item[0].type), force_bytes("group"))
        self.assertEqual(force_bytes(inst.item[1].linkId), force_bytes("2"))
        self.assertEqual(force_bytes(inst.item[1].type), force_bytes("group"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.subjectType[0]), force_bytes("Patient"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.title), force_bytes("Cancer Quality Forum Questionnaire 2012"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/Questionnaire/3141"))
    
    def testQuestionnaire5(self):
        inst = self.instantiate_from("questionnaire-example-bluebook.json")
        self.assertIsNotNone(inst, "Must have instantiated a Questionnaire instance")
        self.implQuestionnaire5(inst)
        
        js = inst.as_json()
        self.assertEqual("Questionnaire", js["resourceType"])
        inst2 = questionnaire.Questionnaire(js)
        self.implQuestionnaire5(inst2)
    
    def implQuestionnaire5(self, inst):
        self.assertEqual(inst.date.date, FHIRDate("2013-02-19").date)
        self.assertEqual(inst.date.as_json(), "2013-02-19")
        self.assertEqual(force_bytes(inst.id), force_bytes("bb"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].linkId), force_bytes("nameOfChild"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].text), force_bytes("Name of child"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[0].type), force_bytes("string"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[1].answerOption[0].valueCoding.code), force_bytes("F"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[1].answerOption[1].valueCoding.code), force_bytes("M"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[1].linkId), force_bytes("sex"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[1].text), force_bytes("Sex"))
        self.assertEqual(force_bytes(inst.item[0].item[0].item[1].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[0].item[0].linkId), force_bytes("group"))
        self.assertEqual(force_bytes(inst.item[0].item[0].type), force_bytes("group"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[0].linkId), force_bytes("birthWeight"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[0].text), force_bytes("Birth weight (kg)"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[0].type), force_bytes("decimal"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[1].linkId), force_bytes("birthLength"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[1].text), force_bytes("Birth length (cm)"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[1].type), force_bytes("decimal"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].answerOption[0].valueCoding.code), force_bytes("INJECTION"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].answerOption[1].valueCoding.code), force_bytes("INTRAVENOUS"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].answerOption[2].valueCoding.code), force_bytes("ORAL"))
        self.assertTrue(inst.item[0].item[1].item[2].item[0].enableWhen[0].answerBoolean)
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].item[0].enableWhen[0].operator), force_bytes("exists"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].item[0].enableWhen[0].question), force_bytes("vitaminKgiven"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].item[0].item[0].linkId), force_bytes("vitaminiKDose1"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].item[0].item[0].text), force_bytes("1st dose"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].item[0].item[0].type), force_bytes("dateTime"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].item[0].item[1].linkId), force_bytes("vitaminiKDose2"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].item[0].item[1].text), force_bytes("2nd dose"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].item[0].item[1].type), force_bytes("dateTime"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].item[0].linkId), force_bytes("vitaminKgivenDoses"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].item[0].type), force_bytes("group"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].linkId), force_bytes("vitaminKgiven"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].text), force_bytes("Vitamin K given"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[2].type), force_bytes("choice"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[3].item[0].linkId), force_bytes("hepBgivenDate"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[3].item[0].text), force_bytes("Date given"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[3].item[0].type), force_bytes("date"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[3].linkId), force_bytes("hepBgiven"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[3].text), force_bytes("Hep B given y / n"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[3].type), force_bytes("boolean"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[4].linkId), force_bytes("abnormalitiesAtBirth"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[4].text), force_bytes("Abnormalities noted at birth"))
        self.assertEqual(force_bytes(inst.item[0].item[1].item[4].type), force_bytes("string"))
        self.assertEqual(force_bytes(inst.item[0].item[1].linkId), force_bytes("neonatalInformation"))
        self.assertEqual(force_bytes(inst.item[0].item[1].text), force_bytes("Neonatal Information"))
        self.assertEqual(force_bytes(inst.item[0].item[1].type), force_bytes("group"))
        self.assertEqual(force_bytes(inst.item[0].linkId), force_bytes("birthDetails"))
        self.assertEqual(force_bytes(inst.item[0].text), force_bytes("Birth details - To be completed by health professional"))
        self.assertEqual(force_bytes(inst.item[0].type), force_bytes("group"))
        self.assertEqual(force_bytes(inst.jurisdiction[0].coding[0].code), force_bytes("AU"))
        self.assertEqual(force_bytes(inst.jurisdiction[0].coding[0].system), force_bytes("urn:iso:std:iso:3166"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("New South Wales Department of Health"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.subjectType[0]), force_bytes("Patient"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.title), force_bytes("NSW Government My Personal Health Record"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/Questionnaire/bb"))

