#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 4.0.0-a53ec6ee1b on 2019-05-13.
#  2019, SMART Health IT.

import os
import pytest
import io
import unittest
import json

from .fixtures import force_bytes
from .. import capabilitystatement
from ..fhirdate import FHIRDate


@pytest.mark.usefixtures("base_settings")
class CapabilityStatementTests(unittest.TestCase):
    def instantiate_from(self, filename):
        datadir = os.environ.get('FHIR_UNITTEST_DATADIR') or ''
        with io.open(os.path.join(datadir, filename), 'r', encoding='utf-8') as handle:
            js = json.load(handle)
            self.assertEqual("CapabilityStatement", js["resourceType"])
        return capabilitystatement.CapabilityStatement(js)
    
    def testCapabilityStatement1(self):
        inst = self.instantiate_from("capabilitystatement-phr-example.json")
        self.assertIsNotNone(inst, "Must have instantiated a CapabilityStatement instance")
        self.implCapabilityStatement1(inst)
        
        js = inst.as_json()
        self.assertEqual("CapabilityStatement", js["resourceType"])
        inst2 = capabilitystatement.CapabilityStatement(js)
        self.implCapabilityStatement1(inst2)
    
    def implCapabilityStatement1(self, inst):
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(inst.date.date, FHIRDate("2013-06-18").date)
        self.assertEqual(inst.date.as_json(), "2013-06-18")
        self.assertEqual(force_bytes(inst.description), force_bytes("Prototype Capability Statement for September 2013 Connectathon"))
        self.assertEqual(force_bytes(inst.fhirVersion), force_bytes("4.0.0"))
        self.assertEqual(force_bytes(inst.format[0]), force_bytes("json"))
        self.assertEqual(force_bytes(inst.format[1]), force_bytes("xml"))
        self.assertEqual(force_bytes(inst.id), force_bytes("phr"))
        self.assertEqual(force_bytes(inst.kind), force_bytes("capability"))
        self.assertEqual(force_bytes(inst.meta.tag[0].code), force_bytes("HTEST"))
        self.assertEqual(force_bytes(inst.meta.tag[0].display), force_bytes("test health data"))
        self.assertEqual(force_bytes(inst.meta.tag[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/v3-ActReason"))
        self.assertEqual(force_bytes(inst.name), force_bytes("PHR Template"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("FHIR Project"))
        self.assertEqual(force_bytes(inst.rest[0].documentation), force_bytes("Protoype server Capability Statement for September 2013 Connectathon"))
        self.assertEqual(force_bytes(inst.rest[0].mode), force_bytes("server"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].interaction[0].code), force_bytes("read"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].interaction[1].code), force_bytes("search-type"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].interaction[1].documentation), force_bytes("When a client searches patients with no search criteria, they get a list of all patients they have access too. Servers may elect to offer additional search parameters, but this is not required"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].type), force_bytes("Patient"))
        self.assertEqual(force_bytes(inst.rest[0].resource[1].interaction[0].code), force_bytes("read"))
        self.assertEqual(force_bytes(inst.rest[0].resource[1].interaction[1].code), force_bytes("search-type"))
        self.assertEqual(force_bytes(inst.rest[0].resource[1].searchParam[0].documentation), force_bytes("_id parameter always supported. For the connectathon, servers may elect which search parameters are supported"))
        self.assertEqual(force_bytes(inst.rest[0].resource[1].searchParam[0].name), force_bytes("_id"))
        self.assertEqual(force_bytes(inst.rest[0].resource[1].searchParam[0].type), force_bytes("token"))
        self.assertEqual(force_bytes(inst.rest[0].resource[1].type), force_bytes("DocumentReference"))
        self.assertEqual(force_bytes(inst.rest[0].resource[2].interaction[0].code), force_bytes("read"))
        self.assertEqual(force_bytes(inst.rest[0].resource[2].interaction[1].code), force_bytes("search-type"))
        self.assertEqual(force_bytes(inst.rest[0].resource[2].searchParam[0].documentation), force_bytes("Standard _id parameter"))
        self.assertEqual(force_bytes(inst.rest[0].resource[2].searchParam[0].name), force_bytes("_id"))
        self.assertEqual(force_bytes(inst.rest[0].resource[2].searchParam[0].type), force_bytes("token"))
        self.assertEqual(force_bytes(inst.rest[0].resource[2].type), force_bytes("Condition"))
        self.assertEqual(force_bytes(inst.rest[0].resource[3].interaction[0].code), force_bytes("read"))
        self.assertEqual(force_bytes(inst.rest[0].resource[3].interaction[1].code), force_bytes("search-type"))
        self.assertEqual(force_bytes(inst.rest[0].resource[3].searchParam[0].documentation), force_bytes("Standard _id parameter"))
        self.assertEqual(force_bytes(inst.rest[0].resource[3].searchParam[0].name), force_bytes("_id"))
        self.assertEqual(force_bytes(inst.rest[0].resource[3].searchParam[0].type), force_bytes("token"))
        self.assertEqual(force_bytes(inst.rest[0].resource[3].searchParam[1].documentation), force_bytes("which diagnostic discipline/department created the report"))
        self.assertEqual(force_bytes(inst.rest[0].resource[3].searchParam[1].name), force_bytes("service"))
        self.assertEqual(force_bytes(inst.rest[0].resource[3].searchParam[1].type), force_bytes("token"))
        self.assertEqual(force_bytes(inst.rest[0].resource[3].type), force_bytes("DiagnosticReport"))
        self.assertEqual(force_bytes(inst.rest[0].security.service[0].text), force_bytes("OAuth"))
        self.assertEqual(force_bytes(inst.software.name), force_bytes("ACME PHR Server"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testCapabilityStatement2(self):
        inst = self.instantiate_from("capabilitystatement-example.json")
        self.assertIsNotNone(inst, "Must have instantiated a CapabilityStatement instance")
        self.implCapabilityStatement2(inst)
        
        js = inst.as_json()
        self.assertEqual("CapabilityStatement", js["resourceType"])
        inst2 = capabilitystatement.CapabilityStatement(js)
        self.implCapabilityStatement2(inst2)
    
    def implCapabilityStatement2(self, inst):
        self.assertEqual(force_bytes(inst.contact[0].name), force_bytes("System Administrator"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("email"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("wile@acme.org"))
        self.assertEqual(force_bytes(inst.copyright), force_bytes("Copyright © Acme Healthcare and GoodCorp EHR Systems"))
        self.assertEqual(inst.date.date, FHIRDate("2012-01-04").date)
        self.assertEqual(inst.date.as_json(), "2012-01-04")
        self.assertEqual(force_bytes(inst.description), force_bytes("This is the FHIR capability statement for the main EHR at ACME for the private interface - it does not describe the public interface"))
        self.assertEqual(force_bytes(inst.document[0].documentation), force_bytes("Basic rules for all documents in the EHR system"))
        self.assertEqual(force_bytes(inst.document[0].mode), force_bytes("consumer"))
        self.assertEqual(force_bytes(inst.document[0].profile), force_bytes("http://fhir.hl7.org/base/Profilebc054d23-75e1-4dc6-aca5-838b6b1ac81d/_history/b5fdd9fc-b021-4ea1-911a-721a60663796"))
        self.assertTrue(inst.experimental)
        self.assertEqual(force_bytes(inst.fhirVersion), force_bytes("4.0.0"))
        self.assertEqual(force_bytes(inst.format[0]), force_bytes("xml"))
        self.assertEqual(force_bytes(inst.format[1]), force_bytes("json"))
        self.assertEqual(force_bytes(inst.id), force_bytes("example"))
        self.assertEqual(force_bytes(inst.implementation.description), force_bytes("main EHR at ACME"))
        self.assertEqual(force_bytes(inst.implementation.url), force_bytes("http://10.2.3.4/fhir"))
        self.assertEqual(force_bytes(inst.implementationGuide[0]), force_bytes("http://hl7.org/fhir/us/lab"))
        self.assertEqual(force_bytes(inst.instantiates[0]), force_bytes("http://ihe.org/fhir/CapabilityStatement/pixm-client"))
        self.assertEqual(force_bytes(inst.jurisdiction[0].coding[0].code), force_bytes("US"))
        self.assertEqual(force_bytes(inst.jurisdiction[0].coding[0].display), force_bytes("United States of America (the)"))
        self.assertEqual(force_bytes(inst.jurisdiction[0].coding[0].system), force_bytes("urn:iso:std:iso:3166"))
        self.assertEqual(force_bytes(inst.kind), force_bytes("instance"))
        self.assertEqual(force_bytes(inst.messaging[0].documentation), force_bytes("ADT A08 equivalent for external system notifications"))
        self.assertEqual(force_bytes(inst.messaging[0].endpoint[0].address), force_bytes("mllp:10.1.1.10:9234"))
        self.assertEqual(force_bytes(inst.messaging[0].endpoint[0].protocol.code), force_bytes("mllp"))
        self.assertEqual(force_bytes(inst.messaging[0].endpoint[0].protocol.system), force_bytes("http://terminology.hl7.org/CodeSystem/message-transport"))
        self.assertEqual(inst.messaging[0].reliableCache, 30)
        self.assertEqual(force_bytes(inst.messaging[0].supportedMessage[0].definition), force_bytes("MessageDefinition/example"))
        self.assertEqual(force_bytes(inst.messaging[0].supportedMessage[0].mode), force_bytes("receiver"))
        self.assertEqual(force_bytes(inst.name), force_bytes("ACME-EHR"))
        self.assertEqual(force_bytes(inst.patchFormat[0]), force_bytes("application/xml-patch+xml"))
        self.assertEqual(force_bytes(inst.patchFormat[1]), force_bytes("application/json-patch+json"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("ACME Corporation"))
        self.assertEqual(force_bytes(inst.purpose), force_bytes("Main EHR capability statement, published for contracting and operational support"))
        self.assertEqual(force_bytes(inst.rest[0].compartment[0]), force_bytes("http://hl7.org/fhir/CompartmentDefinition/patient"))
        self.assertEqual(force_bytes(inst.rest[0].documentation), force_bytes("Main FHIR endpoint for acem health"))
        self.assertEqual(force_bytes(inst.rest[0].interaction[0].code), force_bytes("transaction"))
        self.assertEqual(force_bytes(inst.rest[0].interaction[1].code), force_bytes("history-system"))
        self.assertEqual(force_bytes(inst.rest[0].mode), force_bytes("server"))
        self.assertTrue(inst.rest[0].resource[0].conditionalCreate)
        self.assertEqual(force_bytes(inst.rest[0].resource[0].conditionalDelete), force_bytes("not-supported"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].conditionalRead), force_bytes("full-support"))
        self.assertFalse(inst.rest[0].resource[0].conditionalUpdate)
        self.assertEqual(force_bytes(inst.rest[0].resource[0].documentation), force_bytes("This server does not let the clients create identities."))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].interaction[0].code), force_bytes("read"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].interaction[1].code), force_bytes("vread"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].interaction[1].documentation), force_bytes("Only supported for patient records since 12-Dec 2012"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].interaction[2].code), force_bytes("update"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].interaction[3].code), force_bytes("history-instance"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].interaction[4].code), force_bytes("create"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].interaction[5].code), force_bytes("history-type"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].profile), force_bytes("http://registry.fhir.org/r4/StructureDefinition/7896271d-57f6-4231-89dc-dcc91eab2416"))
        self.assertTrue(inst.rest[0].resource[0].readHistory)
        self.assertEqual(force_bytes(inst.rest[0].resource[0].searchInclude[0]), force_bytes("Organization"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].searchParam[0].definition), force_bytes("http://hl7.org/fhir/SearchParameter/Patient-identifier"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].searchParam[0].documentation), force_bytes("Only supports search by institution MRN"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].searchParam[0].name), force_bytes("identifier"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].searchParam[0].type), force_bytes("token"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].searchParam[1].definition), force_bytes("http://hl7.org/fhir/SearchParameter/Patient-general-practitioner"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].searchParam[1].name), force_bytes("general-practitioner"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].searchParam[1].type), force_bytes("reference"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].searchRevInclude[0]), force_bytes("Person"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].supportedProfile[0]), force_bytes("http://registry.fhir.org/r4/StructureDefinition/00ab9e7a-06c7-4f77-9234-4154ca1e3347"))
        self.assertEqual(force_bytes(inst.rest[0].resource[0].type), force_bytes("Patient"))
        self.assertFalse(inst.rest[0].resource[0].updateCreate)
        self.assertEqual(force_bytes(inst.rest[0].resource[0].versioning), force_bytes("versioned-update"))
        self.assertTrue(inst.rest[0].security.cors)
        self.assertEqual(force_bytes(inst.rest[0].security.description), force_bytes("See Smart on FHIR documentation"))
        self.assertEqual(force_bytes(inst.rest[0].security.service[0].coding[0].code), force_bytes("SMART-on-FHIR"))
        self.assertEqual(force_bytes(inst.rest[0].security.service[0].coding[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/restful-security-service"))
        self.assertEqual(force_bytes(inst.software.name), force_bytes("EHR"))
        self.assertEqual(inst.software.releaseDate.date, FHIRDate("2012-01-04").date)
        self.assertEqual(inst.software.releaseDate.as_json(), "2012-01-04")
        self.assertEqual(force_bytes(inst.software.version), force_bytes("0.00.020.2134"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.title), force_bytes("ACME EHR capability statement"))
        self.assertEqual(force_bytes(inst.url), force_bytes("urn:uuid:68D043B5-9ECF-4559-A57A-396E0D452311"))
        self.assertEqual(force_bytes(inst.useContext[0].code.code), force_bytes("focus"))
        self.assertEqual(force_bytes(inst.useContext[0].code.system), force_bytes("http://terminology.hl7.org/CodeSystem/usage-context-type"))
        self.assertEqual(force_bytes(inst.useContext[0].valueCodeableConcept.coding[0].code), force_bytes("positive"))
        self.assertEqual(force_bytes(inst.useContext[0].valueCodeableConcept.coding[0].system), force_bytes("http://terminology.hl7.org/CodeSystem/variant-state"))
        self.assertEqual(force_bytes(inst.version), force_bytes("20130510"))

