#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 4.0.0-a53ec6ee1b (http://hl7.org/fhir/StructureDefinition/Narrative) on 2019-05-13.
#  2019, SMART Health IT.


from . import element

class Narrative(element.Element):
    """ Human-readable summary of the resource (essential clinical and business
    information).

    A human-readable summary of the resource conveying the essential clinical
    and business information for the resource.
    """

    resource_type = "Narrative"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.div = None
        """ Limited xhtml content.
        Type `str`. """

        self.status = None
        """ generated | extensions | additional | empty.
        Type `str`. """

        super(Narrative, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(Narrative, self).elementProperties()
        js.extend([
            ("div", "div", str, "xhtml", False, None, True),
            ("status", "status", str, "code", False, None, True),
        ])
        return js


