#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 3.0.1.11917 on 2019-05-13.
#  2019, SMART Health IT.

import os
import pytest
import io
import unittest
import json

from .fixtures import force_bytes
from .. import valueset
from ..fhirdate import FHIRDate


@pytest.mark.usefixtures("base_settings")
class ValueSetTests(unittest.TestCase):
    def instantiate_from(self, filename):
        datadir = os.environ.get('FHIR_UNITTEST_DATADIR') or ''
        with io.open(os.path.join(datadir, filename), 'r', encoding='utf-8') as handle:
            js = json.load(handle)
            self.assertEqual("ValueSet", js["resourceType"])
        return valueset.ValueSet(js)
    
    def testValueSet1(self):
        inst = self.instantiate_from("valueset-example-expansion.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet1(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet1(inst2)
    
    def implValueSet1(self, inst):
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].op), force_bytes("="))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].property), force_bytes("parent"))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].value), force_bytes("LP43571-6"))
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(force_bytes(inst.copyright), force_bytes("This content from LOINC® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use."))
        self.assertEqual(inst.date.date, FHIRDate("2015-06-22").date)
        self.assertEqual(inst.date.as_json(), "2015-06-22")
        self.assertEqual(force_bytes(inst.description), force_bytes("This is an example value set that includes all the LOINC codes for serum/plasma cholesterol from v2.36."))
        self.assertEqual(force_bytes(inst.expansion.contains[0].code), force_bytes("14647-2"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].display), force_bytes("Cholesterol [Moles/volume] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].version), force_bytes("2.50"))
        self.assertTrue(inst.expansion.contains[1].abstract)
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].code), force_bytes("2093-3"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].display), force_bytes("Cholesterol [Mass/volume] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].code), force_bytes("48620-9"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].display), force_bytes("Cholesterol [Mass/volume] in Serum or Plasma ultracentrifugate"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[2].code), force_bytes("9342-7"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[2].display), force_bytes("Cholesterol [Percentile]"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[2].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[2].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].display), force_bytes("Cholesterol codes"))
        self.assertTrue(inst.expansion.contains[2].abstract)
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[0].code), force_bytes("2096-6"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[0].display), force_bytes("Cholesterol/Triglyceride [Mass Ratio] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[0].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[1].code), force_bytes("35200-5"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[1].display), force_bytes("Cholesterol/Triglyceride [Mass Ratio] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[1].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[1].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[2].code), force_bytes("48089-7"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[2].display), force_bytes("Cholesterol/Apolipoprotein B [Molar ratio] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[2].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[2].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[3].code), force_bytes("55838-7"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[3].display), force_bytes("Cholesterol/Phospholipid [Molar ratio] in Serum or Plasma"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[3].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].contains[3].version), force_bytes("2.50"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].display), force_bytes("Cholesterol Ratios"))
        self.assertEqual(force_bytes(inst.expansion.extension[0].url), force_bytes("http://hl7.org/fhir/StructureDefinition/valueset-expansionSource"))
        self.assertEqual(force_bytes(inst.expansion.extension[0].valueUri), force_bytes("http://hl7.org/fhir/ValueSet/example-extensional"))
        self.assertEqual(force_bytes(inst.expansion.identifier), force_bytes("urn:uuid:42316ff8-2714-4680-9980-f37a6d1a71bc"))
        self.assertEqual(inst.expansion.offset, 0)
        self.assertEqual(force_bytes(inst.expansion.parameter[0].name), force_bytes("version"))
        self.assertEqual(force_bytes(inst.expansion.parameter[0].valueString), force_bytes("2.50"))
        self.assertEqual(inst.expansion.timestamp.date, FHIRDate("2015-06-22T13:56:07Z").date)
        self.assertEqual(inst.expansion.timestamp.as_json(), "2015-06-22T13:56:07Z")
        self.assertEqual(inst.expansion.total, 8)
        self.assertTrue(inst.experimental)
        self.assertEqual(force_bytes(inst.id), force_bytes("example-expansion"))
        self.assertEqual(force_bytes(inst.meta.profile[0]), force_bytes("http://hl7.org/fhir/StructureDefinition/shareablevalueset"))
        self.assertEqual(force_bytes(inst.name), force_bytes("LOINC Codes for Cholesterol in Serum/Plasma"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("FHIR Project team"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/example-expansion"))
        self.assertEqual(force_bytes(inst.version), force_bytes("20150622"))
    
    def testValueSet2(self):
        inst = self.instantiate_from("valueset-example-yesnodontknow.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet2(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet2(inst2)
    
    def implValueSet2(self, inst):
        self.assertEqual(force_bytes(inst.compose.include[0].valueSet[0]), force_bytes("http://hl7.org/fhir/ValueSet/v2-0136"))
        self.assertEqual(force_bytes(inst.compose.include[1].concept[0].code), force_bytes("asked"))
        self.assertEqual(force_bytes(inst.compose.include[1].concept[0].display), force_bytes("Don't know"))
        self.assertEqual(force_bytes(inst.compose.include[1].system), force_bytes("http://hl7.org/fhir/data-absent-reason"))
        self.assertEqual(force_bytes(inst.description), force_bytes("For Capturing simple yes-no-don't know answers"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].code), force_bytes("Y"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].display), force_bytes("Yes"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].system), force_bytes("http://hl7.org/fhir/v2/0136"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].code), force_bytes("N"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].display), force_bytes("No"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].system), force_bytes("http://hl7.org/fhir/v2/0136"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].code), force_bytes("asked"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].display), force_bytes("Don't know"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].system), force_bytes("http://hl7.org/fhir/data-absent-reason"))
        self.assertEqual(force_bytes(inst.expansion.identifier), force_bytes("urn:uuid:bf99fe50-2c2b-41ad-bd63-bee6919810b4"))
        self.assertEqual(inst.expansion.timestamp.date, FHIRDate("2015-07-14T10:00:00Z").date)
        self.assertEqual(inst.expansion.timestamp.as_json(), "2015-07-14T10:00:00Z")
        self.assertEqual(force_bytes(inst.id), force_bytes("yesnodontknow"))
        self.assertEqual(force_bytes(inst.name), force_bytes("Yes/No/Don't Know"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/yesnodontknow"))
    
    def testValueSet3(self):
        inst = self.instantiate_from("valueset-example-intensional.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet3(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet3(inst2)
    
    def implValueSet3(self, inst):
        self.assertEqual(force_bytes(inst.compose.exclude[0].concept[0].code), force_bytes("5932-9"))
        self.assertEqual(force_bytes(inst.compose.exclude[0].concept[0].display), force_bytes("Cholesterol [Presence] in Blood by Test strip"))
        self.assertEqual(force_bytes(inst.compose.exclude[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].op), force_bytes("="))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].property), force_bytes("parent"))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].value), force_bytes("LP43571-6"))
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.contact[0].name), force_bytes("FHIR project team"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(force_bytes(inst.copyright), force_bytes("This content from LOINCÂ® is copyright Â© 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use"))
        self.assertEqual(inst.date.date, FHIRDate("2015-06-22").date)
        self.assertEqual(inst.date.as_json(), "2015-06-22")
        self.assertEqual(force_bytes(inst.description), force_bytes("This is an example value set that includes all the LOINC codes for serum/plasma cholesterol from v2.36."))
        self.assertTrue(inst.experimental)
        self.assertEqual(force_bytes(inst.id), force_bytes("example-intensional"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("http://acme.com/identifiers/valuesets"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("loinc-cholesterol-ext"))
        self.assertEqual(force_bytes(inst.meta.profile[0]), force_bytes("http://hl7.org/fhir/StructureDefinition/shareablevalueset"))
        self.assertEqual(force_bytes(inst.name), force_bytes("LOINC Codes for Cholesterol in Serum/Plasma"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("HL7 International"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/example-intensional"))
        self.assertEqual(force_bytes(inst.version), force_bytes("20150622"))
    
    def testValueSet4(self):
        inst = self.instantiate_from("valueset-list-example-codes.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet4(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet4(inst2)
    
    def implValueSet4(self, inst):
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://hl7.org/fhir/list-example-use-codes"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(inst.date.date, FHIRDate("2017-04-19T07:44:43+10:00").date)
        self.assertEqual(inst.date.as_json(), "2017-04-19T07:44:43+10:00")
        self.assertEqual(force_bytes(inst.description), force_bytes("Example use codes for the List resource - typical kinds of use."))
        self.assertTrue(inst.experimental)
        self.assertEqual(force_bytes(inst.extension[0].url), force_bytes("http://hl7.org/fhir/StructureDefinition/structuredefinition-ballot-status"))
        self.assertEqual(force_bytes(inst.extension[0].valueString), force_bytes("Informative"))
        self.assertEqual(force_bytes(inst.extension[1].url), force_bytes("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"))
        self.assertEqual(inst.extension[1].valueInteger, 1)
        self.assertEqual(force_bytes(inst.extension[2].url), force_bytes("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"))
        self.assertEqual(force_bytes(inst.extension[2].valueCode), force_bytes("fhir"))
        self.assertEqual(force_bytes(inst.id), force_bytes("list-example-codes"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:ietf:rfc:3986"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("urn:oid:2.16.840.1.113883.4.642.3.307"))
        self.assertTrue(inst.immutable)
        self.assertEqual(inst.meta.lastUpdated.date, FHIRDate("2017-04-19T07:44:43.294+10:00").date)
        self.assertEqual(inst.meta.lastUpdated.as_json(), "2017-04-19T07:44:43.294+10:00")
        self.assertEqual(force_bytes(inst.meta.profile[0]), force_bytes("http://hl7.org/fhir/StructureDefinition/shareablevalueset"))
        self.assertEqual(force_bytes(inst.name), force_bytes("Example Use Codes for List"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("FHIR Project"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/list-example-codes"))
        self.assertEqual(force_bytes(inst.version), force_bytes("3.0.1"))
    
    def testValueSet5(self):
        inst = self.instantiate_from("valueset-example.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet5(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet5(inst2)
    
    def implValueSet5(self, inst):
        self.assertTrue(inst.compose.inactive)
        self.assertEqual(force_bytes(inst.compose.include[0].concept[0].code), force_bytes("14647-2"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[0].display), force_bytes("Cholesterol [Moles/Volume]"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[1].code), force_bytes("2093-3"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[1].display), force_bytes("Cholesterol [Mass/Volume]"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[2].code), force_bytes("35200-5"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[2].display), force_bytes("Cholesterol [Mass Or Moles/Volume]"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[3].code), force_bytes("9342-7"))
        self.assertEqual(force_bytes(inst.compose.include[0].concept[3].display), force_bytes("Cholesterol [Percentile]"))
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://loinc.org"))
        self.assertEqual(force_bytes(inst.compose.include[0].version), force_bytes("2.36"))
        self.assertEqual(inst.compose.lockedDate.date, FHIRDate("2012-06-13").date)
        self.assertEqual(inst.compose.lockedDate.as_json(), "2012-06-13")
        self.assertEqual(force_bytes(inst.contact[0].name), force_bytes("FHIR project team"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("url"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("http://hl7.org/fhir"))
        self.assertEqual(force_bytes(inst.copyright), force_bytes("This content from LOINC ® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use."))
        self.assertEqual(inst.date.date, FHIRDate("2015-06-22").date)
        self.assertEqual(inst.date.as_json(), "2015-06-22")
        self.assertEqual(force_bytes(inst.description), force_bytes("This is an example value set that includes all the LOINC codes for serum/plasma cholesterol from v2.36."))
        self.assertTrue(inst.experimental)
        self.assertEqual(force_bytes(inst.id), force_bytes("example-extensional"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("http://acme.com/identifiers/valuesets"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("loinc-cholesterol-int"))
        self.assertEqual(force_bytes(inst.meta.profile[0]), force_bytes("http://hl7.org/fhir/StructureDefinition/shareablevalueset"))
        self.assertEqual(force_bytes(inst.name), force_bytes("LOINC Codes for Cholesterol in Serum/Plasma"))
        self.assertEqual(force_bytes(inst.publisher), force_bytes("HL7 International"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/example-extensional"))
        self.assertEqual(force_bytes(inst.version), force_bytes("20150622"))
    
    def testValueSet6(self):
        inst = self.instantiate_from("valueset-example-inactive.json")
        self.assertIsNotNone(inst, "Must have instantiated a ValueSet instance")
        self.implValueSet6(inst)
        
        js = inst.as_json()
        self.assertEqual("ValueSet", js["resourceType"])
        inst2 = valueset.ValueSet(js)
        self.implValueSet6(inst2)
    
    def implValueSet6(self, inst):
        self.assertTrue(inst.compose.inactive)
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].op), force_bytes("descendent-of"))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].property), force_bytes("concept"))
        self.assertEqual(force_bytes(inst.compose.include[0].filter[0].value), force_bytes("_ActMoodPredicate"))
        self.assertEqual(force_bytes(inst.compose.include[0].system), force_bytes("http://hl7.org/fhir/v3/ActMood"))
        self.assertEqual(force_bytes(inst.description), force_bytes("HL7 v3 ActMood Prdicate codes, including inactive codes"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].code), force_bytes("CRT"))
        self.assertEqual(force_bytes(inst.expansion.contains[0].display), force_bytes("criterion"))
        self.assertTrue(inst.expansion.contains[0].inactive)
        self.assertEqual(force_bytes(inst.expansion.contains[0].system), force_bytes("http://hl7.org/fhir/v3/ActMood"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].code), force_bytes("EXPEC"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].code), force_bytes("GOL"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].display), force_bytes("goal"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[0].system), force_bytes("http://hl7.org/fhir/v3/ActMood"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].code), force_bytes("RSK"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].display), force_bytes("risk"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].contains[1].system), force_bytes("http://hl7.org/fhir/v3/ActMood"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].display), force_bytes("expectation"))
        self.assertEqual(force_bytes(inst.expansion.contains[1].system), force_bytes("http://hl7.org/fhir/v3/ActMood"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].code), force_bytes("OPT"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].display), force_bytes("option"))
        self.assertEqual(force_bytes(inst.expansion.contains[2].system), force_bytes("http://hl7.org/fhir/v3/ActMood"))
        self.assertEqual(force_bytes(inst.expansion.identifier), force_bytes("urn:uuid:46c00b3f-003a-4f31-9d4b-ea2de58b2a99"))
        self.assertEqual(inst.expansion.timestamp.date, FHIRDate("2017-02-26T10:00:00Z").date)
        self.assertEqual(inst.expansion.timestamp.as_json(), "2017-02-26T10:00:00Z")
        self.assertEqual(force_bytes(inst.id), force_bytes("inactive"))
        self.assertEqual(force_bytes(inst.name), force_bytes("Example-inactive"))
        self.assertEqual(force_bytes(inst.status), force_bytes("draft"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
        self.assertEqual(force_bytes(inst.title), force_bytes("Example with inactive codes"))
        self.assertEqual(force_bytes(inst.url), force_bytes("http://hl7.org/fhir/ValueSet/inactive"))

