#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 3.0.1.11917 on 2019-05-13.
#  2019, SMART Health IT.

import os
import pytest
import io
import unittest
import json

from .fixtures import force_bytes
from .. import practitioner
from ..fhirdate import FHIRDate


@pytest.mark.usefixtures("base_settings")
class PractitionerTests(unittest.TestCase):
    def instantiate_from(self, filename):
        datadir = os.environ.get('FHIR_UNITTEST_DATADIR') or ''
        with io.open(os.path.join(datadir, filename), 'r', encoding='utf-8') as handle:
            js = json.load(handle)
            self.assertEqual("Practitioner", js["resourceType"])
        return practitioner.Practitioner(js)
    
    def testPractitioner1(self):
        inst = self.instantiate_from("practitioner-example-f203-jvg.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
        self.implPractitioner1(inst)
        
        js = inst.as_json()
        self.assertEqual("Practitioner", js["resourceType"])
        inst2 = practitioner.Practitioner(js)
        self.implPractitioner1(inst2)
    
    def implPractitioner1(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(force_bytes(inst.address[0].city), force_bytes("Den helder"))
        self.assertEqual(force_bytes(inst.address[0].country), force_bytes("NLD"))
        self.assertEqual(force_bytes(inst.address[0].line[0]), force_bytes("Walvisbaai 3"))
        self.assertEqual(force_bytes(inst.address[0].postalCode), force_bytes("2333ZA"))
        self.assertEqual(force_bytes(inst.address[0].use), force_bytes("work"))
        self.assertEqual(inst.birthDate.date, FHIRDate("1983-04-20").date)
        self.assertEqual(inst.birthDate.as_json(), "1983-04-20")
        self.assertEqual(force_bytes(inst.gender), force_bytes("male"))
        self.assertEqual(force_bytes(inst.id), force_bytes("f203"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:2.16.528.1.1007.3.1"))
        self.assertEqual(force_bytes(inst.identifier[0].type.text), force_bytes("UZI-nummer"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("12345678903"))
        self.assertEqual(force_bytes(inst.identifier[1].system), force_bytes("https://www.bigregister.nl/"))
        self.assertEqual(force_bytes(inst.identifier[1].type.text), force_bytes("BIG-nummer"))
        self.assertEqual(force_bytes(inst.identifier[1].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[1].value), force_bytes("12345678903"))
        self.assertEqual(force_bytes(inst.name[0].text), force_bytes("Juri van Gelder"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.telecom[0].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[0].value), force_bytes("+31715269111"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPractitioner2(self):
        inst = self.instantiate_from("practitioner-example-f003-mv.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
        self.implPractitioner2(inst)
        
        js = inst.as_json()
        self.assertEqual("Practitioner", js["resourceType"])
        inst2 = practitioner.Practitioner(js)
        self.implPractitioner2(inst2)
    
    def implPractitioner2(self, inst):
        self.assertEqual(force_bytes(inst.address[0].city), force_bytes("Amsterdam"))
        self.assertEqual(force_bytes(inst.address[0].country), force_bytes("NLD"))
        self.assertEqual(force_bytes(inst.address[0].line[0]), force_bytes("Galapagosweg 91"))
        self.assertEqual(force_bytes(inst.address[0].postalCode), force_bytes("1105 AZ"))
        self.assertEqual(force_bytes(inst.address[0].use), force_bytes("work"))
        self.assertEqual(inst.birthDate.date, FHIRDate("1963-07-01").date)
        self.assertEqual(inst.birthDate.as_json(), "1963-07-01")
        self.assertEqual(force_bytes(inst.communication[0].coding[0].code), force_bytes("nl"))
        self.assertEqual(force_bytes(inst.communication[0].coding[0].display), force_bytes("Dutch"))
        self.assertEqual(force_bytes(inst.communication[0].coding[0].system), force_bytes("urn:oid:2.16.840.1.113883.6.121"))
        self.assertEqual(force_bytes(inst.gender), force_bytes("male"))
        self.assertEqual(force_bytes(inst.id), force_bytes("f003"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:2.16.528.1.1007.3.1"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("846100293"))
        self.assertEqual(force_bytes(inst.identifier[1].system), force_bytes("urn:oid:2.16.840.1.113883.2.4.6.3"))
        self.assertEqual(force_bytes(inst.identifier[1].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.identifier[1].value), force_bytes("243HID3RT938"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Versteegh"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Marc"))
        self.assertEqual(force_bytes(inst.name[0].suffix[0]), force_bytes("MD"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.telecom[0].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[0].value), force_bytes("0205562431"))
        self.assertEqual(force_bytes(inst.telecom[1].system), force_bytes("email"))
        self.assertEqual(force_bytes(inst.telecom[1].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[1].value), force_bytes("m.versteegh@bmc.nl"))
        self.assertEqual(force_bytes(inst.telecom[2].system), force_bytes("fax"))
        self.assertEqual(force_bytes(inst.telecom[2].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[2].value), force_bytes("0205662948"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPractitioner3(self):
        inst = self.instantiate_from("practitioner-example-xcda1.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
        self.implPractitioner3(inst)
        
        js = inst.as_json()
        self.assertEqual("Practitioner", js["resourceType"])
        inst2 = practitioner.Practitioner(js)
        self.implPractitioner3(inst2)
    
    def implPractitioner3(self, inst):
        self.assertEqual(force_bytes(inst.id), force_bytes("xcda1"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("http://healthcare.example.org/identifiers/staff"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("D234123"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Dopplemeyer"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Sherry"))
        self.assertEqual(force_bytes(inst.telecom[0].system), force_bytes("email"))
        self.assertEqual(force_bytes(inst.telecom[0].value), force_bytes("john.doe@healthcare.example.org"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPractitioner4(self):
        inst = self.instantiate_from("practitioner-example-f204-ce.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
        self.implPractitioner4(inst)
        
        js = inst.as_json()
        self.assertEqual("Practitioner", js["resourceType"])
        inst2 = practitioner.Practitioner(js)
        self.implPractitioner4(inst2)
    
    def implPractitioner4(self, inst):
        self.assertEqual(force_bytes(inst.address[0].city), force_bytes("Den helder"))
        self.assertEqual(force_bytes(inst.address[0].country), force_bytes("NLD"))
        self.assertEqual(force_bytes(inst.address[0].line[0]), force_bytes("Walvisbaai 3"))
        self.assertEqual(force_bytes(inst.address[0].postalCode), force_bytes("2333ZA"))
        self.assertEqual(force_bytes(inst.address[0].use), force_bytes("work"))
        self.assertEqual(inst.birthDate.date, FHIRDate("1967-11-05").date)
        self.assertEqual(inst.birthDate.as_json(), "1967-11-05")
        self.assertEqual(force_bytes(inst.gender), force_bytes("female"))
        self.assertEqual(force_bytes(inst.id), force_bytes("f204"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:2.16.528.1.1007.3.1"))
        self.assertEqual(force_bytes(inst.identifier[0].type.text), force_bytes("UZI-nummer"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("12345678904"))
        self.assertEqual(force_bytes(inst.name[0].text), force_bytes("Carla Espinosa"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.telecom[0].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[0].value), force_bytes("+31715262169"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPractitioner5(self):
        inst = self.instantiate_from("practitioner-example-f004-rb.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
        self.implPractitioner5(inst)
        
        js = inst.as_json()
        self.assertEqual("Practitioner", js["resourceType"])
        inst2 = practitioner.Practitioner(js)
        self.implPractitioner5(inst2)
    
    def implPractitioner5(self, inst):
        self.assertEqual(force_bytes(inst.address[0].city), force_bytes("Amsterdam"))
        self.assertEqual(force_bytes(inst.address[0].country), force_bytes("NLD"))
        self.assertEqual(force_bytes(inst.address[0].line[0]), force_bytes("Galapagosweg 91"))
        self.assertEqual(force_bytes(inst.address[0].postalCode), force_bytes("1105 AZ"))
        self.assertEqual(force_bytes(inst.address[0].use), force_bytes("work"))
        self.assertEqual(inst.birthDate.date, FHIRDate("1980-02-04").date)
        self.assertEqual(inst.birthDate.as_json(), "1980-02-04")
        self.assertEqual(force_bytes(inst.communication[0].coding[0].code), force_bytes("nl"))
        self.assertEqual(force_bytes(inst.communication[0].coding[0].display), force_bytes("Netherlands"))
        self.assertEqual(force_bytes(inst.communication[0].coding[0].system), force_bytes("urn:oid:2.16.840.1.113883.6.121"))
        self.assertEqual(force_bytes(inst.communication[0].text), force_bytes("Language"))
        self.assertEqual(force_bytes(inst.gender), force_bytes("male"))
        self.assertEqual(force_bytes(inst.id), force_bytes("f004"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:2.16.528.1.1007.3.1"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("118265112"))
        self.assertEqual(force_bytes(inst.identifier[1].system), force_bytes("urn:oid:2.16.840.1.113883.2.4.6.3"))
        self.assertEqual(force_bytes(inst.identifier[1].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.identifier[1].value), force_bytes("523ASA1LK927"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Briet"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Ronald"))
        self.assertEqual(force_bytes(inst.name[0].suffix[0]), force_bytes("MD"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.telecom[0].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[0].value), force_bytes("0205569273"))
        self.assertEqual(force_bytes(inst.telecom[1].system), force_bytes("email"))
        self.assertEqual(force_bytes(inst.telecom[1].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[1].value), force_bytes("r.briet@bmc.nl"))
        self.assertEqual(force_bytes(inst.telecom[2].system), force_bytes("fax"))
        self.assertEqual(force_bytes(inst.telecom[2].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[2].value), force_bytes("0205664440"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPractitioner6(self):
        inst = self.instantiate_from("practitioner-example-xcda-author.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
        self.implPractitioner6(inst)
        
        js = inst.as_json()
        self.assertEqual("Practitioner", js["resourceType"])
        inst2 = practitioner.Practitioner(js)
        self.implPractitioner6(inst2)
    
    def implPractitioner6(self, inst):
        self.assertEqual(force_bytes(inst.id), force_bytes("xcda-author"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Hippocrates"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Harold"))
        self.assertEqual(force_bytes(inst.name[0].suffix[0]), force_bytes("MD"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPractitioner7(self):
        inst = self.instantiate_from("practitioner-example-f001-evdb.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
        self.implPractitioner7(inst)
        
        js = inst.as_json()
        self.assertEqual("Practitioner", js["resourceType"])
        inst2 = practitioner.Practitioner(js)
        self.implPractitioner7(inst2)
    
    def implPractitioner7(self, inst):
        self.assertEqual(force_bytes(inst.address[0].city), force_bytes("Den Burg"))
        self.assertEqual(force_bytes(inst.address[0].country), force_bytes("NLD"))
        self.assertEqual(force_bytes(inst.address[0].line[0]), force_bytes("Galapagosweg 91"))
        self.assertEqual(force_bytes(inst.address[0].postalCode), force_bytes("9105 PZ"))
        self.assertEqual(force_bytes(inst.address[0].use), force_bytes("work"))
        self.assertEqual(inst.birthDate.date, FHIRDate("1975-12-07").date)
        self.assertEqual(inst.birthDate.as_json(), "1975-12-07")
        self.assertEqual(force_bytes(inst.gender), force_bytes("male"))
        self.assertEqual(force_bytes(inst.id), force_bytes("f001"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:2.16.528.1.1007.3.1"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("938273695"))
        self.assertEqual(force_bytes(inst.identifier[1].system), force_bytes("urn:oid:2.16.840.1.113883.2.4.6.3"))
        self.assertEqual(force_bytes(inst.identifier[1].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.identifier[1].value), force_bytes("129IDH4OP733"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("van den broek"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Eric"))
        self.assertEqual(force_bytes(inst.name[0].suffix[0]), force_bytes("MD"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.telecom[0].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[0].value), force_bytes("0205568263"))
        self.assertEqual(force_bytes(inst.telecom[1].system), force_bytes("email"))
        self.assertEqual(force_bytes(inst.telecom[1].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[1].value), force_bytes("E.M.vandenbroek@bmc.nl"))
        self.assertEqual(force_bytes(inst.telecom[2].system), force_bytes("fax"))
        self.assertEqual(force_bytes(inst.telecom[2].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[2].value), force_bytes("0205664440"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPractitioner8(self):
        inst = self.instantiate_from("practitioner-example-f202-lm.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
        self.implPractitioner8(inst)
        
        js = inst.as_json()
        self.assertEqual("Practitioner", js["resourceType"])
        inst2 = practitioner.Practitioner(js)
        self.implPractitioner8(inst2)
    
    def implPractitioner8(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(force_bytes(inst.address[0].city), force_bytes("Den helder"))
        self.assertEqual(force_bytes(inst.address[0].country), force_bytes("NLD"))
        self.assertEqual(force_bytes(inst.address[0].line[0]), force_bytes("Walvisbaai 3"))
        self.assertEqual(force_bytes(inst.address[0].line[1]), force_bytes("C4 - Automatisering"))
        self.assertEqual(force_bytes(inst.address[0].postalCode), force_bytes("2333ZA"))
        self.assertEqual(force_bytes(inst.address[0].use), force_bytes("work"))
        self.assertEqual(inst.birthDate.date, FHIRDate("1960-06-12").date)
        self.assertEqual(inst.birthDate.as_json(), "1960-06-12")
        self.assertEqual(force_bytes(inst.gender), force_bytes("male"))
        self.assertEqual(force_bytes(inst.id), force_bytes("f202"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:2.16.528.1.1007.3.1"))
        self.assertEqual(force_bytes(inst.identifier[0].type.text), force_bytes("UZI-nummer"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("12345678902"))
        self.assertEqual(force_bytes(inst.identifier[1].system), force_bytes("https://www.bigregister.nl/"))
        self.assertEqual(force_bytes(inst.identifier[1].type.text), force_bytes("BIG-nummer"))
        self.assertEqual(force_bytes(inst.identifier[1].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[1].value), force_bytes("12345678902"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Maas"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Luigi"))
        self.assertEqual(force_bytes(inst.name[0].prefix[0]), force_bytes("Dr."))
        self.assertEqual(force_bytes(inst.name[0].text), force_bytes("Luigi Maas"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.telecom[0].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[0].value), force_bytes("+31715269111"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPractitioner9(self):
        inst = self.instantiate_from("practitioner-example-f005-al.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
        self.implPractitioner9(inst)
        
        js = inst.as_json()
        self.assertEqual("Practitioner", js["resourceType"])
        inst2 = practitioner.Practitioner(js)
        self.implPractitioner9(inst2)
    
    def implPractitioner9(self, inst):
        self.assertEqual(force_bytes(inst.address[0].city), force_bytes("Amsterdam"))
        self.assertEqual(force_bytes(inst.address[0].country), force_bytes("NLD"))
        self.assertEqual(force_bytes(inst.address[0].line[0]), force_bytes("Galapagosweg 9"))
        self.assertEqual(force_bytes(inst.address[0].postalCode), force_bytes("1105 AZ"))
        self.assertEqual(force_bytes(inst.address[0].use), force_bytes("work"))
        self.assertEqual(inst.birthDate.date, FHIRDate("1959-03-11").date)
        self.assertEqual(inst.birthDate.as_json(), "1959-03-11")
        self.assertEqual(force_bytes(inst.communication[0].coding[0].code), force_bytes("fr"))
        self.assertEqual(force_bytes(inst.communication[0].coding[0].display), force_bytes("France"))
        self.assertEqual(force_bytes(inst.communication[0].coding[0].system), force_bytes("urn:oid:2.16.840.1.113883.6.121"))
        self.assertEqual(force_bytes(inst.gender), force_bytes("female"))
        self.assertEqual(force_bytes(inst.id), force_bytes("f005"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:2.16.528.1.1007.3.1"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("118265112"))
        self.assertEqual(force_bytes(inst.identifier[1].system), force_bytes("urn:oid:2.16.840.1.113883.2.4.6.3"))
        self.assertEqual(force_bytes(inst.identifier[1].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.identifier[1].value), force_bytes("191REW8WE916"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Anne"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Langeveld"))
        self.assertEqual(force_bytes(inst.name[0].suffix[0]), force_bytes("MD"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.photo[0].contentType), force_bytes("image/jpeg"))
        self.assertEqual(force_bytes(inst.telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.telecom[0].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[0].value), force_bytes("0205563847"))
        self.assertEqual(force_bytes(inst.telecom[1].system), force_bytes("email"))
        self.assertEqual(force_bytes(inst.telecom[1].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[1].value), force_bytes("a.langeveld@bmc.nl"))
        self.assertEqual(force_bytes(inst.telecom[2].system), force_bytes("fax"))
        self.assertEqual(force_bytes(inst.telecom[2].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[2].value), force_bytes("0205668916"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPractitioner10(self):
        inst = self.instantiate_from("practitioner-example-f201-ab.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
        self.implPractitioner10(inst)
        
        js = inst.as_json()
        self.assertEqual("Practitioner", js["resourceType"])
        inst2 = practitioner.Practitioner(js)
        self.implPractitioner10(inst2)
    
    def implPractitioner10(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(force_bytes(inst.address[0].city), force_bytes("Den helder"))
        self.assertEqual(force_bytes(inst.address[0].country), force_bytes("NLD"))
        self.assertEqual(force_bytes(inst.address[0].line[0]), force_bytes("Walvisbaai 3"))
        self.assertEqual(force_bytes(inst.address[0].line[1]), force_bytes("C4 - Automatisering"))
        self.assertEqual(force_bytes(inst.address[0].postalCode), force_bytes("2333ZA"))
        self.assertEqual(force_bytes(inst.address[0].use), force_bytes("work"))
        self.assertEqual(inst.birthDate.date, FHIRDate("1956-12-24").date)
        self.assertEqual(inst.birthDate.as_json(), "1956-12-24")
        self.assertEqual(force_bytes(inst.gender), force_bytes("male"))
        self.assertEqual(force_bytes(inst.id), force_bytes("f201"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:2.16.528.1.1007.3.1"))
        self.assertEqual(force_bytes(inst.identifier[0].type.text), force_bytes("UZI-nummer"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("12345678901"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Bronsig"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Arend"))
        self.assertEqual(force_bytes(inst.name[0].prefix[0]), force_bytes("Dr."))
        self.assertEqual(force_bytes(inst.name[0].text), force_bytes("Dokter Bronsig"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.qualification[0].code.coding[0].code), force_bytes("41672002"))
        self.assertEqual(force_bytes(inst.qualification[0].code.coding[0].display), force_bytes("Pulmonologist"))
        self.assertEqual(force_bytes(inst.qualification[0].code.coding[0].system), force_bytes("http://snomed.info/sct"))
        self.assertEqual(force_bytes(inst.telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.telecom[0].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.telecom[0].value), force_bytes("+31715269111"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))

