#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 3.0.1.11917 on 2019-05-13.
#  2019, SMART Health IT.

import os
import pytest
import io
import unittest
import json

from .fixtures import force_bytes
from .. import patient
from ..fhirdate import FHIRDate


@pytest.mark.usefixtures("base_settings")
class PatientTests(unittest.TestCase):
    def instantiate_from(self, filename):
        datadir = os.environ.get('FHIR_UNITTEST_DATADIR') or ''
        with io.open(os.path.join(datadir, filename), 'r', encoding='utf-8') as handle:
            js = json.load(handle)
            self.assertEqual("Patient", js["resourceType"])
        return patient.Patient(js)
    
    def testPatient1(self):
        inst = self.instantiate_from("patient-example-ihe-pcd.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
        self.implPatient1(inst)
        
        js = inst.as_json()
        self.assertEqual("Patient", js["resourceType"])
        inst2 = patient.Patient(js)
        self.implPatient1(inst2)
    
    def implPatient1(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(force_bytes(inst.id), force_bytes("ihe-pcd"))
        self.assertEqual(force_bytes(inst.identifier[0].type.text), force_bytes("Internal Identifier"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("AB60001"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("BROOKS"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("ALBERT"))
        self.assertEqual(force_bytes(inst.text.div), force_bytes("<div xmlns=\"http://www.w3.org/1999/xhtml\">Albert Brooks, Id: AB60001</div>"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPatient2(self):
        inst = self.instantiate_from("patient-example-f001-pieter.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
        self.implPatient2(inst)
        
        js = inst.as_json()
        self.assertEqual("Patient", js["resourceType"])
        inst2 = patient.Patient(js)
        self.implPatient2(inst2)
    
    def implPatient2(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(force_bytes(inst.address[0].city), force_bytes("Amsterdam"))
        self.assertEqual(force_bytes(inst.address[0].country), force_bytes("NLD"))
        self.assertEqual(force_bytes(inst.address[0].line[0]), force_bytes("Van Egmondkade 23"))
        self.assertEqual(force_bytes(inst.address[0].postalCode), force_bytes("1024 RJ"))
        self.assertEqual(force_bytes(inst.address[0].use), force_bytes("home"))
        self.assertEqual(inst.birthDate.date, FHIRDate("1944-11-17").date)
        self.assertEqual(inst.birthDate.as_json(), "1944-11-17")
        self.assertEqual(force_bytes(inst.communication[0].language.coding[0].code), force_bytes("nl"))
        self.assertEqual(force_bytes(inst.communication[0].language.coding[0].display), force_bytes("Dutch"))
        self.assertEqual(force_bytes(inst.communication[0].language.coding[0].system), force_bytes("urn:ietf:bcp:47"))
        self.assertEqual(force_bytes(inst.communication[0].language.text), force_bytes("Nederlands"))
        self.assertTrue(inst.communication[0].preferred)
        self.assertEqual(force_bytes(inst.contact[0].name.family), force_bytes("Abels"))
        self.assertEqual(force_bytes(inst.contact[0].name.given[0]), force_bytes("Sarah"))
        self.assertEqual(force_bytes(inst.contact[0].name.use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[0].code), force_bytes("C"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[0].system), force_bytes("http://hl7.org/fhir/v2/0131"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].use), force_bytes("mobile"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("0690383372"))
        self.assertFalse(inst.deceasedBoolean)
        self.assertEqual(force_bytes(inst.gender), force_bytes("male"))
        self.assertEqual(force_bytes(inst.id), force_bytes("f001"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:2.16.840.1.113883.2.4.6.3"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("738472983"))
        self.assertEqual(force_bytes(inst.identifier[1].system), force_bytes("urn:oid:2.16.840.1.113883.2.4.6.3"))
        self.assertEqual(force_bytes(inst.identifier[1].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.maritalStatus.coding[0].code), force_bytes("M"))
        self.assertEqual(force_bytes(inst.maritalStatus.coding[0].display), force_bytes("Married"))
        self.assertEqual(force_bytes(inst.maritalStatus.coding[0].system), force_bytes("http://hl7.org/fhir/v3/MaritalStatus"))
        self.assertEqual(force_bytes(inst.maritalStatus.text), force_bytes("Getrouwd"))
        self.assertTrue(inst.multipleBirthBoolean)
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("van de Heuvel"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Pieter"))
        self.assertEqual(force_bytes(inst.name[0].suffix[0]), force_bytes("MSc"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.telecom[0].use), force_bytes("mobile"))
        self.assertEqual(force_bytes(inst.telecom[0].value), force_bytes("0648352638"))
        self.assertEqual(force_bytes(inst.telecom[1].system), force_bytes("email"))
        self.assertEqual(force_bytes(inst.telecom[1].use), force_bytes("home"))
        self.assertEqual(force_bytes(inst.telecom[1].value), force_bytes("p.heuvel@gmail.com"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPatient3(self):
        inst = self.instantiate_from("patient-example-f201-roel.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
        self.implPatient3(inst)
        
        js = inst.as_json()
        self.assertEqual("Patient", js["resourceType"])
        inst2 = patient.Patient(js)
        self.implPatient3(inst2)
    
    def implPatient3(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(force_bytes(inst.address[0].city), force_bytes("Amsterdam"))
        self.assertEqual(force_bytes(inst.address[0].country), force_bytes("NLD"))
        self.assertEqual(force_bytes(inst.address[0].line[0]), force_bytes("Bos en Lommerplein 280"))
        self.assertEqual(force_bytes(inst.address[0].postalCode), force_bytes("1055RW"))
        self.assertEqual(force_bytes(inst.address[0].use), force_bytes("home"))
        self.assertEqual(inst.birthDate.date, FHIRDate("1960-03-13").date)
        self.assertEqual(inst.birthDate.as_json(), "1960-03-13")
        self.assertEqual(force_bytes(inst.communication[0].language.coding[0].code), force_bytes("nl-NL"))
        self.assertEqual(force_bytes(inst.communication[0].language.coding[0].display), force_bytes("Dutch"))
        self.assertEqual(force_bytes(inst.communication[0].language.coding[0].system), force_bytes("urn:ietf:bcp:47"))
        self.assertTrue(inst.communication[0].preferred)
        self.assertEqual(force_bytes(inst.contact[0].name.text), force_bytes("Ariadne Bor-Jansma"))
        self.assertEqual(force_bytes(inst.contact[0].name.use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[0].code), force_bytes("127850001"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[0].display), force_bytes("Wife"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[0].system), force_bytes("http://snomed.info/sct"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[1].code), force_bytes("N"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[1].system), force_bytes("http://hl7.org/fhir/v2/0131"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[2].code), force_bytes("WIFE"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[2].system), force_bytes("http://hl7.org/fhir/v3/RoleCode"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].use), force_bytes("home"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("+31201234567"))
        self.assertFalse(inst.deceasedBoolean)
        self.assertEqual(force_bytes(inst.gender), force_bytes("male"))
        self.assertEqual(force_bytes(inst.id), force_bytes("f201"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:2.16.840.1.113883.2.4.6.3"))
        self.assertEqual(force_bytes(inst.identifier[0].type.text), force_bytes("BSN"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("123456789"))
        self.assertEqual(force_bytes(inst.identifier[1].system), force_bytes("urn:oid:2.16.840.1.113883.2.4.6.3"))
        self.assertEqual(force_bytes(inst.identifier[1].type.text), force_bytes("BSN"))
        self.assertEqual(force_bytes(inst.identifier[1].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.identifier[1].value), force_bytes("123456789"))
        self.assertEqual(force_bytes(inst.maritalStatus.coding[0].code), force_bytes("36629006"))
        self.assertEqual(force_bytes(inst.maritalStatus.coding[0].display), force_bytes("Legally married"))
        self.assertEqual(force_bytes(inst.maritalStatus.coding[0].system), force_bytes("http://snomed.info/sct"))
        self.assertEqual(force_bytes(inst.maritalStatus.coding[1].code), force_bytes("M"))
        self.assertEqual(force_bytes(inst.maritalStatus.coding[1].system), force_bytes("http://hl7.org/fhir/v3/MaritalStatus"))
        self.assertFalse(inst.multipleBirthBoolean)
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Bor"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Roelof Olaf"))
        self.assertEqual(force_bytes(inst.name[0].prefix[0]), force_bytes("Drs."))
        self.assertEqual(force_bytes(inst.name[0].suffix[0]), force_bytes("PDEng."))
        self.assertEqual(force_bytes(inst.name[0].text), force_bytes("Roel"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.photo[0].contentType), force_bytes("image/jpeg"))
        self.assertEqual(force_bytes(inst.photo[0].url), force_bytes("Binary/f006"))
        self.assertEqual(force_bytes(inst.telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.telecom[0].use), force_bytes("mobile"))
        self.assertEqual(force_bytes(inst.telecom[0].value), force_bytes("+31612345678"))
        self.assertEqual(force_bytes(inst.telecom[1].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.telecom[1].use), force_bytes("home"))
        self.assertEqual(force_bytes(inst.telecom[1].value), force_bytes("+31201234567"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPatient4(self):
        inst = self.instantiate_from("patient-example-proband.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
        self.implPatient4(inst)
        
        js = inst.as_json()
        self.assertEqual("Patient", js["resourceType"])
        inst2 = patient.Patient(js)
        self.implPatient4(inst2)
    
    def implPatient4(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(inst.birthDate.date, FHIRDate("1966-04-04").date)
        self.assertEqual(inst.birthDate.as_json(), "1966-04-04")
        self.assertFalse(inst.deceasedBoolean)
        self.assertEqual(force_bytes(inst.gender), force_bytes("female"))
        self.assertEqual(force_bytes(inst.id), force_bytes("proband"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:2.16.840.1.113883.6.117"))
        self.assertEqual(force_bytes(inst.identifier[0].type.text), force_bytes("Computer-Stored Abulatory Records (COSTAR)"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("999999999"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPatient5(self):
        inst = self.instantiate_from("patient-example-b.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
        self.implPatient5(inst)
        
        js = inst.as_json()
        self.assertEqual("Patient", js["resourceType"])
        inst2 = patient.Patient(js)
        self.implPatient5(inst2)
    
    def implPatient5(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(force_bytes(inst.gender), force_bytes("other"))
        self.assertEqual(force_bytes(inst.id), force_bytes("pat2"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:0.1.2.3.4.5.6.7"))
        self.assertEqual(force_bytes(inst.identifier[0].type.coding[0].code), force_bytes("MR"))
        self.assertEqual(force_bytes(inst.identifier[0].type.coding[0].system), force_bytes("http://hl7.org/fhir/v2/0203"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("123456"))
        self.assertEqual(force_bytes(inst.link[0].type), force_bytes("seealso"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Donald"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Duck"))
        self.assertEqual(force_bytes(inst.name[0].given[1]), force_bytes("D"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.photo[0].contentType), force_bytes("image/gif"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPatient6(self):
        inst = self.instantiate_from("patient-example-xds.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
        self.implPatient6(inst)
        
        js = inst.as_json()
        self.assertEqual("Patient", js["resourceType"])
        inst2 = patient.Patient(js)
        self.implPatient6(inst2)
    
    def implPatient6(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(force_bytes(inst.address[0].city), force_bytes("Metropolis"))
        self.assertEqual(force_bytes(inst.address[0].country), force_bytes("USA"))
        self.assertEqual(force_bytes(inst.address[0].line[0]), force_bytes("100 Main St"))
        self.assertEqual(force_bytes(inst.address[0].postalCode), force_bytes("44130"))
        self.assertEqual(force_bytes(inst.address[0].state), force_bytes("Il"))
        self.assertEqual(inst.birthDate.date, FHIRDate("1956-05-27").date)
        self.assertEqual(inst.birthDate.as_json(), "1956-05-27")
        self.assertEqual(force_bytes(inst.gender), force_bytes("male"))
        self.assertEqual(force_bytes(inst.id), force_bytes("xds"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:1.2.3.4.5"))
        self.assertEqual(force_bytes(inst.identifier[0].type.coding[0].code), force_bytes("MR"))
        self.assertEqual(force_bytes(inst.identifier[0].type.coding[0].system), force_bytes("http://hl7.org/fhir/v2/0203"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("89765a87b"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Doe"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("John"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPatient7(self):
        inst = self.instantiate_from("patient-example-dicom.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
        self.implPatient7(inst)
        
        js = inst.as_json()
        self.assertEqual("Patient", js["resourceType"])
        inst2 = patient.Patient(js)
        self.implPatient7(inst2)
    
    def implPatient7(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(force_bytes(inst.extension[0].url), force_bytes("http://nema.org/fhir/extensions#0010:1010"))
        self.assertEqual(force_bytes(inst.extension[0].valueQuantity.unit), force_bytes("Y"))
        self.assertEqual(inst.extension[0].valueQuantity.value, 56)
        self.assertEqual(force_bytes(inst.extension[1].url), force_bytes("http://nema.org/fhir/extensions#0010:1020"))
        self.assertEqual(force_bytes(inst.extension[1].valueQuantity.unit), force_bytes("m"))
        self.assertEqual(inst.extension[1].valueQuantity.value, 1.83)
        self.assertEqual(force_bytes(inst.extension[2].url), force_bytes("http://nema.org/fhir/extensions#0010:1030"))
        self.assertEqual(force_bytes(inst.extension[2].valueQuantity.unit), force_bytes("kg"))
        self.assertEqual(inst.extension[2].valueQuantity.value, 72.58)
        self.assertEqual(force_bytes(inst.gender), force_bytes("male"))
        self.assertEqual(force_bytes(inst.id), force_bytes("dicom"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("http://nema.org/examples/patients"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("MINT1234"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("MINT_TEST"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPatient8(self):
        inst = self.instantiate_from("patient-example-animal.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
        self.implPatient8(inst)
        
        js = inst.as_json()
        self.assertEqual("Patient", js["resourceType"])
        inst2 = patient.Patient(js)
        self.implPatient8(inst2)
    
    def implPatient8(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(force_bytes(inst.animal.breed.coding[0].code), force_bytes("58108001"))
        self.assertEqual(force_bytes(inst.animal.breed.coding[0].display), force_bytes("Golden retriever"))
        self.assertEqual(force_bytes(inst.animal.breed.coding[0].system), force_bytes("http://snomed.info/sct"))
        self.assertEqual(force_bytes(inst.animal.breed.coding[1].code), force_bytes("gret"))
        self.assertEqual(force_bytes(inst.animal.breed.coding[1].display), force_bytes("Golden Retriever"))
        self.assertEqual(force_bytes(inst.animal.breed.coding[1].system), force_bytes("http://hl7.org/fhir/animal-breed"))
        self.assertEqual(force_bytes(inst.animal.genderStatus.coding[0].code), force_bytes("neutered"))
        self.assertEqual(force_bytes(inst.animal.genderStatus.coding[0].system), force_bytes("http://hl7.org/fhir/animal-genderstatus"))
        self.assertEqual(force_bytes(inst.animal.species.coding[0].code), force_bytes("canislf"))
        self.assertEqual(force_bytes(inst.animal.species.coding[0].display), force_bytes("Dog"))
        self.assertEqual(force_bytes(inst.animal.species.coding[0].system), force_bytes("http://hl7.org/fhir/animal-species"))
        self.assertEqual(inst.birthDate.date, FHIRDate("2010-03-23").date)
        self.assertEqual(inst.birthDate.as_json(), "2010-03-23")
        self.assertEqual(force_bytes(inst.contact[0].name.family), force_bytes("Chalmers"))
        self.assertEqual(force_bytes(inst.contact[0].name.given[0]), force_bytes("Peter"))
        self.assertEqual(force_bytes(inst.contact[0].name.given[1]), force_bytes("James"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[0].code), force_bytes("C"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[0].system), force_bytes("http://hl7.org/fhir/v2/0131"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].system), force_bytes("phone"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].use), force_bytes("work"))
        self.assertEqual(force_bytes(inst.contact[0].telecom[0].value), force_bytes("(03) 5555 6473"))
        self.assertEqual(force_bytes(inst.gender), force_bytes("female"))
        self.assertEqual(force_bytes(inst.id), force_bytes("animal"))
        self.assertEqual(inst.identifier[0].period.start.date, FHIRDate("2010-05-31").date)
        self.assertEqual(inst.identifier[0].period.start.as_json(), "2010-05-31")
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("http://www.maroondah.vic.gov.au/AnimalRegFees.aspx"))
        self.assertEqual(force_bytes(inst.identifier[0].type.text), force_bytes("Dog Tag"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("1234123"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Kenzi"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPatient9(self):
        inst = self.instantiate_from("patient-example-d.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
        self.implPatient9(inst)
        
        js = inst.as_json()
        self.assertEqual("Patient", js["resourceType"])
        inst2 = patient.Patient(js)
        self.implPatient9(inst2)
    
    def implPatient9(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(inst.birthDate.date, FHIRDate("1982-08-02").date)
        self.assertEqual(inst.birthDate.as_json(), "1982-08-02")
        self.assertTrue(inst.deceasedBoolean)
        self.assertEqual(force_bytes(inst.gender), force_bytes("female"))
        self.assertEqual(force_bytes(inst.id), force_bytes("pat4"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:0.1.2.3.4.5.6.7"))
        self.assertEqual(force_bytes(inst.identifier[0].type.coding[0].code), force_bytes("MR"))
        self.assertEqual(force_bytes(inst.identifier[0].type.coding[0].system), force_bytes("http://hl7.org/fhir/v2/0203"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("123458"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Notsowell"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Sandy"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))
    
    def testPatient10(self):
        inst = self.instantiate_from("patient-example-a.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
        self.implPatient10(inst)
        
        js = inst.as_json()
        self.assertEqual("Patient", js["resourceType"])
        inst2 = patient.Patient(js)
        self.implPatient10(inst2)
    
    def implPatient10(self, inst):
        self.assertTrue(inst.active)
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[0].code), force_bytes("E"))
        self.assertEqual(force_bytes(inst.contact[0].relationship[0].coding[0].system), force_bytes("http://hl7.org/fhir/v2/0131"))
        self.assertEqual(force_bytes(inst.gender), force_bytes("male"))
        self.assertEqual(force_bytes(inst.id), force_bytes("pat1"))
        self.assertEqual(force_bytes(inst.identifier[0].system), force_bytes("urn:oid:0.1.2.3.4.5.6.7"))
        self.assertEqual(force_bytes(inst.identifier[0].type.coding[0].code), force_bytes("MR"))
        self.assertEqual(force_bytes(inst.identifier[0].type.coding[0].system), force_bytes("http://hl7.org/fhir/v2/0203"))
        self.assertEqual(force_bytes(inst.identifier[0].use), force_bytes("usual"))
        self.assertEqual(force_bytes(inst.identifier[0].value), force_bytes("654321"))
        self.assertEqual(force_bytes(inst.link[0].type), force_bytes("seealso"))
        self.assertEqual(force_bytes(inst.name[0].family), force_bytes("Donald"))
        self.assertEqual(force_bytes(inst.name[0].given[0]), force_bytes("Duck"))
        self.assertEqual(force_bytes(inst.name[0].use), force_bytes("official"))
        self.assertEqual(force_bytes(inst.photo[0].contentType), force_bytes("image/gif"))
        self.assertEqual(force_bytes(inst.text.status), force_bytes("generated"))

