#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 3.0.1.11917 (http://hl7.org/fhir/StructureDefinition/TestReport) on 2019-05-13.
#  2019, SMART Health IT.


from . import domainresource

class TestReport(domainresource.DomainResource):
    """ Describes the results of a TestScript execution.

    A summary of information based on the results of executing a TestScript.
    """

    resource_type = "TestReport"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.identifier = None
        """ External identifier.
        Type `Identifier` (represented as `dict` in JSON). """

        self.issued = None
        """ When the TestScript was executed and this TestReport was generated.
        Type `FHIRDate` (represented as `str` in JSON). """

        self.name = None
        """ Informal name of the executed TestScript.
        Type `str`. """

        self.participant = None
        """ A participant in the test execution, either the execution engine, a
        client, or a server.
        List of `TestReportParticipant` items (represented as `dict` in JSON). """

        self.result = None
        """ pass | fail | pending.
        Type `str`. """

        self.score = None
        """ The final score (percentage of tests passed) resulting from the
        execution of the TestScript.
        Type `float`. """

        self.setup = None
        """ The results of the series of required setup operations before the
        tests were executed.
        Type `TestReportSetup` (represented as `dict` in JSON). """

        self.status = None
        """ completed | in-progress | waiting | stopped | entered-in-error.
        Type `str`. """

        self.teardown = None
        """ The results of running the series of required clean up steps.
        Type `TestReportTeardown` (represented as `dict` in JSON). """

        self.test = None
        """ A test executed from the test script.
        List of `TestReportTest` items (represented as `dict` in JSON). """

        self.testScript = None
        """ Reference to the  version-specific TestScript that was executed to
        produce this TestReport.
        Type `FHIRReference` referencing `TestScript` (represented as `dict` in JSON). """

        self.tester = None
        """ Name of the tester producing this report (Organization or
        individual).
        Type `str`. """

        super(TestReport, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(TestReport, self).elementProperties()
        js.extend([
            ("identifier", "identifier", identifier.Identifier, "Identifier", False, None, False),
            ("issued", "issued", fhirdate.FHIRDate, "dateTime", False, None, False),
            ("name", "name", str, "string", False, None, False),
            ("participant", "participant", TestReportParticipant, "TestReportParticipant", True, None, False),
            ("result", "result", str, "code", False, None, True),
            ("score", "score", float, "decimal", False, None, False),
            ("setup", "setup", TestReportSetup, "TestReportSetup", False, None, False),
            ("status", "status", str, "code", False, None, True),
            ("teardown", "teardown", TestReportTeardown, "TestReportTeardown", False, None, False),
            ("test", "test", TestReportTest, "TestReportTest", True, None, False),
            ("testScript", "testScript", fhirreference.FHIRReference, "Reference", False, None, True),
            ("tester", "tester", str, "string", False, None, False),
        ])
        return js


from . import backboneelement

class TestReportParticipant(backboneelement.BackboneElement):
    """ A participant in the test execution, either the execution engine, a client,
    or a server.
    """

    resource_type = "TestReportParticipant"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.display = None
        """ The display name of the participant.
        Type `str`. """

        self.type = None
        """ test-engine | client | server.
        Type `str`. """

        self.uri = None
        """ The uri of the participant. An absolute URL is preferred.
        Type `str`. """

        super(TestReportParticipant, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(TestReportParticipant, self).elementProperties()
        js.extend([
            ("display", "display", str, "string", False, None, False),
            ("type", "type", str, "code", False, None, True),
            ("uri", "uri", str, "uri", False, None, True),
        ])
        return js


class TestReportSetup(backboneelement.BackboneElement):
    """ The results of the series of required setup operations before the tests
    were executed.
    """

    resource_type = "TestReportSetup"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.action = None
        """ A setup operation or assert that was executed.
        List of `TestReportSetupAction` items (represented as `dict` in JSON). """

        super(TestReportSetup, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(TestReportSetup, self).elementProperties()
        js.extend([
            ("action", "action", TestReportSetupAction, "TestReportSetupAction", True, None, True),
        ])
        return js


class TestReportSetupAction(backboneelement.BackboneElement):
    """ A setup operation or assert that was executed.

    Action would contain either an operation or an assertion.
    """

    resource_type = "TestReportSetupAction"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.assert_fhir = None
        """ The assertion to perform.
        Type `TestReportSetupActionAssert` (represented as `dict` in JSON). """

        self.operation = None
        """ The operation to perform.
        Type `TestReportSetupActionOperation` (represented as `dict` in JSON). """

        super(TestReportSetupAction, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(TestReportSetupAction, self).elementProperties()
        js.extend([
            ("assert_fhir", "assert", TestReportSetupActionAssert, "TestReportSetupActionAssert", False, None, False),
            ("operation", "operation", TestReportSetupActionOperation, "TestReportSetupActionOperation", False, None, False),
        ])
        return js


class TestReportSetupActionAssert(backboneelement.BackboneElement):
    """ The assertion to perform.

    The results of the assertion performed on the previous operations.
    """

    resource_type = "TestReportSetupActionAssert"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.detail = None
        """ A link to further details on the result.
        Type `str`. """

        self.message = None
        """ A message associated with the result.
        Type `str`. """

        self.result = None
        """ pass | skip | fail | warning | error.
        Type `str`. """

        super(TestReportSetupActionAssert, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(TestReportSetupActionAssert, self).elementProperties()
        js.extend([
            ("detail", "detail", str, "string", False, None, False),
            ("message", "message", str, "markdown", False, None, False),
            ("result", "result", str, "code", False, None, True),
        ])
        return js


class TestReportSetupActionOperation(backboneelement.BackboneElement):
    """ The operation to perform.

    The operation performed.
    """

    resource_type = "TestReportSetupActionOperation"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.detail = None
        """ A link to further details on the result.
        Type `str`. """

        self.message = None
        """ A message associated with the result.
        Type `str`. """

        self.result = None
        """ pass | skip | fail | warning | error.
        Type `str`. """

        super(TestReportSetupActionOperation, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(TestReportSetupActionOperation, self).elementProperties()
        js.extend([
            ("detail", "detail", str, "uri", False, None, False),
            ("message", "message", str, "markdown", False, None, False),
            ("result", "result", str, "code", False, None, True),
        ])
        return js


class TestReportTeardown(backboneelement.BackboneElement):
    """ The results of running the series of required clean up steps.

    The results of the series of operations required to clean up after the all
    the tests were executed (successfully or otherwise).
    """

    resource_type = "TestReportTeardown"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.action = None
        """ One or more teardown operations performed.
        List of `TestReportTeardownAction` items (represented as `dict` in JSON). """

        super(TestReportTeardown, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(TestReportTeardown, self).elementProperties()
        js.extend([
            ("action", "action", TestReportTeardownAction, "TestReportTeardownAction", True, None, True),
        ])
        return js


class TestReportTeardownAction(backboneelement.BackboneElement):
    """ One or more teardown operations performed.

    The teardown action will only contain an operation.
    """

    resource_type = "TestReportTeardownAction"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.operation = None
        """ The teardown operation performed.
        Type `TestReportSetupActionOperation` (represented as `dict` in JSON). """

        super(TestReportTeardownAction, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(TestReportTeardownAction, self).elementProperties()
        js.extend([
            ("operation", "operation", TestReportSetupActionOperation, "TestReportSetupActionOperation", False, None, True),
        ])
        return js


class TestReportTest(backboneelement.BackboneElement):
    """ A test executed from the test script.
    """

    resource_type = "TestReportTest"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.action = None
        """ A test operation or assert that was performed.
        List of `TestReportTestAction` items (represented as `dict` in JSON). """

        self.description = None
        """ Tracking/reporting short description of the test.
        Type `str`. """

        self.name = None
        """ Tracking/logging name of this test.
        Type `str`. """

        super(TestReportTest, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(TestReportTest, self).elementProperties()
        js.extend([
            ("action", "action", TestReportTestAction, "TestReportTestAction", True, None, True),
            ("description", "description", str, "string", False, None, False),
            ("name", "name", str, "string", False, None, False),
        ])
        return js


class TestReportTestAction(backboneelement.BackboneElement):
    """ A test operation or assert that was performed.

    Action would contain either an operation or an assertion.
    """

    resource_type = "TestReportTestAction"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.assert_fhir = None
        """ The assertion performed.
        Type `TestReportSetupActionAssert` (represented as `dict` in JSON). """

        self.operation = None
        """ The operation performed.
        Type `TestReportSetupActionOperation` (represented as `dict` in JSON). """

        super(TestReportTestAction, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(TestReportTestAction, self).elementProperties()
        js.extend([
            ("assert_fhir", "assert", TestReportSetupActionAssert, "TestReportSetupActionAssert", False, None, False),
            ("operation", "operation", TestReportSetupActionOperation, "TestReportSetupActionOperation", False, None, False),
        ])
        return js


import sys
try:
    from . import fhirdate
except ImportError:
    fhirdate = sys.modules[__package__ + '.fhirdate']
try:
    from . import fhirreference
except ImportError:
    fhirreference = sys.modules[__package__ + '.fhirreference']
try:
    from . import identifier
except ImportError:
    identifier = sys.modules[__package__ + '.identifier']
