#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 3.0.1.11917 (http://hl7.org/fhir/StructureDefinition/PlanDefinition) on 2019-05-13.
#  2019, SMART Health IT.


from . import domainresource

class PlanDefinition(domainresource.DomainResource):
    """ The definition of a plan for a series of actions, independent of any
    specific patient or context.

    This resource allows for the definition of various types of plans as a
    sharable, consumable, and executable artifact. The resource is general
    enough to support the description of a broad range of clinical artifacts
    such as clinical decision support rules, order sets and protocols.
    """

    resource_type = "PlanDefinition"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.action = None
        """ Action defined by the plan.
        List of `PlanDefinitionAction` items (represented as `dict` in JSON). """

        self.approvalDate = None
        """ When the plan definition was approved by publisher.
        Type `FHIRDate` (represented as `str` in JSON). """

        self.contact = None
        """ Contact details for the publisher.
        List of `ContactDetail` items (represented as `dict` in JSON). """

        self.contributor = None
        """ A content contributor.
        List of `Contributor` items (represented as `dict` in JSON). """

        self.copyright = None
        """ Use and/or publishing restrictions.
        Type `str`. """

        self.date = None
        """ Date this was last changed.
        Type `FHIRDate` (represented as `str` in JSON). """

        self.description = None
        """ Natural language description of the plan definition.
        Type `str`. """

        self.effectivePeriod = None
        """ When the plan definition is expected to be used.
        Type `Period` (represented as `dict` in JSON). """

        self.experimental = None
        """ For testing purposes, not real usage.
        Type `bool`. """

        self.goal = None
        """ What the plan is trying to accomplish.
        List of `PlanDefinitionGoal` items (represented as `dict` in JSON). """

        self.identifier = None
        """ Additional identifier for the plan definition.
        List of `Identifier` items (represented as `dict` in JSON). """

        self.jurisdiction = None
        """ Intended jurisdiction for plan definition (if applicable).
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        self.lastReviewDate = None
        """ When the plan definition was last reviewed.
        Type `FHIRDate` (represented as `str` in JSON). """

        self.library = None
        """ Logic used by the plan definition.
        List of `FHIRReference` items referencing `Library` (represented as `dict` in JSON). """

        self.name = None
        """ Name for this plan definition (computer friendly).
        Type `str`. """

        self.publisher = None
        """ Name of the publisher (organization or individual).
        Type `str`. """

        self.purpose = None
        """ Why this plan definition is defined.
        Type `str`. """

        self.relatedArtifact = None
        """ Related artifacts for the asset.
        List of `RelatedArtifact` items (represented as `dict` in JSON). """

        self.status = None
        """ draft | active | retired | unknown.
        Type `str`. """

        self.title = None
        """ Name for this plan definition (human friendly).
        Type `str`. """

        self.topic = None
        """ E.g. Education, Treatment, Assessment, etc.
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        self.type = None
        """ order-set | protocol | eca-rule.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.url = None
        """ Logical URI to reference this plan definition (globally unique).
        Type `str`. """

        self.usage = None
        """ Describes the clinical usage of the asset.
        Type `str`. """

        self.useContext = None
        """ Context the content is intended to support.
        List of `UsageContext` items (represented as `dict` in JSON). """

        self.version = None
        """ Business version of the plan definition.
        Type `str`. """

        super(PlanDefinition, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(PlanDefinition, self).elementProperties()
        js.extend([
            ("action", "action", PlanDefinitionAction, "PlanDefinitionAction", True, None, False),
            ("approvalDate", "approvalDate", fhirdate.FHIRDate, "date", False, None, False),
            ("contact", "contact", contactdetail.ContactDetail, "ContactDetail", True, None, False),
            ("contributor", "contributor", contributor.Contributor, "Contributor", True, None, False),
            ("copyright", "copyright", str, "markdown", False, None, False),
            ("date", "date", fhirdate.FHIRDate, "dateTime", False, None, False),
            ("description", "description", str, "markdown", False, None, False),
            ("effectivePeriod", "effectivePeriod", period.Period, "Period", False, None, False),
            ("experimental", "experimental", bool, "boolean", False, None, False),
            ("goal", "goal", PlanDefinitionGoal, "PlanDefinitionGoal", True, None, False),
            ("identifier", "identifier", identifier.Identifier, "Identifier", True, None, False),
            ("jurisdiction", "jurisdiction", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
            ("lastReviewDate", "lastReviewDate", fhirdate.FHIRDate, "date", False, None, False),
            ("library", "library", fhirreference.FHIRReference, "Reference", True, None, False),
            ("name", "name", str, "string", False, None, False),
            ("publisher", "publisher", str, "string", False, None, False),
            ("purpose", "purpose", str, "markdown", False, None, False),
            ("relatedArtifact", "relatedArtifact", relatedartifact.RelatedArtifact, "RelatedArtifact", True, None, False),
            ("status", "status", str, "code", False, None, True),
            ("title", "title", str, "string", False, None, False),
            ("topic", "topic", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
            ("type", "type", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("url", "url", str, "uri", False, None, False),
            ("usage", "usage", str, "string", False, None, False),
            ("useContext", "useContext", usagecontext.UsageContext, "UsageContext", True, None, False),
            ("version", "version", str, "string", False, None, False),
        ])
        return js


from . import backboneelement

class PlanDefinitionAction(backboneelement.BackboneElement):
    """ Action defined by the plan.

    An action to be taken as part of the plan.
    """

    resource_type = "PlanDefinitionAction"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.action = None
        """ A sub-action.
        List of `PlanDefinitionAction` items (represented as `dict` in JSON). """

        self.cardinalityBehavior = None
        """ single | multiple.
        Type `str`. """

        self.code = None
        """ Code representing the meaning of the action or sub-actions.
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        self.condition = None
        """ Whether or not the action is applicable.
        List of `PlanDefinitionActionCondition` items (represented as `dict` in JSON). """

        self.definition = None
        """ Description of the activity to be performed.
        Type `FHIRReference` referencing `ActivityDefinition, PlanDefinition` (represented as `dict` in JSON). """

        self.description = None
        """ Short description of the action.
        Type `str`. """

        self.documentation = None
        """ Supporting documentation for the intended performer of the action.
        List of `RelatedArtifact` items (represented as `dict` in JSON). """

        self.dynamicValue = None
        """ Dynamic aspects of the definition.
        List of `PlanDefinitionActionDynamicValue` items (represented as `dict` in JSON). """

        self.goalId = None
        """ What goals this action supports.
        List of `str` items. """

        self.groupingBehavior = None
        """ visual-group | logical-group | sentence-group.
        Type `str`. """

        self.input = None
        """ Input data requirements.
        List of `DataRequirement` items (represented as `dict` in JSON). """

        self.label = None
        """ User-visible label for the action (e.g. 1. or A.).
        Type `str`. """

        self.output = None
        """ Output data definition.
        List of `DataRequirement` items (represented as `dict` in JSON). """

        self.participant = None
        """ Who should participate in the action.
        List of `PlanDefinitionActionParticipant` items (represented as `dict` in JSON). """

        self.precheckBehavior = None
        """ yes | no.
        Type `str`. """

        self.reason = None
        """ Why the action should be performed.
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        self.relatedAction = None
        """ Relationship to another action.
        List of `PlanDefinitionActionRelatedAction` items (represented as `dict` in JSON). """

        self.requiredBehavior = None
        """ must | could | must-unless-documented.
        Type `str`. """

        self.selectionBehavior = None
        """ any | all | all-or-none | exactly-one | at-most-one | one-or-more.
        Type `str`. """

        self.textEquivalent = None
        """ Static text equivalent of the action, used if the dynamic aspects
        cannot be interpreted by the receiving system.
        Type `str`. """

        self.timingDateTime = None
        """ When the action should take place.
        Type `FHIRDate` (represented as `str` in JSON). """

        self.timingDuration = None
        """ When the action should take place.
        Type `Duration` (represented as `dict` in JSON). """

        self.timingPeriod = None
        """ When the action should take place.
        Type `Period` (represented as `dict` in JSON). """

        self.timingRange = None
        """ When the action should take place.
        Type `Range` (represented as `dict` in JSON). """

        self.timingTiming = None
        """ When the action should take place.
        Type `Timing` (represented as `dict` in JSON). """

        self.title = None
        """ User-visible title.
        Type `str`. """

        self.transform = None
        """ Transform to apply the template.
        Type `FHIRReference` referencing `StructureMap` (represented as `dict` in JSON). """

        self.triggerDefinition = None
        """ When the action should be triggered.
        List of `TriggerDefinition` items (represented as `dict` in JSON). """

        self.type = None
        """ create | update | remove | fire-event.
        Type `Coding` (represented as `dict` in JSON). """

        super(PlanDefinitionAction, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(PlanDefinitionAction, self).elementProperties()
        js.extend([
            ("action", "action", PlanDefinitionAction, "PlanDefinitionAction", True, None, False),
            ("cardinalityBehavior", "cardinalityBehavior", str, "code", False, None, False),
            ("code", "code", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
            ("condition", "condition", PlanDefinitionActionCondition, "PlanDefinitionActionCondition", True, None, False),
            ("definition", "definition", fhirreference.FHIRReference, "Reference", False, None, False),
            ("description", "description", str, "string", False, None, False),
            ("documentation", "documentation", relatedartifact.RelatedArtifact, "RelatedArtifact", True, None, False),
            ("dynamicValue", "dynamicValue", PlanDefinitionActionDynamicValue, "PlanDefinitionActionDynamicValue", True, None, False),
            ("goalId", "goalId", str, "id", True, None, False),
            ("groupingBehavior", "groupingBehavior", str, "code", False, None, False),
            ("input", "input", datarequirement.DataRequirement, "DataRequirement", True, None, False),
            ("label", "label", str, "string", False, None, False),
            ("output", "output", datarequirement.DataRequirement, "DataRequirement", True, None, False),
            ("participant", "participant", PlanDefinitionActionParticipant, "PlanDefinitionActionParticipant", True, None, False),
            ("precheckBehavior", "precheckBehavior", str, "code", False, None, False),
            ("reason", "reason", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
            ("relatedAction", "relatedAction", PlanDefinitionActionRelatedAction, "PlanDefinitionActionRelatedAction", True, None, False),
            ("requiredBehavior", "requiredBehavior", str, "code", False, None, False),
            ("selectionBehavior", "selectionBehavior", str, "code", False, None, False),
            ("textEquivalent", "textEquivalent", str, "string", False, None, False),
            ("timingDateTime", "timingDateTime", fhirdate.FHIRDate, "dateTime", False, "timing", False),
            ("timingDuration", "timingDuration", duration.Duration, "Duration", False, "timing", False),
            ("timingPeriod", "timingPeriod", period.Period, "Period", False, "timing", False),
            ("timingRange", "timingRange", range.Range, "Range", False, "timing", False),
            ("timingTiming", "timingTiming", timing.Timing, "Timing", False, "timing", False),
            ("title", "title", str, "string", False, None, False),
            ("transform", "transform", fhirreference.FHIRReference, "Reference", False, None, False),
            ("triggerDefinition", "triggerDefinition", triggerdefinition.TriggerDefinition, "TriggerDefinition", True, None, False),
            ("type", "type", coding.Coding, "Coding", False, None, False),
        ])
        return js


class PlanDefinitionActionCondition(backboneelement.BackboneElement):
    """ Whether or not the action is applicable.

    An expression that describes applicability criteria, or start/stop
    conditions for the action.
    """

    resource_type = "PlanDefinitionActionCondition"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.description = None
        """ Natural language description of the condition.
        Type `str`. """

        self.expression = None
        """ Boolean-valued expression.
        Type `str`. """

        self.kind = None
        """ applicability | start | stop.
        Type `str`. """

        self.language = None
        """ Language of the expression.
        Type `str`. """

        super(PlanDefinitionActionCondition, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(PlanDefinitionActionCondition, self).elementProperties()
        js.extend([
            ("description", "description", str, "string", False, None, False),
            ("expression", "expression", str, "string", False, None, False),
            ("kind", "kind", str, "code", False, None, True),
            ("language", "language", str, "string", False, None, False),
        ])
        return js


class PlanDefinitionActionDynamicValue(backboneelement.BackboneElement):
    """ Dynamic aspects of the definition.

    Customizations that should be applied to the statically defined resource.
    For example, if the dosage of a medication must be computed based on the
    patient's weight, a customization would be used to specify an expression
    that calculated the weight, and the path on the resource that would contain
    the result.
    """

    resource_type = "PlanDefinitionActionDynamicValue"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.description = None
        """ Natural language description of the dynamic value.
        Type `str`. """

        self.expression = None
        """ An expression that provides the dynamic value for the customization.
        Type `str`. """

        self.language = None
        """ Language of the expression.
        Type `str`. """

        self.path = None
        """ The path to the element to be set dynamically.
        Type `str`. """

        super(PlanDefinitionActionDynamicValue, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(PlanDefinitionActionDynamicValue, self).elementProperties()
        js.extend([
            ("description", "description", str, "string", False, None, False),
            ("expression", "expression", str, "string", False, None, False),
            ("language", "language", str, "string", False, None, False),
            ("path", "path", str, "string", False, None, False),
        ])
        return js


class PlanDefinitionActionParticipant(backboneelement.BackboneElement):
    """ Who should participate in the action.

    Indicates who should participate in performing the action described.
    """

    resource_type = "PlanDefinitionActionParticipant"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.role = None
        """ E.g. Nurse, Surgeon, Parent, etc.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.type = None
        """ patient | practitioner | related-person.
        Type `str`. """

        super(PlanDefinitionActionParticipant, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(PlanDefinitionActionParticipant, self).elementProperties()
        js.extend([
            ("role", "role", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("type", "type", str, "code", False, None, True),
        ])
        return js


class PlanDefinitionActionRelatedAction(backboneelement.BackboneElement):
    """ Relationship to another action.

    A relationship to another action such as "before" or "30-60 minutes after
    start of".
    """

    resource_type = "PlanDefinitionActionRelatedAction"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.actionId = None
        """ What action is this related to.
        Type `str`. """

        self.offsetDuration = None
        """ Time offset for the relationship.
        Type `Duration` (represented as `dict` in JSON). """

        self.offsetRange = None
        """ Time offset for the relationship.
        Type `Range` (represented as `dict` in JSON). """

        self.relationship = None
        """ before-start | before | before-end | concurrent-with-start |
        concurrent | concurrent-with-end | after-start | after | after-end.
        Type `str`. """

        super(PlanDefinitionActionRelatedAction, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(PlanDefinitionActionRelatedAction, self).elementProperties()
        js.extend([
            ("actionId", "actionId", str, "id", False, None, True),
            ("offsetDuration", "offsetDuration", duration.Duration, "Duration", False, "offset", False),
            ("offsetRange", "offsetRange", range.Range, "Range", False, "offset", False),
            ("relationship", "relationship", str, "code", False, None, True),
        ])
        return js


class PlanDefinitionGoal(backboneelement.BackboneElement):
    """ What the plan is trying to accomplish.

    Goals that describe what the activities within the plan are intended to
    achieve. For example, weight loss, restoring an activity of daily living,
    obtaining herd immunity via immunization, meeting a process improvement
    objective, etc.
    """

    resource_type = "PlanDefinitionGoal"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.addresses = None
        """ What does the goal address.
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        self.category = None
        """ E.g. Treatment, dietary, behavioral, etc.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.description = None
        """ Code or text describing the goal.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.documentation = None
        """ Supporting documentation for the goal.
        List of `RelatedArtifact` items (represented as `dict` in JSON). """

        self.priority = None
        """ high-priority | medium-priority | low-priority.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.start = None
        """ When goal pursuit begins.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.target = None
        """ Target outcome for the goal.
        List of `PlanDefinitionGoalTarget` items (represented as `dict` in JSON). """

        super(PlanDefinitionGoal, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(PlanDefinitionGoal, self).elementProperties()
        js.extend([
            ("addresses", "addresses", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
            ("category", "category", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("description", "description", codeableconcept.CodeableConcept, "CodeableConcept", False, None, True),
            ("documentation", "documentation", relatedartifact.RelatedArtifact, "RelatedArtifact", True, None, False),
            ("priority", "priority", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("start", "start", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("target", "target", PlanDefinitionGoalTarget, "PlanDefinitionGoalTarget", True, None, False),
        ])
        return js


class PlanDefinitionGoalTarget(backboneelement.BackboneElement):
    """ Target outcome for the goal.

    Indicates what should be done and within what timeframe.
    """

    resource_type = "PlanDefinitionGoalTarget"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.detailCodeableConcept = None
        """ The target value to be achieved.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.detailQuantity = None
        """ The target value to be achieved.
        Type `Quantity` (represented as `dict` in JSON). """

        self.detailRange = None
        """ The target value to be achieved.
        Type `Range` (represented as `dict` in JSON). """

        self.due = None
        """ Reach goal within.
        Type `Duration` (represented as `dict` in JSON). """

        self.measure = None
        """ The parameter whose value is to be tracked.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        super(PlanDefinitionGoalTarget, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(PlanDefinitionGoalTarget, self).elementProperties()
        js.extend([
            ("detailCodeableConcept", "detailCodeableConcept", codeableconcept.CodeableConcept, "CodeableConcept", False, "detail", False),
            ("detailQuantity", "detailQuantity", quantity.Quantity, "Quantity", False, "detail", False),
            ("detailRange", "detailRange", range.Range, "Range", False, "detail", False),
            ("due", "due", duration.Duration, "Duration", False, None, False),
            ("measure", "measure", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
        ])
        return js


import sys
try:
    from . import codeableconcept
except ImportError:
    codeableconcept = sys.modules[__package__ + '.codeableconcept']
try:
    from . import coding
except ImportError:
    coding = sys.modules[__package__ + '.coding']
try:
    from . import contactdetail
except ImportError:
    contactdetail = sys.modules[__package__ + '.contactdetail']
try:
    from . import contributor
except ImportError:
    contributor = sys.modules[__package__ + '.contributor']
try:
    from . import datarequirement
except ImportError:
    datarequirement = sys.modules[__package__ + '.datarequirement']
try:
    from . import duration
except ImportError:
    duration = sys.modules[__package__ + '.duration']
try:
    from . import fhirdate
except ImportError:
    fhirdate = sys.modules[__package__ + '.fhirdate']
try:
    from . import fhirreference
except ImportError:
    fhirreference = sys.modules[__package__ + '.fhirreference']
try:
    from . import identifier
except ImportError:
    identifier = sys.modules[__package__ + '.identifier']
try:
    from . import period
except ImportError:
    period = sys.modules[__package__ + '.period']
try:
    from . import quantity
except ImportError:
    quantity = sys.modules[__package__ + '.quantity']
try:
    from . import range
except ImportError:
    range = sys.modules[__package__ + '.range']
try:
    from . import relatedartifact
except ImportError:
    relatedartifact = sys.modules[__package__ + '.relatedartifact']
try:
    from . import timing
except ImportError:
    timing = sys.modules[__package__ + '.timing']
try:
    from . import triggerdefinition
except ImportError:
    triggerdefinition = sys.modules[__package__ + '.triggerdefinition']
try:
    from . import usagecontext
except ImportError:
    usagecontext = sys.modules[__package__ + '.usagecontext']
