#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 3.0.1.11917 (http://hl7.org/fhir/StructureDefinition/MessageDefinition) on 2019-05-13.
#  2019, SMART Health IT.


from . import domainresource

class MessageDefinition(domainresource.DomainResource):
    """ A resource that defines a type of message that can be exchanged between
    systems.

    Defines the characteristics of a message that can be shared between
    systems, including the type of event that initiates the message, the
    content to be transmitted and what response(s), if any, are permitted.
    """

    resource_type = "MessageDefinition"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.allowedResponse = None
        """ Responses to this message.
        List of `MessageDefinitionAllowedResponse` items (represented as `dict` in JSON). """

        self.base = None
        """ Definition this one is based on.
        Type `FHIRReference` referencing `MessageDefinition` (represented as `dict` in JSON). """

        self.category = None
        """ Consequence | Currency | Notification.
        Type `str`. """

        self.contact = None
        """ Contact details for the publisher.
        List of `ContactDetail` items (represented as `dict` in JSON). """

        self.copyright = None
        """ Use and/or publishing restrictions.
        Type `str`. """

        self.date = None
        """ Date this was last changed.
        Type `FHIRDate` (represented as `str` in JSON). """

        self.description = None
        """ Natural language description of the message definition.
        Type `str`. """

        self.event = None
        """ Event type.
        Type `Coding` (represented as `dict` in JSON). """

        self.experimental = None
        """ For testing purposes, not real usage.
        Type `bool`. """

        self.focus = None
        """ Resource(s) that are the subject of the event.
        List of `MessageDefinitionFocus` items (represented as `dict` in JSON). """

        self.identifier = None
        """ Additional identifier for the message definition.
        Type `Identifier` (represented as `dict` in JSON). """

        self.jurisdiction = None
        """ Intended jurisdiction for message definition (if applicable).
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        self.name = None
        """ Name for this message definition (computer friendly).
        Type `str`. """

        self.parent = None
        """ Protocol/workflow this is part of.
        List of `FHIRReference` items referencing `ActivityDefinition, PlanDefinition` (represented as `dict` in JSON). """

        self.publisher = None
        """ Name of the publisher (organization or individual).
        Type `str`. """

        self.purpose = None
        """ Why this message definition is defined.
        Type `str`. """

        self.replaces = None
        """ Takes the place of.
        List of `FHIRReference` items referencing `MessageDefinition` (represented as `dict` in JSON). """

        self.responseRequired = None
        """ Is a response required?.
        Type `bool`. """

        self.status = None
        """ draft | active | retired | unknown.
        Type `str`. """

        self.title = None
        """ Name for this message definition (human friendly).
        Type `str`. """

        self.url = None
        """ Logical URI to reference this message definition (globally unique).
        Type `str`. """

        self.useContext = None
        """ Context the content is intended to support.
        List of `UsageContext` items (represented as `dict` in JSON). """

        self.version = None
        """ Business version of the message definition.
        Type `str`. """

        super(MessageDefinition, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(MessageDefinition, self).elementProperties()
        js.extend([
            ("allowedResponse", "allowedResponse", MessageDefinitionAllowedResponse, "MessageDefinitionAllowedResponse", True, None, False),
            ("base", "base", fhirreference.FHIRReference, "Reference", False, None, False),
            ("category", "category", str, "code", False, None, False),
            ("contact", "contact", contactdetail.ContactDetail, "ContactDetail", True, None, False),
            ("copyright", "copyright", str, "markdown", False, None, False),
            ("date", "date", fhirdate.FHIRDate, "dateTime", False, None, True),
            ("description", "description", str, "markdown", False, None, False),
            ("event", "event", coding.Coding, "Coding", False, None, True),
            ("experimental", "experimental", bool, "boolean", False, None, False),
            ("focus", "focus", MessageDefinitionFocus, "MessageDefinitionFocus", True, None, False),
            ("identifier", "identifier", identifier.Identifier, "Identifier", False, None, False),
            ("jurisdiction", "jurisdiction", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
            ("name", "name", str, "string", False, None, False),
            ("parent", "parent", fhirreference.FHIRReference, "Reference", True, None, False),
            ("publisher", "publisher", str, "string", False, None, False),
            ("purpose", "purpose", str, "markdown", False, None, False),
            ("replaces", "replaces", fhirreference.FHIRReference, "Reference", True, None, False),
            ("responseRequired", "responseRequired", bool, "boolean", False, None, False),
            ("status", "status", str, "code", False, None, True),
            ("title", "title", str, "string", False, None, False),
            ("url", "url", str, "uri", False, None, False),
            ("useContext", "useContext", usagecontext.UsageContext, "UsageContext", True, None, False),
            ("version", "version", str, "string", False, None, False),
        ])
        return js


from . import backboneelement

class MessageDefinitionAllowedResponse(backboneelement.BackboneElement):
    """ Responses to this message.

    Indicates what types of messages may be sent as an application-level
    response to this message.
    """

    resource_type = "MessageDefinitionAllowedResponse"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.message = None
        """ Reference to allowed message definition response.
        Type `FHIRReference` referencing `MessageDefinition` (represented as `dict` in JSON). """

        self.situation = None
        """ When should this response be used.
        Type `str`. """

        super(MessageDefinitionAllowedResponse, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(MessageDefinitionAllowedResponse, self).elementProperties()
        js.extend([
            ("message", "message", fhirreference.FHIRReference, "Reference", False, None, True),
            ("situation", "situation", str, "markdown", False, None, False),
        ])
        return js


class MessageDefinitionFocus(backboneelement.BackboneElement):
    """ Resource(s) that are the subject of the event.

    Identifies the resource (or resources) that are being addressed by the
    event.  For example, the Encounter for an admit message or two Account
    records for a merge.
    """

    resource_type = "MessageDefinitionFocus"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.code = None
        """ Type of resource.
        Type `str`. """

        self.max = None
        """ Maximum number of focuses of this type.
        Type `str`. """

        self.min = None
        """ Minimum number of focuses of this type.
        Type `int`. """

        self.profile = None
        """ Profile that must be adhered to by focus.
        Type `FHIRReference` referencing `StructureDefinition` (represented as `dict` in JSON). """

        super(MessageDefinitionFocus, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(MessageDefinitionFocus, self).elementProperties()
        js.extend([
            ("code", "code", str, "code", False, None, True),
            ("max", "max", str, "string", False, None, False),
            ("min", "min", int, "unsignedInt", False, None, False),
            ("profile", "profile", fhirreference.FHIRReference, "Reference", False, None, False),
        ])
        return js


import sys
try:
    from . import codeableconcept
except ImportError:
    codeableconcept = sys.modules[__package__ + '.codeableconcept']
try:
    from . import coding
except ImportError:
    coding = sys.modules[__package__ + '.coding']
try:
    from . import contactdetail
except ImportError:
    contactdetail = sys.modules[__package__ + '.contactdetail']
try:
    from . import fhirdate
except ImportError:
    fhirdate = sys.modules[__package__ + '.fhirdate']
try:
    from . import fhirreference
except ImportError:
    fhirreference = sys.modules[__package__ + '.fhirreference']
try:
    from . import identifier
except ImportError:
    identifier = sys.modules[__package__ + '.identifier']
try:
    from . import usagecontext
except ImportError:
    usagecontext = sys.modules[__package__ + '.usagecontext']
