#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 3.0.1.11917 (http://hl7.org/fhir/StructureDefinition/MedicationAdministration) on 2019-05-13.
#  2019, SMART Health IT.


from . import domainresource

class MedicationAdministration(domainresource.DomainResource):
    """ Administration of medication to a patient.

    Describes the event of a patient consuming or otherwise being administered
    a medication.  This may be as simple as swallowing a tablet or it may be a
    long running infusion.  Related resources tie this event to the authorizing
    prescription, and the specific encounter between patient and health care
    practitioner.
    """

    resource_type = "MedicationAdministration"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.category = None
        """ Type of medication usage.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.context = None
        """ Encounter or Episode of Care administered as part of.
        Type `FHIRReference` referencing `Encounter, EpisodeOfCare` (represented as `dict` in JSON). """

        self.definition = None
        """ Instantiates protocol or definition.
        List of `FHIRReference` items referencing `PlanDefinition, ActivityDefinition` (represented as `dict` in JSON). """

        self.device = None
        """ Device used to administer.
        List of `FHIRReference` items referencing `Device` (represented as `dict` in JSON). """

        self.dosage = None
        """ Details of how medication was taken.
        Type `MedicationAdministrationDosage` (represented as `dict` in JSON). """

        self.effectiveDateTime = None
        """ Start and end time of administration.
        Type `FHIRDate` (represented as `str` in JSON). """

        self.effectivePeriod = None
        """ Start and end time of administration.
        Type `Period` (represented as `dict` in JSON). """

        self.eventHistory = None
        """ A list of events of interest in the lifecycle.
        List of `FHIRReference` items referencing `Provenance` (represented as `dict` in JSON). """

        self.identifier = None
        """ External identifier.
        List of `Identifier` items (represented as `dict` in JSON). """

        self.medicationCodeableConcept = None
        """ What was administered.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.medicationReference = None
        """ What was administered.
        Type `FHIRReference` referencing `Medication` (represented as `dict` in JSON). """

        self.notGiven = None
        """ True if medication not administered.
        Type `bool`. """

        self.note = None
        """ Information about the administration.
        List of `Annotation` items (represented as `dict` in JSON). """

        self.partOf = None
        """ Part of referenced event.
        List of `FHIRReference` items referencing `MedicationAdministration, Procedure` (represented as `dict` in JSON). """

        self.performer = None
        """ Who administered substance.
        List of `MedicationAdministrationPerformer` items (represented as `dict` in JSON). """

        self.prescription = None
        """ Request administration performed against.
        Type `FHIRReference` referencing `MedicationRequest` (represented as `dict` in JSON). """

        self.reasonCode = None
        """ Reason administration performed.
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        self.reasonNotGiven = None
        """ Reason administration not performed.
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        self.reasonReference = None
        """ Condition or Observation that supports why the medication was
        administered.
        List of `FHIRReference` items referencing `Condition, Observation` (represented as `dict` in JSON). """

        self.status = None
        """ in-progress | on-hold | completed | entered-in-error | stopped |
        unknown.
        Type `str`. """

        self.subject = None
        """ Who received medication.
        Type `FHIRReference` referencing `Patient, Group` (represented as `dict` in JSON). """

        self.supportingInformation = None
        """ Additional information to support administration.
        List of `FHIRReference` items referencing `Resource` (represented as `dict` in JSON). """

        super(MedicationAdministration, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(MedicationAdministration, self).elementProperties()
        js.extend([
            ("category", "category", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("context", "context", fhirreference.FHIRReference, "Reference", False, None, False),
            ("definition", "definition", fhirreference.FHIRReference, "Reference", True, None, False),
            ("device", "device", fhirreference.FHIRReference, "Reference", True, None, False),
            ("dosage", "dosage", MedicationAdministrationDosage, "MedicationAdministrationDosage", False, None, False),
            ("effectiveDateTime", "effectiveDateTime", fhirdate.FHIRDate, "dateTime", False, "effective", True),
            ("effectivePeriod", "effectivePeriod", period.Period, "Period", False, "effective", True),
            ("eventHistory", "eventHistory", fhirreference.FHIRReference, "Reference", True, None, False),
            ("identifier", "identifier", identifier.Identifier, "Identifier", True, None, False),
            ("medicationCodeableConcept", "medicationCodeableConcept", codeableconcept.CodeableConcept, "CodeableConcept", False, "medication", True),
            ("medicationReference", "medicationReference", fhirreference.FHIRReference, "Reference", False, "medication", True),
            ("notGiven", "notGiven", bool, "boolean", False, None, False),
            ("note", "note", annotation.Annotation, "Annotation", True, None, False),
            ("partOf", "partOf", fhirreference.FHIRReference, "Reference", True, None, False),
            ("performer", "performer", MedicationAdministrationPerformer, "MedicationAdministrationPerformer", True, None, False),
            ("prescription", "prescription", fhirreference.FHIRReference, "Reference", False, None, False),
            ("reasonCode", "reasonCode", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
            ("reasonNotGiven", "reasonNotGiven", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
            ("reasonReference", "reasonReference", fhirreference.FHIRReference, "Reference", True, None, False),
            ("status", "status", str, "code", False, None, True),
            ("subject", "subject", fhirreference.FHIRReference, "Reference", False, None, True),
            ("supportingInformation", "supportingInformation", fhirreference.FHIRReference, "Reference", True, None, False),
        ])
        return js


from . import backboneelement

class MedicationAdministrationDosage(backboneelement.BackboneElement):
    """ Details of how medication was taken.

    Describes the medication dosage information details e.g. dose, rate, site,
    route, etc.
    """

    resource_type = "MedicationAdministrationDosage"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.dose = None
        """ Amount of medication per dose.
        Type `Quantity` (represented as `dict` in JSON). """

        self.method = None
        """ How drug was administered.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.rateQuantity = None
        """ Dose quantity per unit of time.
        Type `Quantity` (represented as `dict` in JSON). """

        self.rateRatio = None
        """ Dose quantity per unit of time.
        Type `Ratio` (represented as `dict` in JSON). """

        self.route = None
        """ Path of substance into body.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.site = None
        """ Body site administered to.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.text = None
        """ Free text dosage instructions e.g. SIG.
        Type `str`. """

        super(MedicationAdministrationDosage, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(MedicationAdministrationDosage, self).elementProperties()
        js.extend([
            ("dose", "dose", quantity.Quantity, "Quantity", False, None, False),
            ("method", "method", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("rateQuantity", "rateQuantity", quantity.Quantity, "Quantity", False, "rate", False),
            ("rateRatio", "rateRatio", ratio.Ratio, "Ratio", False, "rate", False),
            ("route", "route", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("site", "site", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("text", "text", str, "string", False, None, False),
        ])
        return js


class MedicationAdministrationPerformer(backboneelement.BackboneElement):
    """ Who administered substance.

    The individual who was responsible for giving the medication to the
    patient.
    """

    resource_type = "MedicationAdministrationPerformer"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.actor = None
        """ Individual who was performing.
        Type `FHIRReference` referencing `Practitioner, Patient, RelatedPerson, Device` (represented as `dict` in JSON). """

        self.onBehalfOf = None
        """ Organization organization was acting for.
        Type `FHIRReference` referencing `Organization` (represented as `dict` in JSON). """

        super(MedicationAdministrationPerformer, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(MedicationAdministrationPerformer, self).elementProperties()
        js.extend([
            ("actor", "actor", fhirreference.FHIRReference, "Reference", False, None, True),
            ("onBehalfOf", "onBehalfOf", fhirreference.FHIRReference, "Reference", False, None, False),
        ])
        return js


import sys
try:
    from . import annotation
except ImportError:
    annotation = sys.modules[__package__ + '.annotation']
try:
    from . import codeableconcept
except ImportError:
    codeableconcept = sys.modules[__package__ + '.codeableconcept']
try:
    from . import fhirdate
except ImportError:
    fhirdate = sys.modules[__package__ + '.fhirdate']
try:
    from . import fhirreference
except ImportError:
    fhirreference = sys.modules[__package__ + '.fhirreference']
try:
    from . import identifier
except ImportError:
    identifier = sys.modules[__package__ + '.identifier']
try:
    from . import period
except ImportError:
    period = sys.modules[__package__ + '.period']
try:
    from . import quantity
except ImportError:
    quantity = sys.modules[__package__ + '.quantity']
try:
    from . import ratio
except ImportError:
    ratio = sys.modules[__package__ + '.ratio']
