#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 3.0.1.11917 (http://hl7.org/fhir/StructureDefinition/DocumentReference) on 2019-05-13.
#  2019, SMART Health IT.


from . import domainresource

class DocumentReference(domainresource.DomainResource):
    """ A reference to a document.
    """

    resource_type = "DocumentReference"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.authenticator = None
        """ Who/what authenticated the document.
        Type `FHIRReference` referencing `Practitioner, Organization` (represented as `dict` in JSON). """

        self.author = None
        """ Who and/or what authored the document.
        List of `FHIRReference` items referencing `Practitioner, Organization, Device, Patient, RelatedPerson` (represented as `dict` in JSON). """

        self.class_fhir = None
        """ Categorization of document.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.content = None
        """ Document referenced.
        List of `DocumentReferenceContent` items (represented as `dict` in JSON). """

        self.context = None
        """ Clinical context of document.
        Type `DocumentReferenceContext` (represented as `dict` in JSON). """

        self.created = None
        """ Document creation time.
        Type `FHIRDate` (represented as `str` in JSON). """

        self.custodian = None
        """ Organization which maintains the document.
        Type `FHIRReference` referencing `Organization` (represented as `dict` in JSON). """

        self.description = None
        """ Human-readable description (title).
        Type `str`. """

        self.docStatus = None
        """ preliminary | final | appended | amended | entered-in-error.
        Type `str`. """

        self.identifier = None
        """ Other identifiers for the document.
        List of `Identifier` items (represented as `dict` in JSON). """

        self.indexed = None
        """ When this document reference was created.
        Type `FHIRDate` (represented as `str` in JSON). """

        self.masterIdentifier = None
        """ Master Version Specific Identifier.
        Type `Identifier` (represented as `dict` in JSON). """

        self.relatesTo = None
        """ Relationships to other documents.
        List of `DocumentReferenceRelatesTo` items (represented as `dict` in JSON). """

        self.securityLabel = None
        """ Document security-tags.
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        self.status = None
        """ current | superseded | entered-in-error.
        Type `str`. """

        self.subject = None
        """ Who/what is the subject of the document.
        Type `FHIRReference` referencing `Patient, Practitioner, Group, Device` (represented as `dict` in JSON). """

        self.type = None
        """ Kind of document (LOINC if possible).
        Type `CodeableConcept` (represented as `dict` in JSON). """

        super(DocumentReference, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(DocumentReference, self).elementProperties()
        js.extend([
            ("authenticator", "authenticator", fhirreference.FHIRReference, "Reference", False, None, False),
            ("author", "author", fhirreference.FHIRReference, "Reference", True, None, False),
            ("class_fhir", "class", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("content", "content", DocumentReferenceContent, "DocumentReferenceContent", True, None, True),
            ("context", "context", DocumentReferenceContext, "DocumentReferenceContext", False, None, False),
            ("created", "created", fhirdate.FHIRDate, "dateTime", False, None, False),
            ("custodian", "custodian", fhirreference.FHIRReference, "Reference", False, None, False),
            ("description", "description", str, "string", False, None, False),
            ("docStatus", "docStatus", str, "code", False, None, False),
            ("identifier", "identifier", identifier.Identifier, "Identifier", True, None, False),
            ("indexed", "indexed", fhirdate.FHIRDate, "instant", False, None, True),
            ("masterIdentifier", "masterIdentifier", identifier.Identifier, "Identifier", False, None, False),
            ("relatesTo", "relatesTo", DocumentReferenceRelatesTo, "DocumentReferenceRelatesTo", True, None, False),
            ("securityLabel", "securityLabel", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
            ("status", "status", str, "code", False, None, True),
            ("subject", "subject", fhirreference.FHIRReference, "Reference", False, None, False),
            ("type", "type", codeableconcept.CodeableConcept, "CodeableConcept", False, None, True),
        ])
        return js


from . import backboneelement

class DocumentReferenceContent(backboneelement.BackboneElement):
    """ Document referenced.

    The document and format referenced. There may be multiple content element
    repetitions, each with a different format.
    """

    resource_type = "DocumentReferenceContent"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.attachment = None
        """ Where to access the document.
        Type `Attachment` (represented as `dict` in JSON). """

        self.format = None
        """ Format/content rules for the document.
        Type `Coding` (represented as `dict` in JSON). """

        super(DocumentReferenceContent, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(DocumentReferenceContent, self).elementProperties()
        js.extend([
            ("attachment", "attachment", attachment.Attachment, "Attachment", False, None, True),
            ("format", "format", coding.Coding, "Coding", False, None, False),
        ])
        return js


class DocumentReferenceContext(backboneelement.BackboneElement):
    """ Clinical context of document.

    The clinical context in which the document was prepared.
    """

    resource_type = "DocumentReferenceContext"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.encounter = None
        """ Context of the document  content.
        Type `FHIRReference` referencing `Encounter` (represented as `dict` in JSON). """

        self.event = None
        """ Main clinical acts documented.
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        self.facilityType = None
        """ Kind of facility where patient was seen.
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.period = None
        """ Time of service that is being documented.
        Type `Period` (represented as `dict` in JSON). """

        self.practiceSetting = None
        """ Additional details about where the content was created (e.g.
        clinical specialty).
        Type `CodeableConcept` (represented as `dict` in JSON). """

        self.related = None
        """ Related identifiers or resources.
        List of `DocumentReferenceContextRelated` items (represented as `dict` in JSON). """

        self.sourcePatientInfo = None
        """ Patient demographics from source.
        Type `FHIRReference` referencing `Patient` (represented as `dict` in JSON). """

        super(DocumentReferenceContext, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(DocumentReferenceContext, self).elementProperties()
        js.extend([
            ("encounter", "encounter", fhirreference.FHIRReference, "Reference", False, None, False),
            ("event", "event", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
            ("facilityType", "facilityType", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("period", "period", period.Period, "Period", False, None, False),
            ("practiceSetting", "practiceSetting", codeableconcept.CodeableConcept, "CodeableConcept", False, None, False),
            ("related", "related", DocumentReferenceContextRelated, "DocumentReferenceContextRelated", True, None, False),
            ("sourcePatientInfo", "sourcePatientInfo", fhirreference.FHIRReference, "Reference", False, None, False),
        ])
        return js


class DocumentReferenceContextRelated(backboneelement.BackboneElement):
    """ Related identifiers or resources.

    Related identifiers or resources associated with the DocumentReference.
    """

    resource_type = "DocumentReferenceContextRelated"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.identifier = None
        """ Identifier of related objects or events.
        Type `Identifier` (represented as `dict` in JSON). """

        self.ref = None
        """ Related Resource.
        Type `FHIRReference` referencing `Resource` (represented as `dict` in JSON). """

        super(DocumentReferenceContextRelated, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(DocumentReferenceContextRelated, self).elementProperties()
        js.extend([
            ("identifier", "identifier", identifier.Identifier, "Identifier", False, None, False),
            ("ref", "ref", fhirreference.FHIRReference, "Reference", False, None, False),
        ])
        return js


class DocumentReferenceRelatesTo(backboneelement.BackboneElement):
    """ Relationships to other documents.

    Relationships that this document has with other document references that
    already exist.
    """

    resource_type = "DocumentReferenceRelatesTo"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.code = None
        """ replaces | transforms | signs | appends.
        Type `str`. """

        self.target = None
        """ Target of the relationship.
        Type `FHIRReference` referencing `DocumentReference` (represented as `dict` in JSON). """

        super(DocumentReferenceRelatesTo, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(DocumentReferenceRelatesTo, self).elementProperties()
        js.extend([
            ("code", "code", str, "code", False, None, True),
            ("target", "target", fhirreference.FHIRReference, "Reference", False, None, True),
        ])
        return js


import sys
try:
    from . import attachment
except ImportError:
    attachment = sys.modules[__package__ + '.attachment']
try:
    from . import codeableconcept
except ImportError:
    codeableconcept = sys.modules[__package__ + '.codeableconcept']
try:
    from . import coding
except ImportError:
    coding = sys.modules[__package__ + '.coding']
try:
    from . import fhirdate
except ImportError:
    fhirdate = sys.modules[__package__ + '.fhirdate']
try:
    from . import fhirreference
except ImportError:
    fhirreference = sys.modules[__package__ + '.fhirreference']
try:
    from . import identifier
except ImportError:
    identifier = sys.modules[__package__ + '.identifier']
try:
    from . import period
except ImportError:
    period = sys.modules[__package__ + '.period']
