#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 3.0.1.11917 (http://hl7.org/fhir/StructureDefinition/CapabilityStatement) on 2019-05-13.
#  2019, SMART Health IT.


from . import domainresource

class CapabilityStatement(domainresource.DomainResource):
    """ A statement of system capabilities.

    A Capability Statement documents a set of capabilities (behaviors) of a
    FHIR Server that may be used as a statement of actual server functionality
    or a statement of required or desired server implementation.
    """

    resource_type = "CapabilityStatement"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.acceptUnknown = None
        """ no | extensions | elements | both.
        Type `str`. """

        self.contact = None
        """ Contact details for the publisher.
        List of `ContactDetail` items (represented as `dict` in JSON). """

        self.copyright = None
        """ Use and/or publishing restrictions.
        Type `str`. """

        self.date = None
        """ Date this was last changed.
        Type `FHIRDate` (represented as `str` in JSON). """

        self.description = None
        """ Natural language description of the capability statement.
        Type `str`. """

        self.document = None
        """ Document definition.
        List of `CapabilityStatementDocument` items (represented as `dict` in JSON). """

        self.experimental = None
        """ For testing purposes, not real usage.
        Type `bool`. """

        self.fhirVersion = None
        """ FHIR Version the system uses.
        Type `str`. """

        self.format = None
        """ formats supported (xml | json | ttl | mime type).
        List of `str` items. """

        self.implementation = None
        """ If this describes a specific instance.
        Type `CapabilityStatementImplementation` (represented as `dict` in JSON). """

        self.implementationGuide = None
        """ Implementation guides supported.
        List of `str` items. """

        self.instantiates = None
        """ Canonical URL of another capability statement this implements.
        List of `str` items. """

        self.jurisdiction = None
        """ Intended jurisdiction for capability statement (if applicable).
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        self.kind = None
        """ instance | capability | requirements.
        Type `str`. """

        self.messaging = None
        """ If messaging is supported.
        List of `CapabilityStatementMessaging` items (represented as `dict` in JSON). """

        self.name = None
        """ Name for this capability statement (computer friendly).
        Type `str`. """

        self.patchFormat = None
        """ Patch formats supported.
        List of `str` items. """

        self.profile = None
        """ Profiles for use cases supported.
        List of `FHIRReference` items referencing `StructureDefinition` (represented as `dict` in JSON). """

        self.publisher = None
        """ Name of the publisher (organization or individual).
        Type `str`. """

        self.purpose = None
        """ Why this capability statement is defined.
        Type `str`. """

        self.rest = None
        """ If the endpoint is a RESTful one.
        List of `CapabilityStatementRest` items (represented as `dict` in JSON). """

        self.software = None
        """ Software that is covered by this capability statement.
        Type `CapabilityStatementSoftware` (represented as `dict` in JSON). """

        self.status = None
        """ draft | active | retired | unknown.
        Type `str`. """

        self.title = None
        """ Name for this capability statement (human friendly).
        Type `str`. """

        self.url = None
        """ Logical URI to reference this capability statement (globally
        unique).
        Type `str`. """

        self.useContext = None
        """ Context the content is intended to support.
        List of `UsageContext` items (represented as `dict` in JSON). """

        self.version = None
        """ Business version of the capability statement.
        Type `str`. """

        super(CapabilityStatement, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatement, self).elementProperties()
        js.extend([
            ("acceptUnknown", "acceptUnknown", str, "code", False, None, True),
            ("contact", "contact", contactdetail.ContactDetail, "ContactDetail", True, None, False),
            ("copyright", "copyright", str, "markdown", False, None, False),
            ("date", "date", fhirdate.FHIRDate, "dateTime", False, None, True),
            ("description", "description", str, "markdown", False, None, False),
            ("document", "document", CapabilityStatementDocument, "CapabilityStatementDocument", True, None, False),
            ("experimental", "experimental", bool, "boolean", False, None, False),
            ("fhirVersion", "fhirVersion", str, "id", False, None, True),
            ("format", "format", str, "code", True, None, True),
            ("implementation", "implementation", CapabilityStatementImplementation, "CapabilityStatementImplementation", False, None, False),
            ("implementationGuide", "implementationGuide", str, "uri", True, None, False),
            ("instantiates", "instantiates", str, "uri", True, None, False),
            ("jurisdiction", "jurisdiction", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
            ("kind", "kind", str, "code", False, None, True),
            ("messaging", "messaging", CapabilityStatementMessaging, "CapabilityStatementMessaging", True, None, False),
            ("name", "name", str, "string", False, None, False),
            ("patchFormat", "patchFormat", str, "code", True, None, False),
            ("profile", "profile", fhirreference.FHIRReference, "Reference", True, None, False),
            ("publisher", "publisher", str, "string", False, None, False),
            ("purpose", "purpose", str, "markdown", False, None, False),
            ("rest", "rest", CapabilityStatementRest, "CapabilityStatementRest", True, None, False),
            ("software", "software", CapabilityStatementSoftware, "CapabilityStatementSoftware", False, None, False),
            ("status", "status", str, "code", False, None, True),
            ("title", "title", str, "string", False, None, False),
            ("url", "url", str, "uri", False, None, False),
            ("useContext", "useContext", usagecontext.UsageContext, "UsageContext", True, None, False),
            ("version", "version", str, "string", False, None, False),
        ])
        return js


from . import backboneelement

class CapabilityStatementDocument(backboneelement.BackboneElement):
    """ Document definition.

    A document definition.
    """

    resource_type = "CapabilityStatementDocument"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.documentation = None
        """ Description of document support.
        Type `str`. """

        self.mode = None
        """ producer | consumer.
        Type `str`. """

        self.profile = None
        """ Constraint on a resource used in the document.
        Type `FHIRReference` referencing `StructureDefinition` (represented as `dict` in JSON). """

        super(CapabilityStatementDocument, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementDocument, self).elementProperties()
        js.extend([
            ("documentation", "documentation", str, "string", False, None, False),
            ("mode", "mode", str, "code", False, None, True),
            ("profile", "profile", fhirreference.FHIRReference, "Reference", False, None, True),
        ])
        return js


class CapabilityStatementImplementation(backboneelement.BackboneElement):
    """ If this describes a specific instance.

    Identifies a specific implementation instance that is described by the
    capability statement - i.e. a particular installation, rather than the
    capabilities of a software program.
    """

    resource_type = "CapabilityStatementImplementation"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.description = None
        """ Describes this specific instance.
        Type `str`. """

        self.url = None
        """ Base URL for the installation.
        Type `str`. """

        super(CapabilityStatementImplementation, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementImplementation, self).elementProperties()
        js.extend([
            ("description", "description", str, "string", False, None, True),
            ("url", "url", str, "uri", False, None, False),
        ])
        return js


class CapabilityStatementMessaging(backboneelement.BackboneElement):
    """ If messaging is supported.

    A description of the messaging capabilities of the solution.
    """

    resource_type = "CapabilityStatementMessaging"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.documentation = None
        """ Messaging interface behavior details.
        Type `str`. """

        self.endpoint = None
        """ Where messages should be sent.
        List of `CapabilityStatementMessagingEndpoint` items (represented as `dict` in JSON). """

        self.event = None
        """ Declare support for this event.
        List of `CapabilityStatementMessagingEvent` items (represented as `dict` in JSON). """

        self.reliableCache = None
        """ Reliable Message Cache Length (min).
        Type `int`. """

        self.supportedMessage = None
        """ Messages supported by this system.
        List of `CapabilityStatementMessagingSupportedMessage` items (represented as `dict` in JSON). """

        super(CapabilityStatementMessaging, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementMessaging, self).elementProperties()
        js.extend([
            ("documentation", "documentation", str, "string", False, None, False),
            ("endpoint", "endpoint", CapabilityStatementMessagingEndpoint, "CapabilityStatementMessagingEndpoint", True, None, False),
            ("event", "event", CapabilityStatementMessagingEvent, "CapabilityStatementMessagingEvent", True, None, False),
            ("reliableCache", "reliableCache", int, "unsignedInt", False, None, False),
            ("supportedMessage", "supportedMessage", CapabilityStatementMessagingSupportedMessage, "CapabilityStatementMessagingSupportedMessage", True, None, False),
        ])
        return js


class CapabilityStatementMessagingEndpoint(backboneelement.BackboneElement):
    """ Where messages should be sent.

    An endpoint (network accessible address) to which messages and/or replies
    are to be sent.
    """

    resource_type = "CapabilityStatementMessagingEndpoint"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.address = None
        """ Network address or identifier of the end-point.
        Type `str`. """

        self.protocol = None
        """ http | ftp | mllp +.
        Type `Coding` (represented as `dict` in JSON). """

        super(CapabilityStatementMessagingEndpoint, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementMessagingEndpoint, self).elementProperties()
        js.extend([
            ("address", "address", str, "uri", False, None, True),
            ("protocol", "protocol", coding.Coding, "Coding", False, None, True),
        ])
        return js


class CapabilityStatementMessagingEvent(backboneelement.BackboneElement):
    """ Declare support for this event.

    A description of the solution's support for an event at this end-point.
    """

    resource_type = "CapabilityStatementMessagingEvent"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.category = None
        """ Consequence | Currency | Notification.
        Type `str`. """

        self.code = None
        """ Event type.
        Type `Coding` (represented as `dict` in JSON). """

        self.documentation = None
        """ Endpoint-specific event documentation.
        Type `str`. """

        self.focus = None
        """ Resource that's focus of message.
        Type `str`. """

        self.mode = None
        """ sender | receiver.
        Type `str`. """

        self.request = None
        """ Profile that describes the request.
        Type `FHIRReference` referencing `StructureDefinition` (represented as `dict` in JSON). """

        self.response = None
        """ Profile that describes the response.
        Type `FHIRReference` referencing `StructureDefinition` (represented as `dict` in JSON). """

        super(CapabilityStatementMessagingEvent, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementMessagingEvent, self).elementProperties()
        js.extend([
            ("category", "category", str, "code", False, None, False),
            ("code", "code", coding.Coding, "Coding", False, None, True),
            ("documentation", "documentation", str, "string", False, None, False),
            ("focus", "focus", str, "code", False, None, True),
            ("mode", "mode", str, "code", False, None, True),
            ("request", "request", fhirreference.FHIRReference, "Reference", False, None, True),
            ("response", "response", fhirreference.FHIRReference, "Reference", False, None, True),
        ])
        return js


class CapabilityStatementMessagingSupportedMessage(backboneelement.BackboneElement):
    """ Messages supported by this system.

    References to message definitions for messages this system can send or
    receive.
    """

    resource_type = "CapabilityStatementMessagingSupportedMessage"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.definition = None
        """ Message supported by this system.
        Type `FHIRReference` referencing `MessageDefinition` (represented as `dict` in JSON). """

        self.mode = None
        """ sender | receiver.
        Type `str`. """

        super(CapabilityStatementMessagingSupportedMessage, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementMessagingSupportedMessage, self).elementProperties()
        js.extend([
            ("definition", "definition", fhirreference.FHIRReference, "Reference", False, None, True),
            ("mode", "mode", str, "code", False, None, True),
        ])
        return js


class CapabilityStatementRest(backboneelement.BackboneElement):
    """ If the endpoint is a RESTful one.

    A definition of the restful capabilities of the solution, if any.
    """

    resource_type = "CapabilityStatementRest"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.compartment = None
        """ Compartments served/used by system.
        List of `str` items. """

        self.documentation = None
        """ General description of implementation.
        Type `str`. """

        self.interaction = None
        """ What operations are supported?.
        List of `CapabilityStatementRestInteraction` items (represented as `dict` in JSON). """

        self.mode = None
        """ client | server.
        Type `str`. """

        self.operation = None
        """ Definition of an operation or a custom query.
        List of `CapabilityStatementRestOperation` items (represented as `dict` in JSON). """

        self.resource = None
        """ Resource served on the REST interface.
        List of `CapabilityStatementRestResource` items (represented as `dict` in JSON). """

        self.searchParam = None
        """ Search parameters for searching all resources.
        List of `CapabilityStatementRestResourceSearchParam` items (represented as `dict` in JSON). """

        self.security = None
        """ Information about security of implementation.
        Type `CapabilityStatementRestSecurity` (represented as `dict` in JSON). """

        super(CapabilityStatementRest, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementRest, self).elementProperties()
        js.extend([
            ("compartment", "compartment", str, "uri", True, None, False),
            ("documentation", "documentation", str, "string", False, None, False),
            ("interaction", "interaction", CapabilityStatementRestInteraction, "CapabilityStatementRestInteraction", True, None, False),
            ("mode", "mode", str, "code", False, None, True),
            ("operation", "operation", CapabilityStatementRestOperation, "CapabilityStatementRestOperation", True, None, False),
            ("resource", "resource", CapabilityStatementRestResource, "CapabilityStatementRestResource", True, None, False),
            ("searchParam", "searchParam", CapabilityStatementRestResourceSearchParam, "CapabilityStatementRestResourceSearchParam", True, None, False),
            ("security", "security", CapabilityStatementRestSecurity, "CapabilityStatementRestSecurity", False, None, False),
        ])
        return js


class CapabilityStatementRestInteraction(backboneelement.BackboneElement):
    """ What operations are supported?.

    A specification of restful operations supported by the system.
    """

    resource_type = "CapabilityStatementRestInteraction"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.code = None
        """ transaction | batch | search-system | history-system.
        Type `str`. """

        self.documentation = None
        """ Anything special about operation behavior.
        Type `str`. """

        super(CapabilityStatementRestInteraction, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementRestInteraction, self).elementProperties()
        js.extend([
            ("code", "code", str, "code", False, None, True),
            ("documentation", "documentation", str, "string", False, None, False),
        ])
        return js


class CapabilityStatementRestOperation(backboneelement.BackboneElement):
    """ Definition of an operation or a custom query.

    Definition of an operation or a named query together with its parameters
    and their meaning and type.
    """

    resource_type = "CapabilityStatementRestOperation"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.definition = None
        """ The defined operation/query.
        Type `FHIRReference` referencing `OperationDefinition` (represented as `dict` in JSON). """

        self.name = None
        """ Name by which the operation/query is invoked.
        Type `str`. """

        super(CapabilityStatementRestOperation, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementRestOperation, self).elementProperties()
        js.extend([
            ("definition", "definition", fhirreference.FHIRReference, "Reference", False, None, True),
            ("name", "name", str, "string", False, None, True),
        ])
        return js


class CapabilityStatementRestResource(backboneelement.BackboneElement):
    """ Resource served on the REST interface.

    A specification of the restful capabilities of the solution for a specific
    resource type.
    """

    resource_type = "CapabilityStatementRestResource"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.conditionalCreate = None
        """ If allows/uses conditional create.
        Type `bool`. """

        self.conditionalDelete = None
        """ not-supported | single | multiple - how conditional delete is
        supported.
        Type `str`. """

        self.conditionalRead = None
        """ not-supported | modified-since | not-match | full-support.
        Type `str`. """

        self.conditionalUpdate = None
        """ If allows/uses conditional update.
        Type `bool`. """

        self.documentation = None
        """ Additional information about the use of the resource type.
        Type `str`. """

        self.interaction = None
        """ What operations are supported?.
        List of `CapabilityStatementRestResourceInteraction` items (represented as `dict` in JSON). """

        self.profile = None
        """ Base System profile for all uses of resource.
        Type `FHIRReference` referencing `StructureDefinition` (represented as `dict` in JSON). """

        self.readHistory = None
        """ Whether vRead can return past versions.
        Type `bool`. """

        self.referencePolicy = None
        """ literal | logical | resolves | enforced | local.
        List of `str` items. """

        self.searchInclude = None
        """ _include values supported by the server.
        List of `str` items. """

        self.searchParam = None
        """ Search parameters supported by implementation.
        List of `CapabilityStatementRestResourceSearchParam` items (represented as `dict` in JSON). """

        self.searchRevInclude = None
        """ _revinclude values supported by the server.
        List of `str` items. """

        self.type = None
        """ A resource type that is supported.
        Type `str`. """

        self.updateCreate = None
        """ If update can commit to a new identity.
        Type `bool`. """

        self.versioning = None
        """ no-version | versioned | versioned-update.
        Type `str`. """

        super(CapabilityStatementRestResource, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementRestResource, self).elementProperties()
        js.extend([
            ("conditionalCreate", "conditionalCreate", bool, "boolean", False, None, False),
            ("conditionalDelete", "conditionalDelete", str, "code", False, None, False),
            ("conditionalRead", "conditionalRead", str, "code", False, None, False),
            ("conditionalUpdate", "conditionalUpdate", bool, "boolean", False, None, False),
            ("documentation", "documentation", str, "markdown", False, None, False),
            ("interaction", "interaction", CapabilityStatementRestResourceInteraction, "CapabilityStatementRestResourceInteraction", True, None, True),
            ("profile", "profile", fhirreference.FHIRReference, "Reference", False, None, False),
            ("readHistory", "readHistory", bool, "boolean", False, None, False),
            ("referencePolicy", "referencePolicy", str, "code", True, None, False),
            ("searchInclude", "searchInclude", str, "string", True, None, False),
            ("searchParam", "searchParam", CapabilityStatementRestResourceSearchParam, "CapabilityStatementRestResourceSearchParam", True, None, False),
            ("searchRevInclude", "searchRevInclude", str, "string", True, None, False),
            ("type", "type", str, "code", False, None, True),
            ("updateCreate", "updateCreate", bool, "boolean", False, None, False),
            ("versioning", "versioning", str, "code", False, None, False),
        ])
        return js


class CapabilityStatementRestResourceInteraction(backboneelement.BackboneElement):
    """ What operations are supported?.

    Identifies a restful operation supported by the solution.
    """

    resource_type = "CapabilityStatementRestResourceInteraction"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.code = None
        """ read | vread | update | patch | delete | history-instance |
        history-type | create | search-type.
        Type `str`. """

        self.documentation = None
        """ Anything special about operation behavior.
        Type `str`. """

        super(CapabilityStatementRestResourceInteraction, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementRestResourceInteraction, self).elementProperties()
        js.extend([
            ("code", "code", str, "code", False, None, True),
            ("documentation", "documentation", str, "string", False, None, False),
        ])
        return js


class CapabilityStatementRestResourceSearchParam(backboneelement.BackboneElement):
    """ Search parameters supported by implementation.

    Search parameters for implementations to support and/or make use of -
    either references to ones defined in the specification, or additional ones
    defined for/by the implementation.
    """

    resource_type = "CapabilityStatementRestResourceSearchParam"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.definition = None
        """ Source of definition for parameter.
        Type `str`. """

        self.documentation = None
        """ Server-specific usage.
        Type `str`. """

        self.name = None
        """ Name of search parameter.
        Type `str`. """

        self.type = None
        """ number | date | string | token | reference | composite | quantity |
        uri.
        Type `str`. """

        super(CapabilityStatementRestResourceSearchParam, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementRestResourceSearchParam, self).elementProperties()
        js.extend([
            ("definition", "definition", str, "uri", False, None, False),
            ("documentation", "documentation", str, "string", False, None, False),
            ("name", "name", str, "string", False, None, True),
            ("type", "type", str, "code", False, None, True),
        ])
        return js


class CapabilityStatementRestSecurity(backboneelement.BackboneElement):
    """ Information about security of implementation.

    Information about security implementation from an interface perspective -
    what a client needs to know.
    """

    resource_type = "CapabilityStatementRestSecurity"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.certificate = None
        """ Certificates associated with security profiles.
        List of `CapabilityStatementRestSecurityCertificate` items (represented as `dict` in JSON). """

        self.cors = None
        """ Adds CORS Headers (http://enable-cors.org/).
        Type `bool`. """

        self.description = None
        """ General description of how security works.
        Type `str`. """

        self.service = None
        """ OAuth | SMART-on-FHIR | NTLM | Basic | Kerberos | Certificates.
        List of `CodeableConcept` items (represented as `dict` in JSON). """

        super(CapabilityStatementRestSecurity, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementRestSecurity, self).elementProperties()
        js.extend([
            ("certificate", "certificate", CapabilityStatementRestSecurityCertificate, "CapabilityStatementRestSecurityCertificate", True, None, False),
            ("cors", "cors", bool, "boolean", False, None, False),
            ("description", "description", str, "string", False, None, False),
            ("service", "service", codeableconcept.CodeableConcept, "CodeableConcept", True, None, False),
        ])
        return js


class CapabilityStatementRestSecurityCertificate(backboneelement.BackboneElement):
    """ Certificates associated with security profiles.
    """

    resource_type = "CapabilityStatementRestSecurityCertificate"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.blob = None
        """ Actual certificate.
        Type `str`. """

        self.type = None
        """ Mime type for certificates.
        Type `str`. """

        super(CapabilityStatementRestSecurityCertificate, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementRestSecurityCertificate, self).elementProperties()
        js.extend([
            ("blob", "blob", str, "base64Binary", False, None, False),
            ("type", "type", str, "code", False, None, False),
        ])
        return js


class CapabilityStatementSoftware(backboneelement.BackboneElement):
    """ Software that is covered by this capability statement.

    Software that is covered by this capability statement.  It is used when the
    capability statement describes the capabilities of a particular software
    version, independent of an installation.
    """

    resource_type = "CapabilityStatementSoftware"

    def __init__(self, jsondict=None, strict=True):
        """ Initialize all valid properties.

        :raises: FHIRValidationError on validation errors, unless strict is False
        :param dict jsondict: A JSON dictionary to use for initialization
        :param bool strict: If True (the default), invalid variables will raise a TypeError
        """

        self.name = None
        """ A name the software is known by.
        Type `str`. """

        self.releaseDate = None
        """ Date this version released.
        Type `FHIRDate` (represented as `str` in JSON). """

        self.version = None
        """ Version covered by this statement.
        Type `str`. """

        super(CapabilityStatementSoftware, self).__init__(jsondict=jsondict, strict=strict)

    def elementProperties(self):
        js = super(CapabilityStatementSoftware, self).elementProperties()
        js.extend([
            ("name", "name", str, "string", False, None, True),
            ("releaseDate", "releaseDate", fhirdate.FHIRDate, "dateTime", False, None, False),
            ("version", "version", str, "string", False, None, False),
        ])
        return js


import sys
try:
    from . import codeableconcept
except ImportError:
    codeableconcept = sys.modules[__package__ + '.codeableconcept']
try:
    from . import coding
except ImportError:
    coding = sys.modules[__package__ + '.coding']
try:
    from . import contactdetail
except ImportError:
    contactdetail = sys.modules[__package__ + '.contactdetail']
try:
    from . import fhirdate
except ImportError:
    fhirdate = sys.modules[__package__ + '.fhirdate']
try:
    from . import fhirreference
except ImportError:
    fhirreference = sys.modules[__package__ + '.fhirreference']
try:
    from . import usagecontext
except ImportError:
    usagecontext = sys.modules[__package__ + '.usagecontext']
