# -*- coding: utf-8 -*-

# Copyright (c) 2012 - 2022 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a wizard dialog to enter the synchronization data.
"""

from PyQt6.QtWidgets import QWizard

from eric7.EricGui import EricPixmapCache
from eric7 import Globals


class SyncAssistantDialog(QWizard):
    """
    Class implementing a wizard dialog to enter the synchronization data.
    """

    def __init__(self, parent=None):
        """
        Constructor

        @param parent reference to the parent widget (QWidget)
        """
        super().__init__(parent)

        from . import SyncGlobals

        from .SyncDataPage import SyncDataPage
        from .SyncEncryptionPage import SyncEncryptionPage
        from .SyncHostTypePage import SyncHostTypePage
        from .SyncFtpSettingsPage import SyncFtpSettingsPage
        from .SyncDirectorySettingsPage import SyncDirectorySettingsPage
        from .SyncCheckPage import SyncCheckPage

        self.setPage(SyncGlobals.PageData, SyncDataPage(self))
        self.setPage(SyncGlobals.PageEncryption, SyncEncryptionPage(self))
        self.setPage(SyncGlobals.PageType, SyncHostTypePage(self))
        self.setPage(SyncGlobals.PageFTPSettings, SyncFtpSettingsPage(self))
        self.setPage(SyncGlobals.PageDirectorySettings, SyncDirectorySettingsPage(self))
        self.setPage(SyncGlobals.PageCheck, SyncCheckPage(self))

        self.setPixmap(
            QWizard.WizardPixmap.LogoPixmap, EricPixmapCache.getPixmap("ericWeb48")
        )
        self.setPixmap(
            QWizard.WizardPixmap.WatermarkPixmap, EricPixmapCache.getPixmap("eric256")
        )
        self.setPixmap(
            QWizard.WizardPixmap.BackgroundPixmap, EricPixmapCache.getPixmap("eric256")
        )

        self.setMinimumSize(650, 450)
        if Globals.isWindowsPlatform():
            self.setWizardStyle(QWizard.WizardStyle.ModernStyle)

        self.setOption(QWizard.WizardOption.NoCancelButtonOnLastPage, True)
