# -*- coding: utf-8 -*-

# Copyright (c) 2021 - 2022 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing utility functions for the code style checker dialogs.
"""

from eric7.EricGui import EricPixmapCache


def setItemIcon(itm, column, msgCode, severity=None):
    """
    Function to set the icon of the passed message item.

    @param itm reference to the message item
    @type QTreeWidgetItem
    @param column column for the icon
    @type int
    @param msgCode message code
    @type str
    @param severity severity for message code 'S' (defaults to None)
    @type str (optional)
    """
    if msgCode.startswith(("W", "-", "C", "M")):
        itm.setIcon(column, EricPixmapCache.getIcon("warning"))
    elif msgCode.startswith("E"):
        itm.setIcon(column, EricPixmapCache.getIcon("syntaxError"))
    elif msgCode.startswith(("A", "N")):
        itm.setIcon(column, EricPixmapCache.getIcon("namingError"))
    elif msgCode.startswith("D"):
        itm.setIcon(column, EricPixmapCache.getIcon("docstringError"))
    elif msgCode.startswith("I"):
        itm.setIcon(column, EricPixmapCache.getIcon("imports"))
    elif msgCode.startswith("P"):
        itm.setIcon(column, EricPixmapCache.getIcon("dirClosed"))
    elif msgCode.startswith("Y"):
        itm.setIcon(column, EricPixmapCache.getIcon("filePython"))
    elif msgCode.startswith("S"):
        if severity is None:
            itm.setIcon(column, EricPixmapCache.getIcon("securityLow"))
        else:
            if severity == "H":
                itm.setIcon(column, EricPixmapCache.getIcon("securityLow"))
            elif severity == "M":
                itm.setIcon(column, EricPixmapCache.getIcon("securityMedium"))
            elif severity == "L":
                itm.setIcon(column, EricPixmapCache.getIcon("securityHigh"))
            else:
                itm.setIcon(column, EricPixmapCache.getIcon("securityLow"))
    else:
        # unknown category prefix => warning
        itm.setIcon(column, EricPixmapCache.getIcon("warning"))
