# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['dx',
 'dx.comms',
 'dx.datatypes',
 'dx.formatters',
 'dx.plotting',
 'dx.plotting.dex',
 'dx.types',
 'dx.types.charts',
 'dx.utils']

package_data = \
{'': ['*']}

install_requires = \
['duckdb-engine>=0.6.4,<0.7.0',
 'exceptiongroup>=1.0.4,<2.0.0',
 'ipython>=7.31.1',
 'pandas>=1.3.5,<2.0.0',
 'pydantic>=1.9,<2.0',
 'structlog>=22.1.0,<23.0.0']

extras_require = \
{'docs': ['mkdocs>=1.3.1,<2.0.0',
          'mkdocs-material>=8.3.9,<9.0.0',
          'mkdocs-jupyter>=0.21,<0.23',
          'mkdocstrings>=0.19,<0.21',
          'mkdocstrings-python>=0.7.1,<0.9.0']}

setup_kwargs = {
    'name': 'dx',
    'version': '1.3.0',
    'description': 'Python wrapper for Data Explorer',
    'long_description': '# dx\n\n<p align="center">\nThis package provides convenient formatting and IPython display formatter registration for tabular data and DEX media types.\n</p>\n<p align="center">\n<a href="https://github.com/noteable-io/dx/actions/workflows/ci.yaml">\n    <img src="https://github.com/noteable-io/dx/actions/workflows/ci.yaml/badge.svg" alt="CI" />\n</a>\n<a href="https://codecov.io/gh/noteable-io/dx" > \n <img src="https://codecov.io/gh/noteable-io/dx/branch/main/graph/badge.svg?token=XGXSTD3GSI" alt="codecov code coverage"/> \n </a>\n<img alt="PyPI - License" src="https://img.shields.io/pypi/l/dx" />\n<img alt="PyPI - Python Version" src="https://img.shields.io/pypi/pyversions/dx" />\n<img alt="PyPI" src="https://img.shields.io/pypi/v/dx">\n<a href="https://github.com/psf/black"><img alt="Code style: black" src="https://img.shields.io/badge/code%20style-black-000000.svg"></a>\n</p>\n\n---------\n\nA Pythonic Data Explorer, open sourced with ❤️ by <a href="https://noteable.io">Noteable</a>, a collaborative notebook platform that enables teams to use and visualize data, together.\n\n\n## Requirements\n\nPython 3.8+\n\n## Installation\n\n### Poetry\n\n```shell\npoetry add dx\n```\n\nThen import the package:\n\n```python\nimport dx\n```\n\n### Pip\n```shell\npip install dx\n```\n\nThen import the package:\n\n```python\nimport dx\n```\n\n## Usage\n\nThe `dx` library currently enables DEX media type visualization of pandas `DataFrame` and `Series` objects, as well as numpy `ndarray` objects. This can be handled in two ways:\n- explicit `dx.display()` calls\n- setting the `display_mode` to update the IPython display formatter for a session\n\n### With `dx.display()`\n`dx.display()` will display a single dataset using the DEX media type. It currently supports:\n- pandas `DataFrame` objects\n  ```python\n  import pandas as pd\n  import random\n\n  df = pd.DataFrame({\n      \'random_ints\': [random.randint(0, 100) for _ in range(500)],\n      \'random_floats\': [random.random() for _ in range(500)],\n  })\n  dx.display(df)\n  ```\n  ![](https://raw.githubusercontent.com/noteable-io/dx/main/docs/screenshots/dx_display_sample1.png)\n\n- tabular data as `dict` or `list` types\n  ```python\n  dx.display([\n    [1, 5, 10, 20, 500],\n    [1, 2, 3, 4, 5],\n    [0, 0, 0, 0, 1]\n  ])\n  ```\n  ![](https://raw.githubusercontent.com/noteable-io/dx/main/docs/screenshots/dx_display_sample2.png)\n\n- `.csv` or `.json` filepaths \n  ```python\n  df = dx.random_dataframe()\n  df.to_csv("dx_docs_sample.csv", index=False)\n\n  dx.display("dx_docs_sample.csv")\n  ```\n  ![](https://raw.githubusercontent.com/noteable-io/dx/main/docs/screenshots/dx_display_sample3.png)\n\n### With `dx.set_display_mode()`\nUsing either `"simple"` or `"enhanced"` display modes will allow `dx` will update the current `IPython` display formatters to allow DEX media type visualization of pandas `DataFrame` objects for an entire notebook / kernel session instead of the default `DataFrame` display output.\n\n<details>\n<summary>Details</summary>\n\nThis will adjust pandas options to:\n- increasing the number of rows displayed to `50000` from pandas default of `60`\n- increasing the number of columns displayed to `50` from pandas default of `20`\n- enabling `html.table_schema` (`False` by default in pandas)\n\nThis will also handle some basic column cleaning and generate a schema for the `DataFrame` using `pandas.io.json.build_table_schema`. Depending on the display mode, the data will be transformed into either a list of dictionaries or list of lists of columnar values.\n- `"simple"` - list of dictionaries\n- `"enhanced"` - list of lists\n</details>\n\n> **NOTE:**\n> Unlike `dx.display()`, this **only** affects pandas DataFrames (or any types set in `settings.RENDERABLE_TYPES`); it does not affect the display of `.csv`/`.json` file data, or `dict`/`list` outputs\n\n\n- `dx.set_display_mode("simple")`\n  \n  ```python\n  import dx\n  import numpy as np\n  import pandas as pd\n\n  # enable DEX display outputs from now on\n  dx.set_display_mode("simple")\n\n  df = pd.read_csv("dx_docs_sample.csv")\n  df\n  ```\n  ```python\n  df2 = pd.DataFrame(\n      [\n          [1, 5, 10, 20, 500],\n          [1, 2, 3, np.nan, 5],\n          [0, 0, 0, np.nan, 1]\n      ],\n      columns=[\'a\', \'b\', \'c\', \'d\', \'e\']\n  )\n  df2\n  ```\n  ![](https://raw.githubusercontent.com/noteable-io/dx/main/docs/screenshots/dx_simple_mode_sample1.png)\n\nIf, at any point, you want to go back to the default display formatting (vanilla pandas output), use the `"plain"` display mode. This will revert the IPython display format update to its original state and put the pandas options back to their default values.\n\n- `dx.set_display_mode("plain")`\n  ```python\n  # revert to original pandas display outputs from now on\n  dx.set_display_mode("plain")\n\n  df = pd.read_csv("dx_docs_sample.csv")\n  df\n  ```\n  ```python\n  df2 = pd.DataFrame(\n      [\n          [1, 5, 10, 20, 500],\n          [1, 2, 3, np.nan, 5],\n          [0, 0, 0, np.nan, 1]\n      ],\n      columns=[\'a\', \'b\', \'c\', \'d\', \'e\']\n  )\n  df2\n  ```\n  ![](https://raw.githubusercontent.com/noteable-io/dx/main/docs/screenshots/dx_plain_mode_sample1.png)\n\n\n### Custom Settings\nDefault settings for `dx` can be found by calling `dx.settings`:\n![](https://raw.githubusercontent.com/noteable-io/dx/main/docs/screenshots/dx_settings_sample1.png)\n\nEach can be set using `dx.set_option()`:\n![](https://raw.githubusercontent.com/noteable-io/dx/main/docs/screenshots/dx_settings_sample2.png)\n_Setting `DISPLAY_MAX_ROWS` to `3` for the current session_\n\n...or with the `dx.settings_context()` context manager:\n![](https://raw.githubusercontent.com/noteable-io/dx/main/docs/screenshots/dx_settings_sample3.png)\n_Setting `DISPLAY_MAX_ROWS` to `3` within the current context, leaving options for the rest of the session alone_\n\n### Generating Sample Data\nDocumentation coming soon!\n\n### Usage Outside of Noteable \nIf using this package in a notebook environment outside of [Noteable](https://app.noteable.io/), the frontend should support the following media types:\n- `application/vnd.dataresource+json` for `"simple"` display mode\n- `application/vnd.dex.v1+json` for `"enhanced"` display mode\n## Contributing\n\nSee [CONTRIBUTING.md](https://github.com/noteable-io/dx/blob/main/CONTRIBUTING.md).\n\n## Code of Conduct\n\nWe follow the noteable.io [code of conduct](https://github.com/noteable-io/dx/blob/main/CODE_OF_CONDUCT.md).\n\n## LICENSE\n\nSee [LICENSE.md](https://github.com/noteable-io/dx/blob/main/LICENSE.md).\n\n-------\n\n<p align="center">Open sourced with ❤️ by <a href="https://noteable.io">Noteable</a> for the community.</p>\n\n<img href="https://pages.noteable.io/private-beta-access" src="https://assets.noteable.io/github/2022-07-29/noteable.png" alt="Boost Data Collaboration with Notebooks">',
    'author': 'Dave Shoup',
    'author_email': 'dave.shoup@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://app.noteable.io/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
