"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticRunnerImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild_1 = require("./codebuild");
const common_1 = require("../common");
/**
 * Helper class with methods to use static images that are built outside the context of this project.
 */
class StaticRunnerImage {
    /**
     * Create a builder (that doesn't actually build anything) from an existing image in an existing repository. The image must already have GitHub Actions runner installed. You are responsible to update it and remove it when done.
     *
     * @param repository ECR repository
     * @param tag image tag
     * @param architecture image architecture
     * @param os image OS
     */
    static fromEcrRepository(repository, tag = 'latest', architecture = common_1.Architecture.X86_64, os = common_1.Os.LINUX) {
        return {
            bindDockerImage() {
                return {
                    imageRepository: repository,
                    imageTag: tag,
                    architecture,
                    os,
                    runnerVersion: common_1.RunnerVersion.latest(),
                };
            },
            bindAmi() {
                throw new Error('fromEcrRepository() cannot be used to build AMIs');
            },
        };
    }
    /**
     * Create a builder from an existing Docker Hub image. The image must already have GitHub Actions runner installed. You are responsible to update it and remove it when done.
     *
     * We create a CodeBuild image builder behind the scenes to copy the image over to ECR. This helps avoid Docker Hub rate limits and prevent failures.
     *
     * @param scope
     * @param id
     * @param image Docker Hub image with optional tag
     * @param architecture image architecture
     * @param os image OS
     */
    static fromDockerHub(scope, id, image, architecture = common_1.Architecture.X86_64, os = common_1.Os.LINUX) {
        return new codebuild_1.CodeBuildRunnerImageBuilder(scope, id, {
            os,
            architecture,
            baseDockerImage: image,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
StaticRunnerImage[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.StaticRunnerImage", version: "0.9.0" };
exports.StaticRunnerImage = StaticRunnerImage;
//# sourceMappingURL=data:application/json;base64,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