"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WindowsComponents = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const common_1 = require("../../../common");
const builder_1 = require("../builder");
/**
 * Components for Windows that can be used with AWS Image Builder based builders. These cannot be used by {@link CodeBuildImageBuilder}.
 *
 * @deprecated Use `RunnerImageComponent` instead.
 */
class WindowsComponents {
    static cloudwatchAgent(scope, id) {
        return new builder_1.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'CloudWatch agent',
            description: 'Install latest version of CloudWatch agent for sending logs to CloudWatch',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                'Start-Process msiexec.exe -Wait -ArgumentList \'/i https://s3.amazonaws.com/amazoncloudwatch-agent/windows/amd64/latest/amazon-cloudwatch-agent.msi /qn\'',
            ],
        });
    }
    static awsCli(scope, id) {
        return new builder_1.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'AWS CLI',
            description: 'Install latest version of AWS CLI',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                'Start-Process msiexec.exe -Wait -ArgumentList \'/i https://awscli.amazonaws.com/AWSCLIV2.msi /qn\'',
            ],
        });
    }
    static githubCli(scope, id) {
        return new builder_1.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'GitHub CLI',
            description: 'Install latest version of gh',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/cli/cli/releases/latest > $Env:TEMP\\latest-gh',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-gh',
                '$GH_VERSION = ($LatestUrl -Split \'/\')[-1].substring(1)',
                '$ProgressPreference = \'SilentlyContinue\'',
                'Invoke-WebRequest -UseBasicParsing -Uri "https://github.com/cli/cli/releases/download/v${GH_VERSION}/gh_${GH_VERSION}_windows_amd64.msi" -OutFile gh.msi',
                'Start-Process msiexec.exe -Wait -ArgumentList \'/i gh.msi /qn\'',
                'del gh.msi',
            ],
        });
    }
    static git(scope, id) {
        return new builder_1.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'Git',
            description: 'Install latest version of git',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/git-for-windows/git/releases/latest > $Env:TEMP\\latest-git',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-git',
                '$GIT_VERSION = ($LatestUrl -Split \'/\')[-1].substring(1)',
                '$GIT_VERSION_SHORT = ($GIT_VERSION -Split \'.windows.\')[0]',
                '$GIT_REVISION = ($GIT_VERSION -Split \'.windows.\')[1]',
                'If ($GIT_REVISION -gt 1) {$GIT_VERSION_SHORT = "$GIT_VERSION_SHORT.$GIT_REVISION"}',
                'Invoke-WebRequest -UseBasicParsing -Uri https://github.com/git-for-windows/git/releases/download/v${GIT_VERSION}/Git-${GIT_VERSION_SHORT}-64-bit.exe -OutFile git-setup.exe',
                'Start-Process git-setup.exe -Wait -ArgumentList \'/VERYSILENT\'',
                'del git-setup.exe',
            ],
        });
    }
    static githubRunner(scope, id, runnerVersion) {
        let runnerCommands;
        if (runnerVersion.is(common_1.RunnerVersion.latest())) {
            runnerCommands = [
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/actions/runner/releases/latest > $Env:TEMP\\latest-gha',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-gha',
                '$RUNNER_VERSION = ($LatestUrl -Split \'/\')[-1].substring(1)',
            ];
        }
        else {
            runnerCommands = [`$RUNNER_VERSION = '${runnerVersion.version}'`];
        }
        return new builder_1.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'GitHub Actions Runner',
            description: 'Install latest version of GitHub Actions Runner',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
            ].concat(runnerCommands, [
                'Invoke-WebRequest -UseBasicParsing -Uri "https://github.com/actions/runner/releases/download/v${RUNNER_VERSION}/actions-runner-win-x64-${RUNNER_VERSION}.zip" -OutFile actions.zip',
                'Expand-Archive actions.zip -DestinationPath C:\\actions',
                'del actions.zip',
                `echo ${runnerVersion.version} | Out-File -Encoding ASCII -NoNewline C:\\actions\\RUNNER_VERSION`,
            ]),
        });
    }
    static docker(scope, id) {
        return new builder_1.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'Docker',
            description: 'Install latest version of Docker',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                '$ProgressPreference = \'SilentlyContinue\'',
                'Invoke-WebRequest -UseBasicParsing -Uri https://desktop.docker.com/win/main/amd64/Docker%20Desktop%20Installer.exe -OutFile docker-setup.exe',
                'Start-Process \'docker-setup.exe\' -Wait -ArgumentList \'/install --quiet --accept-license\'',
                'del docker-setup.exe',
                'cmd /c curl -w "%{redirect_url}" -fsS https://github.com/docker/compose/releases/latest > $Env:TEMP\\latest-docker-compose',
                '$LatestUrl = Get-Content $Env:TEMP\\latest-docker-compose',
                '$LatestDockerCompose = ($LatestUrl -Split \'/\')[-1]',
                'Invoke-WebRequest -UseBasicParsing -Uri  "https://github.com/docker/compose/releases/download/${LatestDockerCompose}/docker-compose-Windows-x86_64.exe" -OutFile $Env:ProgramFiles\\Docker\\docker-compose.exe',
                'copy $Env:ProgramFiles\\Docker\\docker-compose.exe $Env:ProgramFiles\\Docker\\cli-plugins\\docker-compose.exe',
            ],
        });
    }
    static extraCertificates(scope, id, path) {
        return new builder_1.ImageBuilderComponent(scope, id, {
            platform: 'Windows',
            displayName: 'Extra certificates',
            description: 'Install self-signed certificates to provide access to GitHub Enterprise Server',
            commands: [
                '$ErrorActionPreference = \'Stop\'',
                'Import-Certificate -FilePath certs\\certs.pem -CertStoreLocation Cert:\\LocalMachine\\Root',
            ],
            assets: [
                {
                    path: 'certs',
                    asset: new aws_cdk_lib_1.aws_s3_assets.Asset(scope, `${id} Asset`, { path }),
                },
            ],
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
WindowsComponents[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.WindowsComponents", version: "0.9.0" };
exports.WindowsComponents = WindowsComponents;
//# sourceMappingURL=data:application/json;base64,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