"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOctokit = exports.baseUrlFromDomain = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const auth_app_1 = require("@octokit/auth-app");
const rest_1 = require("@octokit/rest");
const helpers_1 = require("./helpers");
function baseUrlFromDomain(domain) {
    if (domain == 'github.com') {
        return 'https://api.github.com';
    }
    return `https://${domain}/api/v3`;
}
exports.baseUrlFromDomain = baseUrlFromDomain;
async function getOctokit(installationId) {
    if (!process.env.GITHUB_SECRET_ARN || !process.env.GITHUB_PRIVATE_KEY_SECRET_ARN) {
        throw new Error('Missing environment variables');
    }
    const githubSecrets = await (0, helpers_1.getSecretJsonValue)(process.env.GITHUB_SECRET_ARN);
    let baseUrl = baseUrlFromDomain(githubSecrets.domain);
    let token;
    if (githubSecrets.personalAuthToken) {
        token = githubSecrets.personalAuthToken;
    }
    else {
        const privateKey = await (0, helpers_1.getSecretValue)(process.env.GITHUB_PRIVATE_KEY_SECRET_ARN);
        const appOctokit = new rest_1.Octokit({
            baseUrl,
            authStrategy: auth_app_1.createAppAuth,
            auth: {
                appId: githubSecrets.appId,
                privateKey: privateKey,
            },
        });
        token = (await appOctokit.auth({
            type: 'installation',
            installationId: installationId,
        })).token;
    }
    const octokit = new rest_1.Octokit({
        baseUrl,
        auth: token,
    });
    return {
        githubSecrets,
        octokit,
    };
}
exports.getOctokit = getOctokit;
//# sourceMappingURL=data:application/json;base64,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