# coding: utf-8

"""
    Stitch Connect

    https://www.stitchdata.com/docs/developers/stitch-connect/api  # noqa: E501

    The version of the OpenAPI document: 0.3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from stitch_connect_client.configuration import Configuration


class CreateSourceBody(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "display_name": "str",
        "type": "str",
        "name": "str",
        "properties": "SourceFormProperties",
    }

    attribute_map = {
        "display_name": "display_name",
        "type": "type",
        "name": "name",
        "properties": "properties",
    }

    def __init__(
        self,
        display_name=None,
        type=None,
        name=None,
        properties=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """CreateSourceBody - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._display_name = None
        self._type = None
        self._name = None
        self._properties = None
        self.discriminator = None

        self.display_name = display_name
        self.type = type
        if name is not None:
            self.name = name
        if properties is not None:
            self.properties = properties

    @property
    def display_name(self):
        """Gets the display_name of this CreateSourceBody.  # noqa: E501

        A descriptive name for the source. This will be used to dynamically generate the name corresponding to the schema name or dataset name that the data from this source will be loaded into.   # noqa: E501

        :return: The display_name of this CreateSourceBody.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this CreateSourceBody.

        A descriptive name for the source. This will be used to dynamically generate the name corresponding to the schema name or dataset name that the data from this source will be loaded into.   # noqa: E501

        :param display_name: The display_name of this CreateSourceBody.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and display_name is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `display_name`, must not be `None`"
            )  # noqa: E501

        self._display_name = display_name

    @property
    def type(self):
        """Gets the type of this CreateSourceBody.  # noqa: E501

        The source type. For example: platform.marketo or platform.hubspot.   # noqa: E501

        :return: The type of this CreateSourceBody.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this CreateSourceBody.

        The source type. For example: platform.marketo or platform.hubspot.   # noqa: E501

        :param type: The type of this CreateSourceBody.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and type is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type`, must not be `None`"
            )  # noqa: E501

        self._type = type

    @property
    def name(self):
        """Gets the name of this CreateSourceBody.  # noqa: E501

        The destination schema name that the data from this source will be loaded into. Names must: - Contain only lowercase alphanumerics and underscores - Be unique within each Stitch client account   # noqa: E501

        :return: The name of this CreateSourceBody.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateSourceBody.

        The destination schema name that the data from this source will be loaded into. Names must: - Contain only lowercase alphanumerics and underscores - Be unique within each Stitch client account   # noqa: E501

        :param name: The name of this CreateSourceBody.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def properties(self):
        """Gets the properties of this CreateSourceBody.  # noqa: E501


        :return: The properties of this CreateSourceBody.  # noqa: E501
        :rtype: SourceFormProperties
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this CreateSourceBody.


        :param properties: The properties of this CreateSourceBody.  # noqa: E501
        :type: SourceFormProperties
        """

        self._properties = properties

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateSourceBody):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateSourceBody):
            return True

        return self.to_dict() != other.to_dict()
