# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['songpal']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp', 'async_upnp_client', 'attrs', 'click>=7,<8', 'importlib-metadata']

entry_points = \
{'console_scripts': ['songpal = songpal.main:cli']}

setup_kwargs = {
    'name': 'python-songpal',
    'version': '0.12',
    'description': "Python library for interfacing with Sony's Songpal devices",
    'long_description': "python-songpal\n==============\n\n|PyPI version| |Black|\n\nPython 3 implementation of SongPal protocol as used by Sony's soundbar\nand potentially other devices.\n\n.. NOTE::\n\n  This project is currently at its alpha stage and all contributions,\n  whether reporting about devices working with this or creating pull\n  requests to implement missing functionality are more than welcome!\n\nSupported devices\n-----------------\n\nThe library has been tested to work with following devices:\n\n* BDV-N9200W\n* CMT-SX7B\n* HT-XT2, HT-XT3\n* HT-NT5\n* HT-MT500\n* HT-ZF9\n* HT-ST5000\n* SRS-X77, SRS-X88, SRS-X99\n* STR-DN1060, STR-DN1070, STR-DN1080\n\n\n.. NOTE::\n\n  If your device is not listed here but is working, feel free to contribute a device info file (see devinfos/ directory) by typing `songpal dump-devinfo <filename>` and creating a pull request on this repository. \n  This information can later be useful for extending the support for those devices.\n\n.. NOTE::\n\n  Sony's `Supported devices page <http://vssupport.sony.net/en_ww/device.html>`_ lists devices,\n  which will probably also work with this library.\n\n  If you have a device which is not listed above, please create a pull request\n  or an issue on github!\n\n\nGetting started\n---------------\n\nInstallation\n~~~~~~~~~~~~\n\nThe easiest way to install is by using pip:\n\n.. code-block::\n\n    $ pip install python-songpal\n\nLocating the endpoint\n~~~~~~~~~~~~~~~~~~~~~\n\nTo communicate with the device you need to locate its endpoint URL.\nThe easiest way to do is to execute the discover command:\n\n.. code-block::\n\n    $ songpal discover\n\n    Discovering for 3 seconds\n    Found HT-XT3 - BAR-2015\n    * API version: 1.0\n    * Endpoint: http://192.168.1.1:10000/sony\n    * Services:\n      - Service: guide\n      - Service: system\n      - Service: audio\n      - Service: avContent\n\n\nThis will run a UPnP discovery to find out responsive devices\nimplementing the ScalarWebAPI.\n\n.. WARNING::\n  If you are running the command on another network than the device\n  is residing, you will need to locate the endpoint with some other means.\n\nThe endpoint can be defined with ``--endpoint`` option, or alternatively\n``SONGPAL_ENDPOINT`` environment variable can be set.\n\nGeneral Usage\n~~~~~~~~~~~~~\n\nThe accompanied ``songpal`` tool can be used to control your device.\nAll available commands can be listed with ``--help`` and more help on each\ncommand can be obtained by passing it to the sub-command, e.g., ``songpal power --help``.\nMost interesting commands are most likely ``power``, ``output``, ``volume``, and ``sound``.\n\nGenerally speaking invoking a command without any parameters will display\nsome relevant information like settings or active output.\n\nFor debugging ``-d`` (``--debug``) can be passed\n-- also multiple times for increased verbosity -- for\nprotocol-level information.\n\nSome of the commands can be used to adjust settings related to that functionality,\nusually by passing the `target` and its wanted `value` as parameters to the command.\n\n.. code-block::\n\n    $ songpal bluetooth mode off\n\nOn commands which are not mainly used for settings, such as power_, require\nexplicit `set` sub-command for changing the settings.\n\n.. WARNING::\n\n   Refer to help of the specific command to find the correct format.\n\n   TODO: Make the CLI consistent on this.\n\nStatus\n------\n\n.. code-block::\n\n    $ songpal status\n\n\nwill display some basic information about the device,\nsuch as whether it is powered on and what are its volume settings.\n\n.. _power:\n\nPower Control\n-------------\n\n``power`` command can be used to both turning the device on and off,\nand change its power settings.\n\n.. code-block:: bash\n\n    $ songpal power\n\n    $ songpal power settings\n\n    $ songpal power\n\n    $ songpal power set quickStartMode on\n\n.. NOTE::\n   For turning on the device the quick boot has to be activated;\n   a patch for adding wake-on-lan support to allow starting the device\n   without quick boot are welcome.\n\n.. WARNING::\n   The device seems to report sometimes its status to be off even\n   when that is not the case (may be related to quick boot mode being 'on').\n\n   Please enable it and restart the device fully before reporting a bug\n   related to this.\n\nVolume Control\n--------------\n\n.. code-block::\n\n    $ songpal volume [-- output 'output title'] [<value>|mute|unmute]\n\n    $ songpal volume 20\n\n    $ songpal volume +5\n\n    $ songpal volume -10\n\n    $ songpal volume --output 'Zone 2'\n\n\n    $ songpal volume --output 'Main Zone' 15\n\nSound Settings\n--------------\n\nYour device may support various sound-related settings,\nsuch as night mode or adjusting the subwoofer volume.\n\n.. code-block::\n\n    $ songpal sound\n\n    $ songpal sound nightMode off\n\n    $ songpal sound subwooferLevel 4\n\n\nZone Control\n--------------\n\n.. code-block::\n\n    $ songpal zone \n\n    Zones:\n      * Main Zone (uri: extOutput:zone?zone=1) (active)\n      * Zone 2 (uri: extOutput:zone?zone=2) (active)\n      * Zone 3 (uri: extOutput:zone?zone=3)\n      * HDMI Zone (uri: extOutput:zone?zone=4)\n\n    $ songpal zone 'Main Zone'\n\n    Activating Main Zone (uri: extOutput:zone?zone=1) (active)\n\n    $ songpal zone 'Zone 2' true\n    \n    Activating Zone 2 (uri: extOutput:zone?zone=2) (active)\n\n    $ songpal zone 'Zone 2' false\n    \n    Deactivating Zone 2 (uri: extOutput:zone?zone=2) (active)\n\nInput Control\n--------------\n\nwithout zones:\n.. code-block::\n\n    $ songpal input\n          * HDMI1 (uri: extInput:hdmi?port=1)\n          * HDMI2 (uri: extInput:hdmi?port=2) (active)\n          * HDMI3 (uri: extInput:hdmi?port=3)\n\n    $ songpal input HDMI1\n\n\nwith zones:\n.. code-block::\n\n    $ songpal input\n\n    Inputs:\n      * SOURCE (uri: extInput:source)\n        - extOutput:zone?zone=2\n        - extOutput:zone?zone=3\n        - extOutput:zone?zone=4\n      * GAME (uri: extInput:game) (active)\n        - extOutput:zone?zone=1\n        - extOutput:zone?zone=4\n      * SAT/CATV (uri: extInput:sat-catv)\n        - extOutput:zone?zone=1\n        - extOutput:zone?zone=2\n        - extOutput:zone?zone=3\n        - extOutput:zone?zone=4\n      * VIDEO 1 (uri: extInput:video?port=1)\n        - extOutput:zone?zone=1\n        - extOutput:zone?zone=2\n        - extOutput:zone?zone=3\n        - extOutput:zone?zone=4\n      * VIDEO 2 (uri: extInput:video?port=2)\n        - extOutput:zone?zone=1\n        - extOutput:zone?zone=4\n      * TV (uri: extInput:tv)\n        - extOutput:zone?zone=1\n      * SA-CD/CD (uri: extInput:sacd-cd)\n        - extOutput:zone?zone=1\n        - extOutput:zone?zone=2\n        - extOutput:zone?zone=3\n        - extOutput:zone?zone=4\n      * Bluetooth Audio (uri: extInput:btAudio)\n        - extOutput:zone?zone=1\n        - extOutput:zone?zone=2\n        - extOutput:zone?zone=3\n\n    $ songpal input 'VIDEO 1'\n\n    $ songpal input 'SOURCE' --output 'Zone 2'\n\n\nDevice Settings\n---------------\n\nTo list available settings, use ``settings`` command.\n\n.. code-block:: bash\n\n    $ songpal settings\n\n\nDo note that some settings (e.g. bluetooth settings) are not listed in the\nglobal settings tree, but have to be separatedly accessed using the ``bluetooth`` command.\n\n.. NOTE::\n\n    Setting global settings directly via the CLI is not currently supported,\n    but can potentially be accessed via their respective commands:\n    ``bluetooth``, ``sound``, ``power``.\n\n    Patches improving this are welcome!\n\n\nExecuting custom commands\n-------------------------\n\nFor experimenting it can be useful to execute arbitrary commands against the endpoint.\nYou can access the available methods by calling ``songpal list-all``.\n\n``command`` can be used for that as follows:\n\n.. code-block::\n\n    $ songpal command system getSystemInformation\n\n\nNotification support\n--------------------\n\nThe protocol supports subscribing to notifications on subsystem basis.\nExecuting `songpal notifications` without any parameters will list\navailable notifications.\n\nEvery notification can be listened to separately, or alternatively\nall notifications from a single subsystem can be subscribed to.\n\n.. code-block::\n\n    $ songpal notifications --listen-all avContent\n\nContributing\n------------\n\nReporting bugs or supported devices\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nWhen reporting bugs or informing about supported device not listed above,\nplease consider attaching the output of ``songpal dump-devinfo`` with your report.\n\n\nAPI information\n~~~~~~~~~~~~~~~\n\n`Audio Control API <https://developer.sony.com/develop/audio-control-api/>`_ describes\nthe API this project (currently partially) implements.\n\nThe `Camera Remote API <https://developer.sony.com/develop/cameras/get-started/>`_\nis also similar to this, and may also be useful for developers.\n\n\nHome Assistant support\n----------------------\n\nHome Assistant supports devices using this library directly since 0.65: https://home-assistant.io/components/media_player.songpal/\n\n\n.. |PyPI version| image:: https://badge.fury.io/py/python-songpal.svg\n   :target: https://badge.fury.io/py/python-songpal\n\n.. |Black| image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :target: https://github.com/psf/black\n",
    'author': 'Teemu R',
    'author_email': 'tpr@iki.fi',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/rytilahti/python-songpal',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
