# Generated by Django 3.1.2 on 2020-11-15 11:40

import django.contrib.auth.models
import django.contrib.postgres.fields.jsonb
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('magplan', '0001_initial'),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('user_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
                ('meta', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
            ],
            options={
                'permissions': (('access_magplan', 'Can access magplan'), ('manage_authors', 'Can manage authors')),
            },
            bases=('main.user',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Widget',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('_old_id', models.PositiveIntegerField(blank=True, null=True)),
                ('content', models.TextField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Widgetype',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('_old_id', models.PositiveIntegerField(blank=True, null=True)),
                ('slug', models.SlugField(max_length=255)),
                ('title', models.CharField(max_length=255)),
                ('meta', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Vote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('_old_id', models.PositiveIntegerField(blank=True, null=True)),
                ('score', models.SmallIntegerField(choices=[(0, 'Против таких статей в «Хакере»'), (25, 'Не верю, что выйдет хорошо'), (50, 'Тема нормальная, но не для меня'), (75, 'Почитал бы, встретив в журнале'), (100, 'Ради таких статей мог бы подписаться')], default=50)),
                ('idea', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='votes', to='magplan.idea')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='magplan.user')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='stage',
            name='assignee',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='magplan.user'),
        ),
        migrations.AddField(
            model_name='stage',
            name='next_stage',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='p_stage', to='magplan.stage'),
        ),
        migrations.AddField(
            model_name='stage',
            name='prev_stage',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='n_stage', to='magplan.stage'),
        ),
        migrations.AddField(
            model_name='profile',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='profile', to='magplan.user'),
        ),
        migrations.AddField(
            model_name='post',
            name='authors',
            field=models.ManyToManyField(to='magplan.User', verbose_name='Авторы'),
        ),
        migrations.AddField(
            model_name='post',
            name='editor',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='edited', to='magplan.user', verbose_name='Редактор'),
        ),
        migrations.AddField(
            model_name='post',
            name='issues',
            field=models.ManyToManyField(related_name='posts', to='magplan.Issue', verbose_name='Выпуски'),
        ),
        migrations.AddField(
            model_name='post',
            name='last_updater',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='posts_updated', to='magplan.user', verbose_name='Кто последний обновлял'),
        ),
        migrations.AddField(
            model_name='post',
            name='postype',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='magplan.postype'),
        ),
        migrations.AddField(
            model_name='post',
            name='section',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='magplan.section', verbose_name='Раздел'),
        ),
        migrations.AddField(
            model_name='post',
            name='stage',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='magplan.stage', verbose_name='Этап'),
        ),
        migrations.AddField(
            model_name='issue',
            name='magazine',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='magplan.magazine'),
        ),
        migrations.AddField(
            model_name='idea',
            name='authors',
            field=models.ManyToManyField(blank=True, related_name='authors', to='magplan.User', verbose_name='Авторы'),
        ),
        migrations.AddField(
            model_name='idea',
            name='editor',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='editor', to='magplan.user'),
        ),
        migrations.AddField(
            model_name='idea',
            name='post',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='magplan.post'),
        ),
        migrations.AddField(
            model_name='comment',
            name='content_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype'),
        ),
        migrations.AddField(
            model_name='comment',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='magplan.user'),
        ),
        migrations.AddField(
            model_name='attachment',
            name='post',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='magplan.post'),
        ),
        migrations.AddField(
            model_name='attachment',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='magplan.user'),
        ),
    ]
