"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import cosmos.base.v1beta1.coin_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _LockQueryType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LockQueryTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LockQueryType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ByDuration: _LockQueryType.ValueType  # 0
    ByTime: _LockQueryType.ValueType  # 1

class LockQueryType(_LockQueryType, metaclass=_LockQueryTypeEnumTypeWrapper):
    """LockQueryType defines the type of the lock query that can
    either be by duration or start time of the lock.
    """

ByDuration: LockQueryType.ValueType  # 0
ByTime: LockQueryType.ValueType  # 1
global___LockQueryType = LockQueryType

@typing_extensions.final
class PeriodLock(google.protobuf.message.Message):
    """PeriodLock is a single lock unit by period defined by the x/lockup module.
    It's a record of a locked coin at a specific time. It stores owner, duration,
    unlock time and the number of coins locked. A state of a period lock is
    created upon lock creation, and deleted once the lock has been matured after
    the `duration` has passed since unbonding started.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    COINS_FIELD_NUMBER: builtins.int
    ID: builtins.int
    """ID is the unique id of the lock.
    The ID of the lock is decided upon lock creation, incrementing by 1 for
    every lock.
    """
    owner: builtins.str
    """Owner is the account address of the lock owner.
    Only the owner can modify the state of the lock.
    """
    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration:
        """Duration is the time needed for a lock to mature after unlocking has
        started.
        """
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """EndTime refers to the time at which the lock would mature and get deleted.
        This value is first initialized when an unlock has started for the lock,
        end time being block time + duration.
        """
    @property
    def coins(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[cosmos.base.v1beta1.coin_pb2.Coin]:
        """Coins are the tokens locked within the lock, kept in the module account."""
    def __init__(
        self,
        *,
        ID: builtins.int = ...,
        owner: builtins.str = ...,
        duration: google.protobuf.duration_pb2.Duration | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        coins: collections.abc.Iterable[cosmos.base.v1beta1.coin_pb2.Coin] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["duration", b"duration", "end_time", b"end_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["ID", b"ID", "coins", b"coins", "duration", b"duration", "end_time", b"end_time", "owner", b"owner"]) -> None: ...

global___PeriodLock = PeriodLock

@typing_extensions.final
class QueryCondition(google.protobuf.message.Message):
    """QueryCondition is a struct used for querying locks upon different conditions.
    Duration field and timestamp fields could be optional, depending on the
    LockQueryType.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOCK_QUERY_TYPE_FIELD_NUMBER: builtins.int
    DENOM_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    lock_query_type: global___LockQueryType.ValueType
    """LockQueryType is a type of lock query, ByLockDuration | ByLockTime"""
    denom: builtins.str
    """Denom represents the token denomination we are looking to lock up"""
    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration:
        """Duration is used to query locks with longer duration than the specified
        duration. Duration field must not be nil when the lock query type is
        `ByLockDuration`.
        """
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp is used by locks started before the specified duration.
        Timestamp field must not be nil when the lock query type is `ByLockTime`.
        Querying locks with timestamp is currently not implemented.
        """
    def __init__(
        self,
        *,
        lock_query_type: global___LockQueryType.ValueType = ...,
        denom: builtins.str = ...,
        duration: google.protobuf.duration_pb2.Duration | None = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["duration", b"duration", "timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["denom", b"denom", "duration", b"duration", "lock_query_type", b"lock_query_type", "timestamp", b"timestamp"]) -> None: ...

global___QueryCondition = QueryCondition

@typing_extensions.final
class SyntheticLock(google.protobuf.message.Message):
    """SyntheticLock is creating virtual lockup where new denom is combination of
    original denom and synthetic suffix. At the time of synthetic lockup creation
    and deletion, accumulation store is also being updated and on querier side,
    they can query as freely as native lockup.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UNDERLYING_LOCK_ID_FIELD_NUMBER: builtins.int
    SYNTH_DENOM_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    underlying_lock_id: builtins.int
    """Underlying Lock ID is the underlying native lock's id for this synthetic
    lockup. A synthetic lock MUST have an underlying lock.
    """
    synth_denom: builtins.str
    """SynthDenom is the synthetic denom that is a combination of
    gamm share + bonding status + validator address.
    """
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """used for unbonding synthetic lockups, for active synthetic lockups, this
        value is set to uninitialized value
        """
    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration:
        """Duration is the duration for a synthetic lock to mature
        at the point of unbonding has started.
        """
    def __init__(
        self,
        *,
        underlying_lock_id: builtins.int = ...,
        synth_denom: builtins.str = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        duration: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["duration", b"duration", "end_time", b"end_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["duration", b"duration", "end_time", b"end_time", "synth_denom", b"synth_denom", "underlying_lock_id", b"underlying_lock_id"]) -> None: ...

global___SyntheticLock = SyntheticLock
