"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import cosmos.base.v1beta1.coin_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import osmosis.lockup.lock_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Gauge(google.protobuf.message.Message):
    """Gauge is an object that stores and distributes yields to recipients who
    satisfy certain conditions. Currently gauges support conditions around the
    duration for which a given denom is locked.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    IS_PERPETUAL_FIELD_NUMBER: builtins.int
    DISTRIBUTE_TO_FIELD_NUMBER: builtins.int
    COINS_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    NUM_EPOCHS_PAID_OVER_FIELD_NUMBER: builtins.int
    FILLED_EPOCHS_FIELD_NUMBER: builtins.int
    DISTRIBUTED_COINS_FIELD_NUMBER: builtins.int
    id: builtins.int
    """id is the unique ID of a Gauge"""
    is_perpetual: builtins.bool
    """is_perpetual is a flag to show if it's a perpetual or non-perpetual gauge
    Non-perpetual gauges distribute their tokens equally per epoch while the
    gauge is in the active period. Perpetual gauges distribute all their tokens
    at a single time and only distribute their tokens again once the gauge is
    refilled, Intended for use with incentives that get refilled daily.
    """
    @property
    def distribute_to(self) -> osmosis.lockup.lock_pb2.QueryCondition:
        """distribute_to is where the gauge rewards are distributed to.
        This is queried via lock duration or by timestamp
        """
    @property
    def coins(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[cosmos.base.v1beta1.coin_pb2.Coin]:
        """coins is the total amount of coins that have been in the gauge
        Can distribute multiple coin denoms
        """
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """start_time is the distribution start time"""
    num_epochs_paid_over: builtins.int
    """num_epochs_paid_over is the number of total epochs distribution will be
    completed over
    """
    filled_epochs: builtins.int
    """filled_epochs is the number of epochs distribution has been completed on
    already
    """
    @property
    def distributed_coins(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[cosmos.base.v1beta1.coin_pb2.Coin]:
        """distributed_coins are coins that have been distributed already"""
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        is_perpetual: builtins.bool = ...,
        distribute_to: osmosis.lockup.lock_pb2.QueryCondition | None = ...,
        coins: collections.abc.Iterable[cosmos.base.v1beta1.coin_pb2.Coin] | None = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        num_epochs_paid_over: builtins.int = ...,
        filled_epochs: builtins.int = ...,
        distributed_coins: collections.abc.Iterable[cosmos.base.v1beta1.coin_pb2.Coin] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["distribute_to", b"distribute_to", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["coins", b"coins", "distribute_to", b"distribute_to", "distributed_coins", b"distributed_coins", "filled_epochs", b"filled_epochs", "id", b"id", "is_perpetual", b"is_perpetual", "num_epochs_paid_over", b"num_epochs_paid_over", "start_time", b"start_time"]) -> None: ...

global___Gauge = Gauge

@typing_extensions.final
class LockableDurationsInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOCKABLE_DURATIONS_FIELD_NUMBER: builtins.int
    @property
    def lockable_durations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.duration_pb2.Duration]:
        """List of incentivised durations that gauges will pay out to"""
    def __init__(
        self,
        *,
        lockable_durations: collections.abc.Iterable[google.protobuf.duration_pb2.Duration] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["lockable_durations", b"lockable_durations"]) -> None: ...

global___LockableDurationsInfo = LockableDurationsInfo
