"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class EpochInfo(google.protobuf.message.Message):
    """EpochInfo is a struct that describes the data going into
    a timer defined by the x/epochs module.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDENTIFIER_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    CURRENT_EPOCH_FIELD_NUMBER: builtins.int
    CURRENT_EPOCH_START_TIME_FIELD_NUMBER: builtins.int
    EPOCH_COUNTING_STARTED_FIELD_NUMBER: builtins.int
    CURRENT_EPOCH_START_HEIGHT_FIELD_NUMBER: builtins.int
    identifier: builtins.str
    """identifier is a unique reference to this particular timer."""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """start_time is the time at which the timer first ever ticks.
        If start_time is in the future, the epoch will not begin until the start
        time.
        """
    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration:
        """duration is the time in between epoch ticks.
        In order for intended behavior to be met, duration should
        be greater than the chains expected block time.
        Duration must be non-zero.
        """
    current_epoch: builtins.int
    """current_epoch is the current epoch number, or in other words,
    how many times has the timer 'ticked'.
    The first tick (current_epoch=1) is defined as
    the first block whose blocktime is greater than the EpochInfo start_time.
    """
    @property
    def current_epoch_start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """current_epoch_start_time describes the start time of the current timer
        interval. The interval is (current_epoch_start_time,
        current_epoch_start_time + duration] When the timer ticks, this is set to
        current_epoch_start_time = last_epoch_start_time + duration only one timer
        tick for a given identifier can occur per block.

        NOTE! The current_epoch_start_time may diverge significantly from the
        wall-clock time the epoch began at. Wall-clock time of epoch start may be
        >> current_epoch_start_time. Suppose current_epoch_start_time = 10,
        duration = 5. Suppose the chain goes offline at t=14, and comes back online
        at t=30, and produces blocks at every successive time. (t=31, 32, etc.)
        * The t=30 block will start the epoch for (10, 15]
        * The t=31 block will start the epoch for (15, 20]
        * The t=32 block will start the epoch for (20, 25]
        * The t=33 block will start the epoch for (25, 30]
        * The t=34 block will start the epoch for (30, 35]
        * The **t=36** block will start the epoch for (35, 40]
        """
    epoch_counting_started: builtins.bool
    """epoch_counting_started is a boolean, that indicates whether this
    epoch timer has began yet.
    """
    current_epoch_start_height: builtins.int
    """current_epoch_start_height is the block height at which the current epoch
    started. (The block height at which the timer last ticked)
    """
    def __init__(
        self,
        *,
        identifier: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        duration: google.protobuf.duration_pb2.Duration | None = ...,
        current_epoch: builtins.int = ...,
        current_epoch_start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        epoch_counting_started: builtins.bool = ...,
        current_epoch_start_height: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["current_epoch_start_time", b"current_epoch_start_time", "duration", b"duration", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["current_epoch", b"current_epoch", "current_epoch_start_height", b"current_epoch_start_height", "current_epoch_start_time", b"current_epoch_start_time", "duration", b"duration", "epoch_counting_started", b"epoch_counting_started", "identifier", b"identifier", "start_time", b"start_time"]) -> None: ...

global___EpochInfo = EpochInfo

@typing_extensions.final
class GenesisState(google.protobuf.message.Message):
    """GenesisState defines the epochs module's genesis state."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPOCHS_FIELD_NUMBER: builtins.int
    @property
    def epochs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EpochInfo]: ...
    def __init__(
        self,
        *,
        epochs: collections.abc.Iterable[global___EpochInfo] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["epochs", b"epochs"]) -> None: ...

global___GenesisState = GenesisState
