import "core-js/modules/es.array.iterator";
import "core-js/modules/es.string.ends-with";
import "core-js/modules/es.string.includes";
import "core-js/modules/es.string.replace";
import "core-js/modules/es.string.starts-with";
import "core-js/modules/web.dom-collections.iterator";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { WidgetModel } from '@jupyter-widgets/base';
import uuid4 from 'uuid/v4';
import _ from 'lodash';
import Vue from 'vue';
import { parseComponent } from '@mariobuikhuizen/vue-compiler-addon';
import { createObjectForNestedModel, eventToObject, vueRender } from './VueRenderer'; // eslint-disable-line import/no-cycle

import { VueModel } from './VueModel';
import { VueTemplateModel } from './VueTemplateModel';
import httpVueLoader from './httpVueLoader';
export function vueTemplateRender(createElement, model, parentView) {
  return createElement(createComponentObject(model, parentView));
}

function createComponentObject(model, parentView) {
  if (model instanceof VueModel) {
    return {
      render(createElement) {
        return vueRender(createElement, model, parentView, {});
      }

    };
  }

  if (!(model instanceof VueTemplateModel)) {
    return createObjectForNestedModel(model, parentView);
  }

  const vuefile = readVueFile(model.get('template'));
  const css = model.get('css') || vuefile.STYLE && vuefile.STYLE.content;
  const cssId = vuefile.STYLE && vuefile.STYLE.id;

  if (css) {
    if (cssId) {
      const prefixedCssId = "ipyvue-".concat(cssId);
      let style = document.getElementById(prefixedCssId);

      if (!style) {
        style = document.createElement('style');
        style.id = prefixedCssId;
        document.head.appendChild(style);
      }

      if (style.innerHTML !== css) {
        style.innerHTML = css;
      }
    } else {
      const style = document.createElement('style');
      style.id = model.cid;
      style.innerHTML = css;
      document.head.appendChild(style);
      parentView.once('remove', () => {
        document.head.removeChild(style);
      });
    }
  } // eslint-disable-next-line no-new-func


  const methods = model.get('methods') ? Function("return ".concat(model.get('methods').replace('\n', ' ')))() : {}; // eslint-disable-next-line no-new-func

  const data = model.get('data') ? Function("return ".concat(model.get('data').replace('\n', ' ')))() : {};
  const componentEntries = Object.entries(model.get('components') || {});
  const instanceComponents = componentEntries.filter((_ref) => {
    let [, v] = _ref;
    return v instanceof WidgetModel;
  });
  const classComponents = componentEntries.filter((_ref2) => {
    let [, v] = _ref2;
    return !(v instanceof WidgetModel) && !(typeof v === 'string');
  });
  const fullVueComponents = componentEntries.filter((_ref3) => {
    let [, v] = _ref3;
    return typeof v === 'string';
  });

  function callVueFn(name, this_) {
    if (vuefile.SCRIPT && vuefile.SCRIPT[name]) {
      vuefile.SCRIPT[name].bind(this_)();
    }
  }

  return {
    data() {
      return _objectSpread({}, data, {}, createDataMapping(model));
    },

    beforeCreate() {
      callVueFn('beforeCreate', this);
    },

    created() {
      addModelListeners(model, this);
      callVueFn('created', this);
    },

    watch: createWatches(model, parentView, vuefile.SCRIPT && vuefile.SCRIPT.watch),
    methods: _objectSpread({}, vuefile.SCRIPT && vuefile.SCRIPT.methods, {}, methods, {}, createMethods(model, parentView)),
    components: _objectSpread({}, createInstanceComponents(instanceComponents, parentView), {}, createClassComponents(classComponents, model, parentView), {}, createFullVueComponents(fullVueComponents)),
    computed: _objectSpread({}, vuefile.SCRIPT && vuefile.SCRIPT.computed, {}, aliasRefProps(model)),
    template: vuefile.TEMPLATE || model.get('template'),

    beforeMount() {
      callVueFn('beforeMount', this);
    },

    mounted() {
      callVueFn('mounted', this);
    },

    beforeUpdate() {
      callVueFn('beforeUpdate', this);
    },

    updated() {
      callVueFn('updated', this);
    },

    beforeDestroy() {
      callVueFn('beforeDestroy', this);
    },

    destroyed() {
      callVueFn('destroyed', this);
    }

  };
}

function createDataMapping(model) {
  return model.keys().filter(prop => !prop.startsWith('_') && !['events', 'template', 'components', 'layout', 'css', 'data', 'methods'].includes(prop)).reduce((result, prop) => {
    result[prop] = _.cloneDeep(model.get(prop)); // eslint-disable-line no-param-reassign

    return result;
  }, {});
}

function addModelListeners(model, vueModel) {
  model.keys().filter(prop => !prop.startsWith('_') && !['v_model', 'components', 'layout', 'css', 'data', 'methods'].includes(prop)) // eslint-disable-next-line no-param-reassign
  .forEach(prop => model.on("change:".concat(prop), () => {
    if (_.isEqual(model.get(prop), vueModel[prop])) {
      return;
    }

    vueModel[prop] = _.cloneDeep(model.get(prop));
  }));
}

function createWatches(model, parentView, templateWatchers) {
  return model.keys().filter(prop => !prop.startsWith('_') && !['events', 'template', 'components', 'layout', 'css', 'data', 'methods'].includes(prop)).reduce((result, prop) => _objectSpread({}, result, {
    [prop]: {
      handler(value) {
        if (templateWatchers && templateWatchers[prop]) {
          templateWatchers[prop].bind(this)(value);
        }
        /* Don't send changes received from backend back */


        if (_.isEqual(value, model.get(prop))) {
          return;
        }

        model.set(prop, value === undefined ? null : _.cloneDeep(value));
        model.save_changes(model.callbacks(parentView));
      },

      deep: true
    }
  }), {});
}

function createMethods(model, parentView) {
  return model.get('events').reduce((result, event) => {
    // eslint-disable-next-line no-param-reassign
    result[event] = value => model.send({
      event,
      data: eventToObject(value)
    }, model.callbacks(parentView));

    return result;
  }, {});
}

function createInstanceComponents(components, parentView) {
  return components.reduce((result, _ref4) => {
    let [name, model] = _ref4;
    // eslint-disable-next-line no-param-reassign
    result[name] = createComponentObject(model, parentView);
    return result;
  }, {});
}

function createClassComponents(components, containerModel, parentView) {
  return components.reduce((accumulator, _ref5) => {
    let [componentName, componentSpec] = _ref5;
    return _objectSpread({}, accumulator, {
      [componentName]: {
        /* TODO: handle naming collisions. Ignore style traitlet for now */
        props: componentSpec.props.filter(p => p !== 'style'),

        data() {
          return {
            model: null,
            id: uuid4()
          };
        },

        created() {
          const fn = () => {
            if (!this.model) {
              const newModel = containerModel.get('_component_instances').find(wm => wm.model_id === this.id);

              if (newModel) {
                this.model = newModel;
              }
            } else {
              containerModel.off('change:_component_instances', fn);
            }
          };

          containerModel.on('change:_component_instances', fn);
          containerModel.send({
            create_widget: componentSpec.class,
            // eslint-disable-line camelcase
            id: this.id,
            props: this.$options.propsData
          }, containerModel.callbacks(parentView));
        },

        destroyed() {
          containerModel.send({
            destroy_widget: this.id // eslint-disable-line camelcase

          }, containerModel.callbacks(parentView));
        },

        watch: componentSpec.props.reduce((watchAccumulator, prop) => _objectSpread({}, watchAccumulator, {
          [prop](value) {
            if (value.objectRef) {
              containerModel.send({
                update_ref: value,
                // eslint-disable-line camelcase
                prop,
                id: this.id
              }, containerModel.callbacks(parentView));
            } else {
              this.model.set(prop, value);
              this.model.save_changes(this.model.callbacks(parentView));
            }
          }

        }), {}),

        render(createElement) {
          if (this.model) {
            return vueRender(createElement, this.model, parentView, {});
          }

          return createElement('div', ['temp-content']);
        }

      }
    });
  }, {});
}

function createFullVueComponents(components) {
  return components.reduce((accumulator, _ref6) => {
    let [componentName, vueFile] = _ref6;
    return _objectSpread({}, accumulator, {
      [componentName]: httpVueLoader(vueFile)
    });
  }, {});
}
/* Returns a map with computed properties so that myProp_ref is available as myProp in the template
 * (only if myProp does not exist).
 */


function aliasRefProps(model) {
  return model.keys().filter(key => key.endsWith('_ref')).map(propRef => [propRef, propRef.substring(0, propRef.length - 4)]).filter((_ref7) => {
    let [, prop] = _ref7;
    return !model.keys().includes(prop);
  }).reduce((accumulator, _ref8) => {
    let [propRef, prop] = _ref8;
    return _objectSpread({}, accumulator, {
      [prop]() {
        return this[propRef];
      }

    });
  }, {});
}

function readVueFile(fileContent) {
  const component = parseComponent(fileContent, {
    pad: 'line'
  });
  const result = {};

  if (component.template) {
    result.TEMPLATE = component.template.content;
  }

  if (component.script) {
    const {
      content
    } = component.script;
    const str = content.substring(content.indexOf('{'), content.length).replace('\n', ' '); // eslint-disable-next-line no-new-func

    result.SCRIPT = Function("return ".concat(str))();
  }

  if (component.styles && component.styles.length > 0) {
    const {
      content
    } = component.styles[0];
    const {
      id
    } = component.styles[0].attrs;
    result.STYLE = {
      content,
      id
    };
  }

  return result;
}

Vue.component('jupyter-widget', {
  props: ['widget'],
  inject: ['viewCtx'],

  data() {
    return {
      component: null
    };
  },

  created() {
    this.update();
  },

  watch: {
    widget() {
      this.update();
    }

  },
  methods: {
    update() {
      this.viewCtx.getModelById(this.widget.substring(10)).then(mdl => {
        this.component = createComponentObject(mdl, this.viewCtx.getView());
      });
    }

  },

  render(createElement) {
    if (!this.component) {
      return createElement('div');
    }

    return createElement(this.component);
  }

});