## EVer - A Library for Earth Vision Researcher


EVer is a Pytorch-based Python library to simplify the training and inference of the deep learning model.

> This is a **beta** version for research only.


## Features

- Common codebase for reproducible research
- Accelerating our Earth Vision research
- Single workflow of "data-module-configs"


## Installation

### stable version (0.2.2)
```bash
pip install ever-beta==0.2.2
```

### nightly version (master)
```bash
pip install --upgrade git+https://github.com/Z-Zheng/ever.git
```


## Getting Started
[Basic Usage](https://github.com/Z-Zheng/ever/tree/master/docs/USAGE.md)

## Projects using EVer or [SimpleCV](https://github.com/Z-Zheng/SimpleCV)

### Change Detection
- Change is Everywhere: Single-Temporal Supervised Object Change Detection
in Remote Sensing Imagery, ICCV 2021. [[`Paper`](https://arxiv.org/abs/2108.07002)], [[`Code`](https://github.com/Z-Zheng/ChangeStar)]

- Building damage assessment for rapid disaster response with a deep object-based semantic change detection framework: from natural disasters to man-made disasters, RSE 2021. [[`Paper`](#)], [[`Code`](https://github.com/Z-Zheng/ChangeOS)]

### Segmentation
- Foreground-Aware Relation Network for Geospatial Object Segmentation in High Spatial Resolution Remote Sensing Imagery, CVPR 2020. [[`Paper`](https://arxiv.org/pdf/2011.09766.pdf)], [[`Code`](https://github.com/Z-Zheng/FarSeg)]
- Deep multisensor learning for missing-modality all-weather mapping, ISPRS P&RS 2021. [[`Paper`](https://www.sciencedirect.com/science/article/abs/pii/S0924271620303476)], [[`Code`](https://github.com/Z-Zheng/FarSeg)]

- FactSeg: Foreground Activation Driven Small Object Semantic Segmentation in Large-Scale Remote Sensing Imagery, TGRS 2021. [[`Paper`](https://www.researchgate.net/publication/353357122_FactSeg_Foreground_Activation_Driven_Small_Object_Semantic_Segmentation_in_Large-Scale_Remote_Sensing_Imagery)], [[`Code`](https://github.com/Junjue-Wang/FactSeg)]

### Hyperspectral Image Classification
- FPGA: Fast Patch-Free Global Learning Framework for Fully End-to-End Hyperspectral Image Classification, TGRS 2020. [[`Paper`](https://ieeexplore.ieee.org/document/9007624)], [[`Code`](https://github.com/Z-Zheng/FreeNet)]

- A Spectral-Spatial-Dependent Global Learning Framework for Insufficient and Imbalanced Hyperspectral Image Classification, TCYB 2021. [[`Paper`](https://arxiv.org/abs/2105.14327)], [[`Code`](https://github.com/dengweihuan/SSDGL)]


## License
EVer is released under the [Apache License 2.0](https://github.com/Z-Zheng/ever/blob/master/LICENSE).

Copyright (c) Zhuo Zheng. All rights reserved.
