"""Constants used in the program's logic."""

# Dictionary of Azuracast API Endpoints
API_ENDPOINTS = {
    "all_now_playing":            "{radio_url}/api/nowplaying",
    "station_now_playing":        "{radio_url}/api/nowplaying/{station_id}",
    "station_fallback":           "{radio_url}/api/station/{station_id}/fallback",
    "stations":                   "{radio_url}/api/stations",
    "station":                    "{radio_url}/api/station/{station_id}",
    "station_stereo_tool_config": "{radio_url}/api/station/{station_id}/stereo-tool-configuration",
    "requestable_songs":          "{radio_url}/api/station/{station_id}/requests",
    "song_request":               "{radio_url}/api/station/{station_id}/request/{request_id}",
    "station_status":             "{radio_url}/api/station/{station_id}/status",
    "restart_station":            "{radio_url}/api/station/{station_id}/restart",
    "frontend_action":            "{radio_url}/api/station/{station_id}/frontend/{action}",
    "backend_action":             "{radio_url}/api/station/{station_id}/backend/{action}",
    "station_history":            "{radio_url}/api/station/{station_id}/history",
    "hls_streams":                "{radio_url}/api/station/{station_id}/hls_streams",
    "hls_stream":                 "{radio_url}/api/station/{station_id}/hls_stream/{id}",
    "station_listeners":          "{radio_url}/api/station/{station_id}/listeners",
    "station_schedule":           "{radio_url}/api/station/{station_id}/schedule",
    "song_art":                   "{radio_url}/api/station/{station_id}/art/{media_id}",
    "station_files":              "{radio_url}/api/station/{station_id}/files",
    "station_file":               "{radio_url}/api/station/{station_id}/file/{id}",
    "mount_intro_track":          "{radio_url}/api/station/{station_id}/mount/{id}/intro",
    "station_mount_points":       "{radio_url}/api/station/{station_id}/mounts",
    "station_mount_point":        "{radio_url}/api/station/{station_id}/mount/{id}",
    "station_playlists":          "{radio_url}/api/station/{station_id}/playlists",
    "station_playlist":           "{radio_url}/api/station/{station_id}/playlist/{id}",
    "podcast_episodes":           "{radio_url}/api/station/{station_id}/podcast/{podcast_id}/episodes",
    "podcast_episode":            "{radio_url}/api/station/{station_id}/podcast/{podcast_id}/episode/{id}",
    "podcast_art":                "{radio_url}/api/station/{station_id}/podcast/{podcast_id}/art",
    "podcast_episode_art":        "{radio_url}/api/station/{station_id}/podcast/{podcast_id}/episode/{episode_id}/art",
    "podcast_episode_media":      "{radio_url}/api/station/{station_id}/podcast/{podcast_id}/episode/{episode_id}/media",
    "station_podcasts":           "{radio_url}/api/station/{station_id}/podcasts",
    "station_podcast":            "{radio_url}/api/station/{station_id}/podcast/{id}",
    "station_queue":              "{radio_url}/api/station/{station_id}/queue",
    "station_queue_item":         "{radio_url}/api/station/{station_id}/queue/{id}",
    "station_remote_relays":      "{radio_url}/api/station/{station_id}/remotes",
    "station_remote_relay_item":  "{radio_url}/api/station/{station_id}/remote/{id}",
    "station_sftp_users":         "{radio_url}/api/station/{station_id}/sftp-users",
    "station_sftp_user":          "{radio_url}/api/station/{station_id}/sftp-user/{id}",
    "station_streamers":          "{radio_url}/api/station/{station_id}/streamers",
    "station_streamer":           "{radio_url}/api/station/{station_id}/streamer/{id}",
    "station_webhooks":           "{radio_url}/api/station/{station_id}/webhooks",
    "station_webhook":            "{radio_url}/api/station/{station_id}/webhook/{id}",
    "custom_fields":              "{radio_url}/api/admin/custom_fields",
    "custom_field":               "{radio_url}/api/admin/custom_field/{id}",
    "users":                      "{radio_url}/api/admin/users",
    "user":                       "{radio_url}/api/admin/user/{id}",
    "relays":                     "{radio_url}/api/internal/relays",
    "permissions":                "{radio_url}/api/admin/permissions",
    "roles":                      "{radio_url}/api/admin/roles",
    "role":                       "{radio_url}/api/admin/role/{id}",
    "settings":                   "{radio_url}/api/admin/settings",
    "admin_stations":             "{radio_url}/api/admin/stations",
    "admin_station":              "{radio_url}/api/admin/station/{id}",
    "storage_locations":          "{radio_url}/api/admin/storage_locations",
    "storage_location":           "{radio_url}/api/admin/storage_location/{id}",
    "api_status":                 "{radio_url}/api/status",
    "time":                       "{radio_url}/api/time",
    "cpu_stats":                  "{radio_url}/api/admin/server/stats"
}

# Days of the week
DAYS = {
    "monday": 1,
    "tuesday": 2,
    "wednesday": 3,
    "thursday": 4,
    "friday": 5,
    "saturday": 6,
    "sunday": 7
}

# Configuration templates for webhooks
WEBHOOK_CONFIG_TEMPLATES = {
    'generic': ["webhook_url", "basic_auth_username", "basic_auth_password", "timeout"],
    'email': ["to", "subject", "message"],
    'discord': ["webhook_url", "content", "title", "description", "url", "author", "thumbnail", "footer"],
    'telegram': ["bot_token", "chat_id", "api", "text", "parse_mode"],
    'mastodon': [
        "instance_url", "access_token", "visibility", "rate_limit",
        "message", "message_song_changed_live", "message_live_connect",
        "message_live_disconnect", "message_station_offline", "message_station_online"
    ],
    'tunein': ["station_id", "partner_id", "partner_key"],
    'radiode': ["broadcastsubdomain", "apikey"],
    'getmeradio': ["token", "station_id"],
    'google_analytics_v4': ["api_secret", "measurement_id"],
    'matomo_analytics': ["matomo_url", "site_id", "token"],
}
